/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.filamentdetector.analyzer;

import net.imagej.Dataset;
import net.imagej.ops.OpService;
import net.imglib2.histogram.Histogram1d;
import net.imglib2.type.numeric.RealType;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import sc.fiji.filamentdetector.analyzer.AbstractAnalyzer;
import sc.fiji.filamentdetector.analyzer.Analyzer;
import sc.fiji.filamentdetector.model.TrackedFilament;

@Plugin(type=Analyzer.class, priority=100.0)
public class NaiveNucleationAnalyzer
extends AbstractAnalyzer {
    public static String NAME = "Naive Nucleation Analyzer";
    public static String DESCRIPTION = "This module uses the tracked filaments as seeds and look over each frame and both tips whether the intensity is above a specified threshold. If it is then a nucleation event is declared. (this analyzer is in development)";
    @Parameter
    private LogService log;
    @Parameter
    private OpService op;
    private double pixelSpacing = 1.0;
    private double lineThickness = 4.0;
    private double lineLength = 10.0;
    private double intensityThreshold = 100.0;
    private int maxFrame = 15;
    private int channelIndex = 0;
    private boolean colorizedNucleatedSeeds = true;

    public NaiveNucleationAnalyzer() {
        this.setName(NAME);
        this.setDescription(DESCRIPTION);
    }

    @Override
    public String getAnalyzerInfo() {
        String out = "";
        out = out + "Name : " + this.name + "\n";
        out = out + "Save results : " + this.saveResults + "\n";
        out = out + "lineLength : " + this.lineLength + "\n";
        out = out + "pixelSpacing : " + this.pixelSpacing + "\n";
        out = out + "lineThickness : " + this.lineThickness + "\n";
        out = out + "intensityThreshold : " + this.intensityThreshold + "\n";
        out = out + "maxFrame : " + this.maxFrame + "\n";
        out = out + "channelIndex : " + this.channelIndex + "\n";
        out = out + "colorizedNucleatedSeeds : " + this.colorizedNucleatedSeeds + "\n";
        out = out + "\n";
        return out;
    }

    @Override
    public void analyze() {
    }

    private int frameFirstNucleation(TrackedFilament trackedFilament) {
        return -1;
    }

    public double getPixelSpacing() {
        return this.pixelSpacing;
    }

    public void setPixelSpacing(double pixelSpacing) {
        this.pixelSpacing = pixelSpacing;
    }

    public double getLineThickness() {
        return this.lineThickness;
    }

    public void setLineThickness(double lineThickness) {
        this.lineThickness = lineThickness;
    }

    public double getIntensityThreshold() {
        return this.intensityThreshold;
    }

    public void setIntensityThreshold(double intensityThreshold) {
        this.intensityThreshold = intensityThreshold;
    }

    public int getMaxFrame() {
        return this.maxFrame;
    }

    public void setMaxFrame(int maxFrame) {
        this.maxFrame = maxFrame;
    }

    public int getChannelIndex() {
        return this.channelIndex;
    }

    public void setChannelIndex(int channelIndex) {
        this.channelIndex = channelIndex;
    }

    public double getLineLength() {
        return this.lineLength;
    }

    public void setLineLength(double lineLength) {
        this.lineLength = lineLength;
    }

    public boolean isColorizedNucleatedSeeds() {
        return this.colorizedNucleatedSeeds;
    }

    public void setColorizedNucleatedSeeds(boolean colorizedNucleatedSeeds) {
        this.colorizedNucleatedSeeds = colorizedNucleatedSeeds;
    }

    public <T extends RealType<T>> void guessIntensityThresholdFromImage() {
        Dataset data = this.filamentWorkflow.getDataset();
        Histogram1d histogram = this.op.image().histogram((Iterable)data.getImgPlus());
        this.intensityThreshold = ((RealType)this.op.threshold().isoData(histogram).get(0)).getRealDouble();
    }
}

