/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.filamentdetector.gui.controller;

import java.net.URL;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Task;
import javafx.event.Event;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Accordion;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.Slider;
import javafx.scene.control.TextArea;
import javafx.scene.control.TitledPane;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Pane;
import org.scijava.Context;
import org.scijava.app.StatusService;
import org.scijava.event.EventHandler;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import sc.fiji.filamentdetector.FilamentWorkflow;
import sc.fiji.filamentdetector.event.ImageNotFoundEvent;
import sc.fiji.filamentdetector.event.PreventPanelSwitchEvent;
import sc.fiji.filamentdetector.gui.GUIStatusService;
import sc.fiji.filamentdetector.gui.controller.AboutController;
import sc.fiji.filamentdetector.gui.controller.AbstractController;
import sc.fiji.filamentdetector.gui.controller.AnalyzeController;
import sc.fiji.filamentdetector.gui.controller.DataExporterController;
import sc.fiji.filamentdetector.gui.controller.DetectFilamentController;
import sc.fiji.filamentdetector.gui.controller.KymographBuilderController;
import sc.fiji.filamentdetector.gui.controller.TrackingFilamentController;
import sc.fiji.filamentdetector.gui.controller.WelcomeController;
import sc.fiji.filamentdetector.overlay.FilamentOverlayService;
import sc.fiji.filamentdetector.overlay.ImageDisplayMode;

public class MainController
extends AbstractController
implements Initializable {
    @Parameter
    private Context context;
    @Parameter
    private LogService log;
    @Parameter
    private StatusService status;
    @Parameter
    private GUIStatusService guiStatus;
    @Parameter
    private FilamentOverlayService overlay;
    @FXML
    private AnchorPane mainPaneContainer;
    @FXML
    private TextArea logField;
    @FXML
    private Slider transparencySlider;
    @FXML
    private Label transparencyValueLabel;
    @FXML
    private Slider lineWidthSlider;
    @FXML
    private Label lineWidthValueLabel;
    @FXML
    private CheckBox disableOverlaysCheckbox;
    @FXML
    private CheckBox drawBoundsCheckbox;
    @FXML
    private CheckBox drawPlusTipsCheckbox;
    @FXML
    private CheckBox drawMinusTipsCheckbox;
    @FXML
    private Slider tipDiameterSlider;
    @FXML
    private Label tipDiameterValueLabel;
    @FXML
    private Button compositeButton;
    @FXML
    private Button autoScaleButton;
    private FilamentWorkflow filamentWorkflow;
    private Accordion mainPane;
    private WelcomeController welcomeController;
    private DetectFilamentController detectFilamentController;
    private AboutController aboutController;
    private DataExporterController dataExporterController;
    private TrackingFilamentController trackingFilamentController;
    private KymographBuilderController kymographBuilderController;
    private AnalyzeController analyzerController;
    private static boolean originalImageDisapearsMessageShown = false;

    public MainController(Context context, FilamentWorkflow filamentDetector) {
        context.inject((Object)this);
        this.filamentWorkflow = filamentDetector;
    }

    public void initialize(URL url, ResourceBundle resourceBundle) {
    }

    public void loadPanes() {
        ProgressIndicator startupProgress = new ProgressIndicator();
        this.mainPaneContainer.getChildren().add((Object)startupProgress);
        AnchorPane.setTopAnchor((Node)startupProgress, (Double)300.0);
        AnchorPane.setLeftAnchor((Node)startupProgress, (Double)300.0);
        AnchorPane.setRightAnchor((Node)startupProgress, (Double)300.0);
        AnchorPane.setBottomAnchor((Node)startupProgress, (Double)300.0);
        Task<Accordion> startupTask = new Task<Accordion>(){

            protected Accordion call() throws Exception {
                Accordion mainPane = new Accordion();
                AnchorPane.setTopAnchor((Node)mainPane, (Double)0.0);
                AnchorPane.setLeftAnchor((Node)mainPane, (Double)0.0);
                AnchorPane.setRightAnchor((Node)mainPane, (Double)0.0);
                AnchorPane.setBottomAnchor((Node)mainPane, (Double)0.0);
                Platform.runLater(() -> {
                    mainPane.getPanes().add((Object)MainController.this.loadWelcome());
                    mainPane.getPanes().add((Object)MainController.this.loadDetectFilament());
                    mainPane.getPanes().add((Object)MainController.this.loadTrackingFilament());
                    mainPane.getPanes().add((Object)MainController.this.loadDataExporter());
                    mainPane.getPanes().add((Object)MainController.this.loadKymographBuilder());
                    mainPane.getPanes().add((Object)MainController.this.loadAnalyzer());
                    mainPane.getPanes().add((Object)MainController.this.loadAbout());
                    MainController.this.overlay.reset();
                    MainController.this.overlay.setImageDisplay(MainController.this.filamentWorkflow.getImageDisplay());
                    MainController.this.initOverlaySettings();
                });
                MainController.this.setMainPane(mainPane);
                return mainPane;
            }
        };
        startupTask.setOnSucceeded(evt -> {
            this.mainPane.setExpandedPane(this.getTitledPane("Welcome"));
            this.welcomeController.loadImageCalibrations();
            this.mainPaneContainer.getChildren().clear();
            this.mainPaneContainer.getChildren().add((Object)this.mainPane);
            this.status.showStatus("FilamentDetector has been correctly initialized.");
            this.mainPane.expandedPaneProperty().addListener((ChangeListener)new ChangeListener<TitledPane>(){

                public void changed(ObservableValue<? extends TitledPane> ov, TitledPane old_val, TitledPane new_val) {
                    if (new_val != null && new_val.getContent() != null) {
                        if (new_val.getContent().equals(MainController.this.dataExporterController.getPane())) {
                            MainController.this.dataExporterController.refreshData(null);
                        } else if (new_val.getContent().equals(MainController.this.trackingFilamentController.getPane())) {
                            MainController.this.trackingFilamentController.initPane();
                        } else if (new_val.getContent().equals(MainController.this.kymographBuilderController.getPane())) {
                            MainController.this.kymographBuilderController.initPane();
                        } else if (new_val.getContent().equals(MainController.this.analyzerController.getPane())) {
                            MainController.this.analyzerController.initPane();
                        } else if (new_val.getContent().equals(MainController.this.detectFilamentController.getPane())) {
                            MainController.this.detectFilamentController.initPane();
                        }
                    }
                }
            });
        });
        startupProgress.progressProperty().bind((ObservableValue)startupTask.progressProperty());
        new Thread((Runnable)startupTask).start();
        this.guiStatus.setTextField(this.logField);
    }

    private void setMainPane(Accordion mainPane) {
        this.mainPane = mainPane;
    }

    private void initOverlaySettings() {
        this.transparencySlider.valueProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observableValue, Number oldValue, Number newValue) {
                if (newValue == null) {
                    MainController.this.transparencyValueLabel.setText("");
                    return;
                }
                MainController.this.transparencyValueLabel.setText(Math.round(newValue.intValue()) + "");
            }
        });
        this.lineWidthSlider.valueProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observableValue, Number oldValue, Number newValue) {
                if (newValue == null) {
                    MainController.this.lineWidthValueLabel.setText("");
                    return;
                }
                MainController.this.lineWidthValueLabel.setText(Math.round(newValue.intValue()) + "");
            }
        });
        this.tipDiameterSlider.valueProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observableValue, Number oldValue, Number newValue) {
                if (newValue == null) {
                    MainController.this.tipDiameterValueLabel.setText("");
                    return;
                }
                MainController.this.tipDiameterValueLabel.setText(Math.round(newValue.intValue()) + "");
            }
        });
        this.transparencySlider.setValue((double)this.overlay.getColorAlpha());
        this.lineWidthSlider.setValue((double)this.overlay.getFilamentWidth());
        this.tipDiameterSlider.setValue((double)this.overlay.getTipDiameter());
        this.overlay.disableOverlay(false);
        this.disableOverlaysCheckbox.setSelected(false);
        this.drawBoundsCheckbox.setSelected(this.overlay.isDrawBoundingBoxes());
        this.drawPlusTipsCheckbox.setSelected(this.overlay.isDrawPlusTips());
        this.drawMinusTipsCheckbox.setSelected(this.overlay.isDrawMinusTips());
        this.compositeButton.setOnAction(event -> {
            String compositeText = "Composite View";
            String colorText = "One Color View";
            String grayText = "Gray View";
            if (this.compositeButton.getText().equals(compositeText)) {
                this.overlay.setViewMode(ImageDisplayMode.COMPOSITE);
                this.compositeButton.setText(colorText);
            } else if (this.compositeButton.getText().equals(colorText)) {
                this.overlay.setViewMode(ImageDisplayMode.COLOR);
                this.compositeButton.setText(grayText);
            } else if (this.compositeButton.getText().equals(grayText)) {
                this.overlay.setViewMode(ImageDisplayMode.GRAYSCALE);
                this.compositeButton.setText(compositeText);
            } else {
                this.compositeButton.setText(colorText);
            }
        });
        this.autoScaleButton.setOnAction(event -> this.overlay.autoScaleImage());
    }

    @FXML
    void updateOverlaySettings(Event event) {
        if (event.getSource().equals(this.transparencySlider)) {
            this.overlay.setColorAlpha((int)this.transparencySlider.getValue());
            this.overlay.updateTransparency();
        } else if (event.getSource().equals(this.lineWidthSlider)) {
            this.overlay.setFilamentWidth((int)this.lineWidthSlider.getValue());
            this.overlay.updateLineWidth();
        } else {
            this.overlay.setTipDiameter((int)this.tipDiameterSlider.getValue());
            this.overlay.setDrawBoundingBoxes(this.drawBoundsCheckbox.isSelected());
            this.overlay.setDrawPlusTips(this.drawPlusTipsCheckbox.isSelected());
            this.overlay.setDrawMinusTips(this.drawMinusTipsCheckbox.isSelected());
            this.overlay.refresh();
        }
    }

    @FXML
    void exportToROIManager(MouseEvent event) {
        this.overlay.exportToROIManager();
    }

    @FXML
    void updateHideOverlay(MouseEvent event) {
        this.overlay.disableOverlay(!this.disableOverlaysCheckbox.isSelected());
    }

    public TitledPane getTitledPane(String text) {
        return this.mainPane.getPanes().stream().filter(x -> x.getText().equals(text)).findFirst().orElse(null);
    }

    public TitledPane loadWelcome() {
        this.welcomeController = new WelcomeController(this.context, this.filamentWorkflow);
        Pane pane = this.welcomeController.loadPane();
        return new TitledPane("Welcome", (Node)pane);
    }

    public TitledPane loadDetectFilament() {
        this.detectFilamentController = new DetectFilamentController(this.context, this.filamentWorkflow);
        Pane pane = this.detectFilamentController.loadPane();
        return new TitledPane("Detect Filaments", (Node)pane);
    }

    public TitledPane loadTrackingFilament() {
        this.trackingFilamentController = new TrackingFilamentController(this.context, this.filamentWorkflow);
        Pane pane = this.trackingFilamentController.loadPane();
        return new TitledPane("Track Filaments", (Node)pane);
    }

    public TitledPane loadDataExporter() {
        this.dataExporterController = new DataExporterController(this.context, this.filamentWorkflow);
        Pane pane = this.dataExporterController.loadPane();
        return new TitledPane("Export Filaments", (Node)pane);
    }

    public TitledPane loadKymographBuilder() {
        this.kymographBuilderController = new KymographBuilderController(this.context, this.filamentWorkflow);
        Pane pane = this.kymographBuilderController.loadPane();
        return new TitledPane("Build Kymographs", (Node)pane);
    }

    public TitledPane loadAnalyzer() {
        this.analyzerController = new AnalyzeController(this.context, this.filamentWorkflow);
        Pane pane = this.analyzerController.loadPane();
        return new TitledPane("Analyze Filaments", (Node)pane);
    }

    public TitledPane loadAbout() {
        this.aboutController = new AboutController(this.context);
        Pane pane = this.aboutController.loadPane();
        return new TitledPane("About FilamentDetector", (Node)pane);
    }

    @EventHandler
    private void disableInterface(ImageNotFoundEvent event) {
        Platform.runLater(() -> {
            if (!originalImageDisapearsMessageShown) {
                originalImageDisapearsMessageShown = true;
                this.getPane().setDisable(true);
                Alert alert = new Alert(Alert.AlertType.INFORMATION);
                alert.setTitle("Information Dialog");
                Label label = new Label("It looks like the image has been closed. Please restart the plugin.");
                label.setWrapText(true);
                alert.getDialogPane().setContent((Node)label);
                alert.showAndWait();
            }
        });
    }

    @EventHandler
    private void preventPanelSwitch(PreventPanelSwitchEvent event) {
        if (event.getPreventPaneSwitch()) {
            for (TitledPane pane : this.mainPane.getPanes()) {
                pane.setDisable(true);
            }
        } else {
            for (TitledPane pane : this.mainPane.getPanes()) {
                pane.setDisable(false);
            }
        }
    }
}

