/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.coloc.algorithms;

import net.imglib2.TwinCursor;
import net.imglib2.type.numeric.RealType;

public abstract class Accumulator<T extends RealType<T>> {
    protected double x;
    protected double y;
    protected double xx;
    protected double xy;
    protected double yy;
    protected int count;

    public Accumulator(TwinCursor<T> cursor) {
        this(cursor, false, 0.0, 0.0);
    }

    public Accumulator(TwinCursor<T> cursor, double xDiff, double yDiff) {
        this(cursor, true, xDiff, yDiff);
    }

    protected Accumulator(TwinCursor<T> cursor, boolean substract, double xDiff, double yDiff) {
        while (cursor.hasNext()) {
            cursor.fwd();
            RealType type1 = (RealType)cursor.getFirst();
            RealType type2 = (RealType)cursor.getSecond();
            if (!this.accept(type1, type2)) continue;
            double value1 = type1.getRealDouble();
            double value2 = type2.getRealDouble();
            if (substract) {
                value1 -= xDiff;
                value2 -= yDiff;
            }
            this.x += value1;
            this.y += value2;
            this.xx += value1 * value1;
            this.xy += value1 * value2;
            this.yy += value2 * value2;
            ++this.count;
        }
    }

    public abstract boolean accept(T var1, T var2);

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getXX() {
        return this.xx;
    }

    public double getXY() {
        return this.xy;
    }

    public double getYY() {
        return this.yy;
    }

    public int getCount() {
        return this.count;
    }
}

