/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.balloonSegmentation.utils;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.util.Vector;

public class CenterlineSlice {
    public ImagePlus i1;
    private ImageStack stack1;
    public Vector Points;
    private int nx;
    private int ny;
    private int nz;
    byte[] r;
    byte[] g;
    byte[] b;

    public CenterlineSlice(ImagePlus imp) {
        this.i1 = imp;
        this.stack1 = this.i1.getStack();
        ImageProcessor ip1 = this.stack1.getProcessor(1);
        this.nx = ip1.getWidth();
        this.ny = ip1.getHeight();
        this.nz = this.i1.getStackSize();
        this.r = new byte[this.nx * this.ny];
        this.g = new byte[this.nx * this.ny];
        this.b = new byte[this.nx * this.ny];
        this.Points = new Vector();
    }

    public void GenerateSlice() {
        ColorProcessor cp = new ColorProcessor(this.Points.size(), this.nz);
        for (int j = 0; j < this.nz; ++j) {
            ColorProcessor ip1 = (ColorProcessor)this.stack1.getProcessor(j + 1);
            ip1.getRGB(this.r, this.g, this.b);
            for (int i = 0; i < this.Points.size(); ++i) {
                double x = ((double[])this.Points.get(i))[0];
                double y = ((double[])this.Points.get(i))[1];
                int[] pix = this.AveragePixelValue(x, y);
                cp.putPixel(i, j, ((pix[0] & 0xFF) << 16) + ((pix[1] & 0xFF) << 8) + (pix[2] & 0xFF));
            }
        }
        ImagePlus imp_slice = new ImagePlus("Projection", (ImageProcessor)cp);
        imp_slice.show();
    }

    public void getPoints(int[][] LIST) {
        int N = LIST.length;
        IJ.log((String)("  " + N));
        this.Points.clear();
        for (int i = 1; i < N; ++i) {
            int x1 = LIST[i - 1][0];
            int y1 = LIST[i - 1][1];
            int x2 = LIST[i][0];
            int y2 = LIST[i][1];
            double L = Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2));
            double vx = (double)(x2 - x1) / L;
            double vy = (double)(y2 - y1) / L;
            IJ.log((String)("    " + i + "  /  " + L));
            for (int j = 0; j < (int)L + 1; ++j) {
                IJ.log((String)("          " + j));
                double[] xy = new double[]{(double)x1 + (double)j * vx, (double)x2 + (double)j * vy};
                this.Points.add(xy);
            }
        }
    }

    private int[] AveragePixelValue(double x, double y) {
        int i = (int)x;
        int j = (int)y;
        int l = i + j * this.nx;
        int[] pix = new int[]{this.r[l], this.g[l], this.b[l]};
        return pix;
    }
}

