/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.io;

import ij.IJ;
import ij.ImagePlus;
import ij.plugin.PlugIn;
import java.awt.Image;
import java.awt.image.BufferedImage;
import org.jpedal.PdfDecoder;
import org.jpedal.objects.PdfImageData;
import sc.fiji.io.PDF_Viewer;

public class Extract_Images_From_PDF
implements PlugIn {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(String arg) {
        String path = PDF_Viewer.getPath(arg);
        if (null == path) {
            return;
        }
        PdfDecoder decoder = null;
        try {
            decoder = new PdfDecoder(false);
            decoder.setExtractionMode(6);
            if (path.startsWith("http://")) {
                decoder.openPdfFileFromURL(path);
            } else {
                decoder.openPdfFile(path);
            }
            int page_count = decoder.getPageCount();
            for (int page = 1; page <= page_count; ++page) {
                IJ.showStatus((String)("Decoding page " + page));
                decoder.decodePage(page);
                PdfImageData images = decoder.getPdfImageData();
                int image_count = images.getImageCount();
                for (int i = 0; i < image_count; ++i) {
                    IJ.showStatus((String)("Opening image " + i + "/" + image_count + " from page " + page + "/" + page_count));
                    String name = images.getImageName(i);
                    BufferedImage image = decoder.getObjectStore().loadStoredImage("R" + name);
                    new ImagePlus(name, (Image)image).show();
                }
            }
            IJ.showStatus((String)"Done.");
        }
        catch (Exception e) {
            IJ.log((String)("Error: " + e));
            e.printStackTrace();
        }
        finally {
            decoder.flushObjectValues(true);
            decoder.closePdfFile();
        }
    }
}

