/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.volumeviewer;

import fiji.plugin.volumeviewer.Control;
import fiji.plugin.volumeviewer.Volume;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JPanel;

public class TFalpha4
extends JPanel
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 1L;
    private Control control;
    private int widthV;
    private int heightV;
    private int depthV;
    private byte[][][] alpha_3D;
    private byte[][][] aPaint_3D2;
    private int alphaOffset = 0;
    int xLast = -1;
    int yLast = -1;
    int count = 0;

    public TFalpha4(Control control, Volume vol, byte[][][] alpha_3D, byte[][][] aPaint_3D2) {
        this.control = control;
        this.alpha_3D = alpha_3D;
        this.aPaint_3D2 = aPaint_3D2;
        this.depthV = vol.depthV;
        this.heightV = vol.heightV;
        this.widthV = vol.widthV;
        this.setPreferredSize(new Dimension(256, 128));
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.clearAlpha();
    }

    public void clearAlpha() {
        for (int z = 0; z < this.depthV + 4; ++z) {
            for (int y = 0; y < this.heightV + 4; ++y) {
                for (int x = 0; x < this.widthV + 4; ++x) {
                    this.aPaint_3D2[z][y][x] = 0;
                    this.alpha_3D[z][y][x] = 0;
                }
            }
        }
        this.control.alphaWasChanged = true;
    }

    public void scaleAlpha() {
        for (int z = 0; z < this.depthV + 4; ++z) {
            for (int y = 0; y < this.heightV + 4; ++y) {
                for (int x = 0; x < this.widthV + 4; ++x) {
                    int alpha = 2 * this.aPaint_3D2[z][y][x];
                    if (alpha <= 0) continue;
                    alpha += this.alphaOffset;
                    alpha = Math.min(255, Math.max(0, alpha));
                    this.alpha_3D[z][y][x] = (byte)alpha;
                }
            }
        }
        this.control.alphaWasChanged = true;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.xLast = e.getX();
        this.yLast = e.getY();
        this.handleMouseDragged(e);
        this.control.drag = true;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.control.drag = false;
        this.control.newDisplayMode();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.handleMouseDragged(e);
        if (this.count++ % 10 == 0) {
            this.control.newDisplayMode();
        }
        this.control.alphaWasChanged = true;
    }

    public void handleMouseDragged(MouseEvent e) {
    }

    @Override
    public void paintComponent(Graphics g) {
    }

    public void setAlphaOffset(int alphaOffset) {
        this.alphaOffset = alphaOffset;
    }

    public int getAlphaOffset() {
        return this.alphaOffset;
    }
}

