/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives;

import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.invoke.codegen.ArgumentException;
import org.renjin.invoke.codegen.ArgumentIterator;
import org.renjin.invoke.codegen.WrapperRuntime;
import org.renjin.primitives.text.Text;
import org.renjin.sexp.BuiltinFunction;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.Environment;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.IntArrayVector;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.LogicalVector;
import org.renjin.sexp.PairList;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Vector;

public class R$primitive$strtoi
extends BuiltinFunction {
    public R$primitive$strtoi() {
        super("strtoi");
    }

    @Override
    public SEXP apply(Context context, Environment environment2, FunctionCall call2, PairList args2) {
        try {
            ArgumentIterator argIt = new ArgumentIterator(context, environment2, args2);
            SEXP s0 = argIt.evalNext();
            SEXP s1 = argIt.evalNext();
            if (!argIt.hasNext()) {
                return R$primitive$strtoi.doApply(context, environment2, s0, s1);
            }
            throw new EvalException("strtoi: too many arguments, expected at most 2.", new Object[0]);
        }
        catch (ArgumentException e) {
            throw new EvalException(context, "Invalid argument: %s. Expected:\n\tstrtoi(character, integer(1))", e.getMessage());
        }
        catch (EvalException e) {
            e.initContext(context);
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EvalException(e);
        }
    }

    public static SEXP doApply(Context context, Environment environment2, FunctionCall call2, String[] argNames, SEXP[] args2) {
        try {
            if (args2.length == 2) {
                return R$primitive$strtoi.doApply(context, environment2, args2[0], args2[1]);
            }
        }
        catch (EvalException e) {
            e.initContext(context);
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EvalException(e);
        }
        throw new EvalException("strtoi: max arity is 2", new Object[0]);
    }

    @Override
    public SEXP apply(Context context, Environment environment2, FunctionCall call2, String[] argNames, SEXP[] args2) {
        return R$primitive$strtoi.doApply(context, environment2, call2, argNames, args2);
    }

    public static SEXP doApply(Context context, Environment environment2, SEXP arg0, SEXP arg1) throws Exception {
        if (arg0 instanceof Vector && StringVector.VECTOR_TYPE.isWiderThanOrEqualTo((Vector)arg0) && (arg1 instanceof IntVector || arg1 instanceof DoubleVector || arg1 instanceof LogicalVector)) {
            Vector vector0 = WrapperRuntime.convertToVector(arg0);
            int length0 = vector0.length();
            int currentElementIndex0 = 0;
            int cycles = 0;
            if (length0 == 0) {
                return IntVector.EMPTY;
            }
            if (length0 > cycles) {
                cycles = length0;
            }
            IntArrayVector.Builder builder = new IntArrayVector.Builder(cycles);
            for (int i = 0; i != cycles; ++i) {
                if (vector0.isElementNA(currentElementIndex0)) {
                    builder.setNA(i);
                } else {
                    builder.set(i, Text.strtoi(vector0.getElementAsString(currentElementIndex0), WrapperRuntime.convertToInt(arg1)));
                }
                if (++currentElementIndex0 != length0) continue;
                currentElementIndex0 = 0;
            }
            return builder.build();
        }
        throw new EvalException(String.format("Invalid argument:\n\tstrtoi(%s, %s)\n\tExpected:\n\tstrtoi(character, integer(1))", arg0.getTypeName(), arg1.getTypeName()), new Object[0]);
    }
}

