/*
 * Decompiled with CFR 0.152.
 */
package stitching.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.ListIterator;

public class ErrorStatistic {
    public final ArrayList<Double> values = new ArrayList();
    public final ArrayList<Double> slope = new ArrayList();
    public final ArrayList<Double> sortedValues = new ArrayList();
    public double var0 = 0.0;
    public double var = 0.0;
    public double std0 = 0.0;
    public double std = 0.0;
    public double mean = 0.0;
    public double median = 0.0;
    public double min = Double.MAX_VALUE;
    public double max = 0.0;

    public final void add(double new_value) {
        if (this.values.size() > 1) {
            this.slope.add(new_value - this.values.get(this.values.size() - 1));
        } else {
            this.slope.add(0.0);
        }
        this.mean = this.mean * (double)this.values.size() + new_value;
        this.values.add(new_value);
        this.mean /= (double)this.values.size();
        this.var0 += new_value * new_value / (double)(this.values.size() - 1);
        this.std0 = Math.sqrt(this.var0);
        double tmp = new_value - this.mean;
        this.var += tmp * tmp / (double)(this.values.size() - 1);
        this.std = Math.sqrt(this.var);
        this.sortedValues.add(new_value);
        Collections.sort(this.sortedValues);
        if (this.sortedValues.size() % 2 == 0) {
            int m = this.sortedValues.size() / 2;
            this.median = (this.sortedValues.get(m - 1) + this.sortedValues.get(m)) / 2.0;
        } else {
            this.median = this.sortedValues.get(this.sortedValues.size() / 2);
        }
        if (new_value < this.min) {
            this.min = new_value;
        }
        if (new_value > this.max) {
            this.max = new_value;
        }
    }

    public final double getWideSlope(int width) throws IndexOutOfBoundsException {
        if (width > this.slope.size()) {
            throw new IndexOutOfBoundsException("Cannot estimate a wide slope for width larger than than the number of sample.");
        }
        ListIterator<Double> li = this.slope.listIterator(this.slope.size() - 1);
        double s = 0.0;
        for (int i = 0; i < width && li.hasPrevious(); ++i) {
            s += li.previous().doubleValue();
        }
        return s /= (double)width;
    }
}

