/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.awt;

import edu.mines.jtk.awt.ColorMapListener;
import edu.mines.jtk.util.Check;
import java.awt.Color;
import java.awt.image.IndexColorModel;
import javax.swing.event.EventListenerList;

public class ColorMap {
    public static final IndexColorModel GRAY = ColorMap.getGray();
    public static final IndexColorModel JET = ColorMap.getJet();
    public static final IndexColorModel GMT_JET = ColorMap.getGmtJet();
    public static final IndexColorModel HUE = ColorMap.getHue();
    public static final IndexColorModel HUE_RED_TO_BLUE = ColorMap.getHueRedToBlue();
    public static final IndexColorModel HUE_BLUE_TO_RED = ColorMap.getHueBlueToRed();
    public static final IndexColorModel PRISM = ColorMap.getPrism();
    public static final IndexColorModel RED_WHITE_BLUE = ColorMap.getRedWhiteBlue();
    public static final IndexColorModel BLUE_WHITE_RED = ColorMap.getBlueWhiteRed();
    public static final IndexColorModel GRAY_YELLOW_RED = ColorMap.getGrayYellowRed();
    private double _vmin = 0.0;
    private double _vmax = 1.0;
    private IndexColorModel _colorModel;
    private Color[] _colors = new Color[256];
    private EventListenerList _colorMapListeners = new EventListenerList();

    public ColorMap(IndexColorModel colorModel) {
        this(0.0, 1.0, colorModel);
    }

    public ColorMap(double vmin, double vmax, IndexColorModel colorModel) {
        Check.argument(colorModel.isValid(0), "0 is valid for color model");
        Check.argument(colorModel.isValid(255), "255 is valid for color model");
        this._vmin = vmin;
        this._vmax = vmax;
        this._colorModel = colorModel;
        this.cacheColors();
    }

    public ColorMap(double vmin, double vmax, Color[] c) {
        this(vmin, vmax, ColorMap.getReds(c), ColorMap.getGreens(c), ColorMap.getBlues(c));
    }

    public ColorMap(double vmin, double vmax, byte[] r, byte[] g, byte[] b) {
        this(vmin, vmax, new IndexColorModel(8, 256, r, g, b));
    }

    public ColorMap(double vmin, double vmax, float[] r, float[] g, float[] b) {
        this(vmin, vmax, ColorMap.getBytes(r), ColorMap.getBytes(g), ColorMap.getBytes(b));
    }

    public ColorMap(Color c) {
        this(0.0, 1.0, c);
    }

    public ColorMap(double vmin, double vmax, Color c) {
        this(vmin, vmax, ColorMap.makeSolidColors(c));
    }

    public double getMinValue() {
        return this._vmin;
    }

    public double getMaxValue() {
        return this._vmax;
    }

    public IndexColorModel getColorModel() {
        return this._colorModel;
    }

    public Color getColor(double v) {
        return this._colors[this.getIndex(v)];
    }

    public int getIndex(double v) {
        v = Math.max(this._vmin, Math.min(this._vmax, v));
        double s = (256.0 - Math.ulp(256.0)) / (this._vmax - this._vmin);
        return (int)((v - this._vmin) * s);
    }

    public float[] getRgbFloats(float[] v) {
        int nv = v.length;
        float[] rgb = new float[3 * nv];
        float scale = 0.003921569f;
        int i = 0;
        for (int iv = 0; iv < nv; ++iv) {
            Color c = this._colors[this.getIndex(v[iv])];
            rgb[i++] = scale * (float)c.getRed();
            rgb[i++] = scale * (float)c.getGreen();
            rgb[i++] = scale * (float)c.getBlue();
        }
        return rgb;
    }

    public float[] getHslFloats(float[] v) {
        float[] rgb = this.getRgbFloats(v);
        int nv = v.length;
        float[] hsl = new float[3 * nv];
        float[] value = new float[3];
        int i = 0;
        for (int iv = 0; iv < nv; ++iv) {
            value = ColorMap.rgbToHsl(rgb[i + 0], rgb[i + 1], rgb[i + 2]);
            hsl[i++] = value[0];
            hsl[i++] = value[1];
            hsl[i++] = value[2];
        }
        return hsl;
    }

    public float[] getCieLabFloats(float[] v) {
        int nv = v.length;
        float[] rgb = this.getRgbFloats(v);
        float[] lab = new float[3];
        float[] cielab = new float[3 * nv];
        float Xn = 0.95047f;
        float Yn = 1.0f;
        float Zn = 1.08883f;
        int i = 0;
        int j = 0;
        for (int iv = 0; iv < nv; ++iv) {
            float r = rgb[j++];
            float g = rgb[j++];
            float b = rgb[j++];
            lab = ColorMap.rgbToCieLab(r, g, b);
            cielab[i++] = lab[0];
            cielab[i++] = lab[1];
            cielab[i++] = lab[2];
        }
        return cielab;
    }

    public static float[] rgbToHsl(float r, float g, float b) {
        float h;
        float s;
        float[] hsl = new float[3];
        float min = Math.min(Math.min(r, g), b);
        float max = Math.max(Math.max(r, g), b);
        float l = (max + min) / 2.0f;
        if (max == min) {
            s = 0.0f;
            h = 0.0f;
        } else {
            float diff = max - min;
            float f = s = l > 0.5f ? diff / (2.0f - max - min) : diff / (max + min);
            h = max == r ? (g - b) / diff + (g < b ? 6.0f : 0.0f) : (max == g ? (b - r) / diff + 2.0f : (r - g) / diff + 4.0f);
            h /= 6.0f;
        }
        hsl[0] = h * 360.0f;
        hsl[1] = s;
        hsl[2] = l;
        return hsl;
    }

    public static float[] hslToRgb(float h, float s, float l) {
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        float c = (1.0f - Math.abs(2.0f * l - 1.0f)) * s;
        float x = c * (1.0f - Math.abs(h / 60.0f % 2.0f - 1.0f));
        float m = l - c / 2.0f;
        if (h >= 0.0f && h < 60.0f) {
            r = c;
            g = x;
            b = 0.0f;
        } else if (h >= 60.0f && h < 120.0f) {
            r = x;
            g = c;
            b = 0.0f;
        } else if (h >= 120.0f && h < 180.0f) {
            r = 0.0f;
            g = c;
            b = x;
        } else if (h >= 180.0f && h < 240.0f) {
            r = 0.0f;
            g = x;
            b = c;
        } else if (h >= 240.0f && h < 300.0f) {
            r = x;
            g = 0.0f;
            b = c;
        } else {
            r = c;
            g = 0.0f;
            b = x;
        }
        r += m;
        g += m;
        b += m;
        r = Math.min(1.0f, Math.max(0.0f, r));
        g = Math.min(1.0f, Math.max(0.0f, g));
        b = Math.min(1.0f, Math.max(0.0f, b));
        return new float[]{r, g, b};
    }

    public static float[] rgbToCieLab(float[] rgb) {
        float[] xyz = ColorMap.rgbToCieXyz(rgb);
        float Xn = 95.047f;
        float Yn = 100.0f;
        float Zn = 108.883f;
        xyz[0] = xyz[0] / Xn;
        xyz[1] = xyz[1] / Yn;
        xyz[2] = xyz[2] / Zn;
        return ColorMap.cieXyzToCieLab(xyz);
    }

    public static float[] rgbToCieLab(float r, float g, float b) {
        return ColorMap.rgbToCieLab(new float[]{r, g, b});
    }

    public static float[] cieLabToRgb(float[] lab) {
        float[] xyz = ColorMap.cieLabToCieXyz(lab);
        float Xn = 95.047f;
        float Yn = 100.0f;
        float Zn = 108.883f;
        xyz[0] = xyz[0] * Xn;
        xyz[1] = xyz[1] * Yn;
        xyz[2] = xyz[2] * Zn;
        float[] rgb = ColorMap.cieXyzToRgb(xyz);
        rgb[0] = Math.min(1.0f, Math.max(0.0f, rgb[0]));
        rgb[1] = Math.min(1.0f, Math.max(0.0f, rgb[1]));
        rgb[2] = Math.min(1.0f, Math.max(0.0f, rgb[2]));
        return rgb;
    }

    public static float[] cieLabToRgb(float Ls, float as, float bs) {
        return ColorMap.cieLabToRgb(new float[]{Ls, as, bs});
    }

    public void setValueRange(double vmin, double vmax) {
        this._vmin = vmin;
        this._vmax = vmax;
        this.fireColorMapChanged();
    }

    public void setColorModel(IndexColorModel colorModel) {
        this._colorModel = colorModel;
        this.cacheColors();
        this.fireColorMapChanged();
    }

    public void setColorModel(Color c) {
        this._colorModel = ColorMap.makeSolidColors(c);
        this.cacheColors();
        this.fireColorMapChanged();
    }

    public void addListener(ColorMapListener cml) {
        this._colorMapListeners.add(ColorMapListener.class, cml);
        cml.colorMapChanged(this);
    }

    public void removeListener(ColorMapListener cml) {
        this._colorMapListeners.remove(ColorMapListener.class, cml);
    }

    public static IndexColorModel getGray() {
        return ColorMap.getGray(0.0, 1.0);
    }

    public static IndexColorModel getGray(double g0, double g255) {
        return ColorMap.getGray(g0, g255, 1.0);
    }

    public static IndexColorModel getGray(double g0, double g255, double alpha) {
        float a = (float)alpha;
        Color[] c = new Color[256];
        for (int i = 0; i < 256; ++i) {
            float g = (float)(g0 + (double)i * (g255 - g0) / 255.0);
            c[i] = new Color(g, g, g, a);
        }
        return ColorMap.makeIndexColorModel(c);
    }

    public static IndexColorModel getJet() {
        return ColorMap.getJet(1.0);
    }

    public static IndexColorModel getJet(double alpha) {
        return ColorMap.makeIndexColorModel(ColorMap.getJetColors(alpha));
    }

    public static IndexColorModel getGmtJet() {
        return ColorMap.getGmtJet(1.0);
    }

    public static IndexColorModel getGmtJet(double alpha) {
        return ColorMap.makeIndexColorModel(ColorMap.getGmtJetColors(alpha));
    }

    public static IndexColorModel getPrism() {
        return ColorMap.getHue(0.0, 8.0);
    }

    public static IndexColorModel getHue() {
        return ColorMap.getHue(0.0, 0.67);
    }

    public static IndexColorModel getHueRedToBlue() {
        return ColorMap.getHue(0.0, 0.67);
    }

    public static IndexColorModel getHueBlueToRed() {
        return ColorMap.getHue(0.67, 0.0);
    }

    public static IndexColorModel getHue(double h0, double h255) {
        return ColorMap.getHue(h0, h255, 1.0);
    }

    public static IndexColorModel getHue(double h0, double h255, double alpha) {
        Color[] c = new Color[256];
        int a = (int)(0.5 + Math.max(0.0, Math.min(1.0, alpha)) * 255.0);
        for (int i = 0; i < 256; ++i) {
            float h = (float)(h0 + (double)i * (h255 - h0) / 255.0);
            Color rgb = Color.getHSBColor(h, 1.0f, 1.0f);
            c[i] = new Color(rgb.getRed(), rgb.getGreen(), rgb.getBlue(), a);
        }
        return ColorMap.makeIndexColorModel(c);
    }

    public static IndexColorModel getRedWhiteBlue() {
        Color[] c = new Color[256];
        for (int i = 0; i < 256; ++i) {
            float a;
            float x = (float)i / 255.0f;
            if (x < 0.5f) {
                a = x / 0.5f;
                c[i] = new Color(1.0f, a, a);
                continue;
            }
            a = (x - 0.5f) / 0.5f;
            c[i] = new Color(1.0f - a, 1.0f - a, 1.0f);
        }
        return ColorMap.makeIndexColorModel(c);
    }

    public static IndexColorModel getBlueWhiteRed() {
        Color[] c = new Color[256];
        for (int i = 0; i < 256; ++i) {
            float a;
            float x = (float)i / 255.0f;
            if (x < 0.5f) {
                a = x / 0.5f;
                c[i] = new Color(a, a, 1.0f);
                continue;
            }
            a = (x - 0.5f) / 0.5f;
            c[i] = new Color(1.0f, 1.0f - a, 1.0f - a);
        }
        return ColorMap.makeIndexColorModel(c);
    }

    public static IndexColorModel getGrayYellowRed() {
        Color[] c = new Color[256];
        for (int i = 0; i < 256; ++i) {
            float x = (float)i / 255.0f;
            if (x < 0.5f) {
                float y = 2.0f * x;
                c[i] = new Color(y, y, y);
                continue;
            }
            float g = x < 0.67f ? 1.0f : 3.0f - 3.0f * x;
            float b = 2.0f - 2.0f * x;
            c[i] = new Color(1.0f, g, b);
        }
        return ColorMap.makeIndexColorModel(c);
    }

    public static IndexColorModel makeIndexColorModel(Color[] c) {
        if (ColorMap.hasAlpha(c)) {
            return new IndexColorModel(8, 256, ColorMap.getReds(c), ColorMap.getGreens(c), ColorMap.getBlues(c), ColorMap.getAlphas(c));
        }
        return new IndexColorModel(8, 256, ColorMap.getReds(c), ColorMap.getGreens(c), ColorMap.getBlues(c));
    }

    public static IndexColorModel makeSolidColors(Color c) {
        Color[] colors = new Color[256];
        for (int i = 0; i < 256; ++i) {
            colors[i] = c;
        }
        return ColorMap.makeIndexColorModel(colors);
    }

    public static IndexColorModel setAlpha(IndexColorModel icm, double alpha) {
        int bits = icm.getPixelSize();
        int size = icm.getMapSize();
        byte[] r = new byte[size];
        byte[] g = new byte[size];
        byte[] b = new byte[size];
        byte[] a = new byte[size];
        icm.getReds(r);
        icm.getGreens(g);
        icm.getBlues(b);
        byte ia = (byte)(255.0 * alpha + 0.5);
        for (int i = 0; i < size; ++i) {
            a[i] = ia;
        }
        return new IndexColorModel(bits, size, r, g, b, a);
    }

    public static IndexColorModel setAlpha(IndexColorModel icm, float[] alpha) {
        int bits = icm.getPixelSize();
        int size = icm.getMapSize();
        byte[] r = new byte[size];
        byte[] g = new byte[size];
        byte[] b = new byte[size];
        byte[] a = new byte[size];
        icm.getReds(r);
        icm.getGreens(g);
        icm.getBlues(b);
        int n = Math.min(size, alpha.length);
        for (int i = 0; i < n; ++i) {
            a[i] = (byte)(255.0f * alpha[i] + 0.5f);
        }
        return new IndexColorModel(bits, size, r, g, b, a);
    }

    private void fireColorMapChanged() {
        Object[] listeners = this._colorMapListeners.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            ColorMapListener cml = (ColorMapListener)listeners[i + 1];
            cml.colorMapChanged(this);
        }
    }

    private void cacheColors() {
        for (int index = 0; index < 256; ++index) {
            this._colors[index] = new Color(this._colorModel.getRGB(index));
        }
    }

    private static byte[] getReds(Color[] color) {
        int n = color.length;
        byte[] r = new byte[n];
        for (int i = 0; i < n; ++i) {
            r[i] = (byte)color[i].getRed();
        }
        return r;
    }

    private static byte[] getGreens(Color[] color) {
        int n = color.length;
        byte[] g = new byte[n];
        for (int i = 0; i < n; ++i) {
            g[i] = (byte)color[i].getGreen();
        }
        return g;
    }

    private static byte[] getBlues(Color[] color) {
        int n = color.length;
        byte[] b = new byte[n];
        for (int i = 0; i < n; ++i) {
            b[i] = (byte)color[i].getBlue();
        }
        return b;
    }

    private static byte[] getAlphas(Color[] color) {
        int n = color.length;
        byte[] b = new byte[n];
        for (int i = 0; i < n; ++i) {
            b[i] = (byte)color[i].getAlpha();
        }
        return b;
    }

    private static boolean hasAlpha(Color[] color) {
        int n = color.length;
        for (int i = 0; i < n; ++i) {
            if (color[i].getAlpha() == 255) continue;
            return true;
        }
        return false;
    }

    private static byte[] getBytes(float[] f) {
        int n = f.length;
        byte[] b = new byte[n];
        for (int i = 0; i < n; ++i) {
            b[i] = (byte)(f[i] * 255.0f + 0.5f);
        }
        return b;
    }

    private static Color[] addAlpha(Color[] color, double alpha) {
        int n = color.length;
        float a = (float)alpha;
        Color[] c = new Color[n];
        for (int i = 0; i < n; ++i) {
            float r = (float)color[i].getRed() / 255.0f;
            float g = (float)color[i].getGreen() / 255.0f;
            float b = (float)color[i].getBlue() / 255.0f;
            c[i] = new Color(r, g, b, a);
        }
        return c;
    }

    private static Color[] addAlpha(Color[] color, float[] alpha) {
        int n = color.length;
        Color[] c = new Color[n];
        for (int i = 0; i < n; ++i) {
            float r = (float)color[i].getRed() / 255.0f;
            float g = (float)color[i].getGreen() / 255.0f;
            float b = (float)color[i].getBlue() / 255.0f;
            float a = alpha[i];
            c[i] = new Color(r, g, b, a);
        }
        return c;
    }

    private static Color[] getJetColors(double alpha) {
        float a = (float)alpha;
        Color[] c = new Color[256];
        for (int i = 0; i < 256; ++i) {
            float y;
            float x = (float)i / 255.0f;
            if (x < 0.125f) {
                y = x / 0.125f;
                c[i] = new Color(0.0f, 0.0f, 0.5f + 0.5f * y, a);
                continue;
            }
            if (x < 0.375f) {
                y = (x - 0.125f) / 0.25f;
                c[i] = new Color(0.0f, y, 1.0f, a);
                continue;
            }
            if (x < 0.625f) {
                y = (x - 0.375f) / 0.25f;
                c[i] = new Color(y, 1.0f, 1.0f - y, a);
                continue;
            }
            if (x < 0.875f) {
                y = (x - 0.625f) / 0.25f;
                c[i] = new Color(1.0f, 1.0f - y, 0.0f, a);
                continue;
            }
            y = (x - 0.875f) / 0.125f;
            c[i] = new Color(1.0f - 0.5f * y, 0.0f, 0.0f, a);
        }
        return c;
    }

    private static Color[] getGmtJetColors(double alpha) {
        float a = (float)alpha;
        Color[] c = new Color[256];
        for (int i = 0; i < 256; ++i) {
            float y;
            float x = (float)i / 255.0f;
            if (x < 0.125f) {
                y = x / 0.125f;
                c[i] = new Color(0.0f, 0.0f, 0.5f + 0.5f * y, a);
                continue;
            }
            if (x < 0.375f) {
                y = (x - 0.125f) / 0.25f;
                c[i] = new Color(0.0f, y, 1.0f, a);
                continue;
            }
            if (x < 0.625f) {
                y = (x - 0.375f) / 0.25f;
                c[i] = new Color(1.0f, 1.0f, 1.0f - 0.5f * y, a);
                continue;
            }
            if (x < 0.875f) {
                y = (x - 0.625f) / 0.25f;
                c[i] = new Color(1.0f, 1.0f - y, 0.0f, a);
                continue;
            }
            y = (x - 0.875f) / 0.125f;
            c[i] = new Color(1.0f - 0.5f * y, 0.0f, 0.0f, a);
        }
        return c;
    }

    private static float[] cieXyzToCieLab(float[] xyz) {
        float c = 0.008856f;
        for (int i = 0; i < 3; ++i) {
            xyz[i] = xyz[i] > c ? (float)Math.pow(xyz[i], 0.3333333432674408) : 7.787f * xyz[i] + 0.13793103f;
        }
        float Ls = 116.0f * xyz[1] - 16.0f;
        float as = 500.0f * (xyz[0] - xyz[1]);
        float bs = 200.0f * (xyz[1] - xyz[2]);
        return new float[]{Ls, as, bs};
    }

    private static float[] cieLabToCieXyz(float[] lab) {
        float c = 0.008856f;
        float y = (lab[0] + 16.0f) / 116.0f;
        float x = lab[1] / 500.0f + y;
        float z = y - lab[2] / 200.0f;
        float[] xyz = new float[]{x, y, z};
        for (int i = 0; i < 3; ++i) {
            xyz[i] = Math.pow(xyz[i], 3.0) > (double)c ? (float)Math.pow(xyz[i], 3.0) : (xyz[i] - 0.13793103f) / 7.787f;
        }
        return xyz;
    }

    private static float[] rgbToCieXyz(float[] rgb) {
        float[] xyz = new float[3];
        float c = 0.04045f;
        int i = 0;
        while (i < 3) {
            rgb[i] = rgb[i] > c ? (float)Math.pow((rgb[i] + 0.055f) / 1.055f, 2.4f) : rgb[i] / 12.92f;
            int n = i++;
            rgb[n] = rgb[n] * 100.0f;
        }
        xyz[0] = rgb[0] * 0.4124f + rgb[1] * 0.3576f + rgb[2] * 0.1805f;
        xyz[1] = rgb[0] * 0.2126f + rgb[1] * 0.7152f + rgb[2] * 0.0722f;
        xyz[2] = rgb[0] * 0.0193f + rgb[1] * 0.1192f + rgb[2] * 0.9505f;
        return xyz;
    }

    private static float[] cieXyzToRgb(float[] xyz) {
        xyz[0] = xyz[0] / 100.0f;
        xyz[1] = xyz[1] / 100.0f;
        xyz[2] = xyz[2] / 100.0f;
        float[] rgb = new float[3];
        float c = 0.0031308f;
        rgb[0] = xyz[0] * 3.2406f + xyz[1] * -1.5372f + xyz[2] * -0.4986f;
        rgb[1] = xyz[0] * -0.9689f + xyz[1] * 1.8758f + xyz[2] * 0.0415f;
        rgb[2] = xyz[0] * 0.0557f + xyz[1] * -0.204f + xyz[2] * 1.057f;
        for (int i = 0; i < 3; ++i) {
            rgb[i] = rgb[i] > c ? 1.055f * (float)Math.pow(rgb[i], 0.4166666567325592) - 0.055f : rgb[i] * 12.92f;
        }
        return rgb;
    }
}

