/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.blocks;

import net.imglib2.Dimensions;
import net.imglib2.Interval;
import net.imglib2.algorithm.blocks.BlockProcessor;
import net.imglib2.blocks.BlockInterval;
import net.imglib2.blocks.TempArray;
import net.imglib2.type.PrimitiveType;
import net.imglib2.util.Intervals;
import net.imglib2.util.Util;

public abstract class AbstractBlockProcessor<I, O>
implements BlockProcessor<I, O> {
    private final TempArray<I> tempArray;
    private final BlockInterval sourceInterval;
    protected final long[] sourcePos;
    protected final int[] sourceSize;

    protected AbstractBlockProcessor(PrimitiveType sourcePrimitiveType, int numSourceDimensions) {
        this.tempArray = TempArray.forPrimitiveType((PrimitiveType)sourcePrimitiveType);
        this.sourceInterval = new BlockInterval(numSourceDimensions);
        this.sourcePos = this.sourceInterval.min();
        this.sourceSize = this.sourceInterval.size();
    }

    protected AbstractBlockProcessor(AbstractBlockProcessor<I, O> proc) {
        this.tempArray = proc.tempArray.newInstance();
        this.sourceInterval = new BlockInterval(proc.sourceInterval.numDimensions());
        this.sourcePos = this.sourceInterval.min();
        this.sourceSize = this.sourceInterval.size();
    }

    protected int sourceLength() {
        return Util.safeInt((long)Intervals.numElements((Dimensions)this.sourceInterval));
    }

    @Override
    public void setTargetInterval(Interval interval) {
        this.sourceInterval.setFrom(interval);
    }

    public BlockInterval getSourceInterval() {
        return this.sourceInterval;
    }

    @Override
    public I getSourceBuffer() {
        return (I)this.tempArray.get(this.sourceLength());
    }
}

