/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.blocks;

import java.util.function.Function;
import net.imglib2.EuclideanSpace;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.Typed;
import net.imglib2.algorithm.blocks.BlockAlgoUtils;
import net.imglib2.algorithm.blocks.PrimitiveBlocksSupplier;
import net.imglib2.algorithm.blocks.TilingUnaryBlockOperator;
import net.imglib2.algorithm.blocks.UnaryBlockOperator;
import net.imglib2.blocks.PrimitiveBlocks;
import net.imglib2.cache.img.CachedCellImg;
import net.imglib2.type.NativeType;

public interface BlockSupplier<T extends NativeType<T>>
extends Typed<T>,
EuclideanSpace {
    public void copy(Interval var1, Object var2);

    public BlockSupplier<T> threadSafe();

    public BlockSupplier<T> independentCopy();

    default public <U extends NativeType<U>> BlockSupplier<U> andThen(UnaryBlockOperator<T, U> operator) {
        return operator.applyTo(this);
    }

    default public <U extends NativeType<U>> BlockSupplier<U> andThen(Function<BlockSupplier<T>, UnaryBlockOperator<T, U>> function) {
        return this.andThen(function.apply(this));
    }

    public static <T extends NativeType<T>> BlockSupplier<T> of(RandomAccessible<T> ra) {
        return BlockSupplier.of(ra, PrimitiveBlocks.OnFallback.WARN);
    }

    public static <T extends NativeType<T>> BlockSupplier<T> of(RandomAccessible<T> ra, PrimitiveBlocks.OnFallback onFallback) {
        return new PrimitiveBlocksSupplier(PrimitiveBlocks.of(ra, (PrimitiveBlocks.OnFallback)onFallback));
    }

    default public CachedCellImg<T, ?> toCellImg(long[] dimensions, int ... cellDimensions) {
        return BlockAlgoUtils.cellImg(this, dimensions, cellDimensions);
    }

    default public BlockSupplier<T> tile(int ... tileSize) {
        return this.andThen(new TilingUnaryBlockOperator((NativeType)this.getType(), this.numDimensions(), tileSize));
    }
}

