/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.blocks.transform;

import net.imglib2.algorithm.blocks.transform.Transform;
import net.imglib2.type.PrimitiveType;
import net.imglib2.util.Cast;

@FunctionalInterface
interface TransformLine2D<P> {
    public void apply(P var1, P var2, int var3, int var4, float var5, float var6, int var7, float var8, float var9);

    public static <P> TransformLine2D<P> of(Transform.Interpolation interpolation, PrimitiveType primitiveType) {
        if (interpolation == Transform.Interpolation.NLINEAR) {
            switch (primitiveType) {
                case FLOAT: {
                    return (TransformLine2D)Cast.unchecked((Object)NLinear_float.INSTANCE);
                }
                case DOUBLE: {
                    return (TransformLine2D)Cast.unchecked((Object)NLinear_double.INSTANCE);
                }
            }
            throw new IllegalArgumentException();
        }
        switch (primitiveType) {
            case BYTE: {
                return (TransformLine2D)Cast.unchecked((Object)NearestNeighbor_byte.INSTANCE);
            }
            case SHORT: {
                return (TransformLine2D)Cast.unchecked((Object)NearestNeighbor_short.INSTANCE);
            }
            case INT: {
                return (TransformLine2D)Cast.unchecked((Object)NearestNeighbor_int.INSTANCE);
            }
            case LONG: {
                return (TransformLine2D)Cast.unchecked((Object)NearestNeighbor_long.INSTANCE);
            }
            case FLOAT: {
                return (TransformLine2D)Cast.unchecked((Object)NearestNeighbor_float.INSTANCE);
            }
            case DOUBLE: {
                return (TransformLine2D)Cast.unchecked((Object)NearestNeighbor_double.INSTANCE);
            }
        }
        throw new IllegalArgumentException();
    }

    public static class NearestNeighbor_long
    implements TransformLine2D<long[]> {
        static final NearestNeighbor_long INSTANCE = new NearestNeighbor_long();

        private NearestNeighbor_long() {
        }

        @Override
        public void apply(long[] src, long[] dest, int offset, int length, float d0, float d1, int ss0, float sf0, float sf1) {
            sf0 += 0.5f;
            sf1 += 0.5f;
            for (int x = 0; x < length; ++x) {
                int s0 = (int)sf0;
                int s1 = (int)sf1;
                dest[offset++] = src[s1 * ss0 + s0];
                sf0 += d0;
                sf1 += d1;
            }
        }
    }

    public static class NearestNeighbor_int
    implements TransformLine2D<int[]> {
        static final NearestNeighbor_int INSTANCE = new NearestNeighbor_int();

        private NearestNeighbor_int() {
        }

        @Override
        public void apply(int[] src, int[] dest, int offset, int length, float d0, float d1, int ss0, float sf0, float sf1) {
            sf0 += 0.5f;
            sf1 += 0.5f;
            for (int x = 0; x < length; ++x) {
                int s0 = (int)sf0;
                int s1 = (int)sf1;
                dest[offset++] = src[s1 * ss0 + s0];
                sf0 += d0;
                sf1 += d1;
            }
        }
    }

    public static class NearestNeighbor_short
    implements TransformLine2D<short[]> {
        static final NearestNeighbor_short INSTANCE = new NearestNeighbor_short();

        private NearestNeighbor_short() {
        }

        @Override
        public void apply(short[] src, short[] dest, int offset, int length, float d0, float d1, int ss0, float sf0, float sf1) {
            sf0 += 0.5f;
            sf1 += 0.5f;
            for (int x = 0; x < length; ++x) {
                int s0 = (int)sf0;
                int s1 = (int)sf1;
                dest[offset++] = src[s1 * ss0 + s0];
                sf0 += d0;
                sf1 += d1;
            }
        }
    }

    public static class NearestNeighbor_byte
    implements TransformLine2D<byte[]> {
        static final NearestNeighbor_byte INSTANCE = new NearestNeighbor_byte();

        private NearestNeighbor_byte() {
        }

        @Override
        public void apply(byte[] src, byte[] dest, int offset, int length, float d0, float d1, int ss0, float sf0, float sf1) {
            sf0 += 0.5f;
            sf1 += 0.5f;
            for (int x = 0; x < length; ++x) {
                int s0 = (int)sf0;
                int s1 = (int)sf1;
                dest[offset++] = src[s1 * ss0 + s0];
                sf0 += d0;
                sf1 += d1;
            }
        }
    }

    public static class NearestNeighbor_double
    implements TransformLine2D<double[]> {
        static final NearestNeighbor_double INSTANCE = new NearestNeighbor_double();

        private NearestNeighbor_double() {
        }

        @Override
        public void apply(double[] src, double[] dest, int offset, int length, float d0, float d1, int ss0, float sf0, float sf1) {
            sf0 += 0.5f;
            sf1 += 0.5f;
            for (int x = 0; x < length; ++x) {
                int s0 = (int)sf0;
                int s1 = (int)sf1;
                dest[offset++] = src[s1 * ss0 + s0];
                sf0 += d0;
                sf1 += d1;
            }
        }
    }

    public static class NearestNeighbor_float
    implements TransformLine2D<float[]> {
        static final NearestNeighbor_float INSTANCE = new NearestNeighbor_float();

        private NearestNeighbor_float() {
        }

        @Override
        public void apply(float[] src, float[] dest, int offset, int length, float d0, float d1, int ss0, float sf0, float sf1) {
            sf0 += 0.5f;
            sf1 += 0.5f;
            for (int x = 0; x < length; ++x) {
                int s0 = (int)sf0;
                int s1 = (int)sf1;
                dest[offset++] = src[s1 * ss0 + s0];
                sf0 += d0;
                sf1 += d1;
            }
        }
    }

    public static class NLinear_double
    implements TransformLine2D<double[]> {
        static final NLinear_double INSTANCE = new NLinear_double();

        private NLinear_double() {
        }

        @Override
        public void apply(double[] src, double[] dest, int offset, int length, float d0, float d1, int ss0, float sf0, float sf1) {
            for (int x = 0; x < length; ++x) {
                int s0 = (int)sf0;
                int s1 = (int)sf1;
                float r0 = sf0 - (float)s0;
                float r1 = sf1 - (float)s1;
                int o = s1 * ss0 + s0;
                double a00 = src[o];
                double a01 = src[o + 1];
                double a10 = src[o + ss0];
                double a11 = src[o + ss0 + 1];
                dest[offset++] = a00 + (double)r0 * (a01 - a00) + (double)r1 * (a10 - a00 + (double)r0 * (a00 - a10 - a01 + a11));
                sf0 += d0;
                sf1 += d1;
            }
        }
    }

    public static class NLinear_float
    implements TransformLine2D<float[]> {
        static final NLinear_float INSTANCE = new NLinear_float();

        private NLinear_float() {
        }

        @Override
        public void apply(float[] src, float[] dest, int offset, int length, float d0, float d1, int ss0, float sf0, float sf1) {
            for (int x = 0; x < length; ++x) {
                int s0 = (int)sf0;
                int s1 = (int)sf1;
                float r0 = sf0 - (float)s0;
                float r1 = sf1 - (float)s1;
                int o = s1 * ss0 + s0;
                float a00 = src[o];
                float a01 = src[o + 1];
                float a10 = src[o + ss0];
                float a11 = src[o + ss0 + 1];
                dest[offset++] = a00 + r0 * (a01 - a00) + r1 * (a10 - a00 + r0 * (a00 - a10 - a01 + a11));
                sf0 += d0;
                sf1 += d1;
            }
        }
    }
}

