/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.convolution.kernel;

import java.lang.reflect.Array;
import net.imglib2.RandomAccess;
import net.imglib2.algorithm.convolution.kernel.Kernel1D;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.NumericType;

public final class ConvolverNumericType<T extends NumericType<T>>
implements Runnable {
    private final double[] kernel;
    private final RandomAccess<? extends T> in;
    private final RandomAccess<? extends T> out;
    private final int d;
    private final int k1k;
    private final int k1k1;
    private final long linelen;
    private final T[] buffer;
    private final T tmp;

    public ConvolverNumericType(Kernel1D kernel, RandomAccess<? extends T> in, RandomAccess<? extends T> out, int d, long lineLength) {
        this.in = in;
        this.out = out;
        this.d = d;
        this.kernel = (double[])kernel.fullKernel().clone();
        this.k1k = this.kernel.length;
        this.k1k1 = this.k1k - 1;
        this.linelen = lineLength;
        NumericType type = (NumericType)out.get();
        this.buffer = (NumericType[])Array.newInstance(type.getClass(), this.k1k + 1);
        for (int i = 0; i < this.k1k + 1; ++i) {
            this.buffer[i] = (NumericType)type.createVariable();
        }
        this.buffer[this.k1k].setZero();
        this.tmp = (NumericType)type.createVariable();
    }

    private void prefill() {
        this.tmp.set((Type)this.in.get());
        this.process(this.tmp);
        this.in.fwd(this.d);
    }

    private void next() {
        this.tmp.set((Type)this.in.get());
        T t = this.buffer[0];
        t.set(this.tmp);
        t.mul(this.kernel[0]);
        t.add(this.buffer[1]);
        ((NumericType)this.out.get()).set(t);
        this.process(this.tmp);
        this.in.fwd(this.d);
        this.out.fwd(this.d);
    }

    private void process(T tmp) {
        for (int i = 1; i < this.k1k; ++i) {
            T t = this.buffer[i];
            t.set(tmp);
            t.mul(this.kernel[i]);
            t.add(this.buffer[i + 1]);
        }
    }

    @Override
    public void run() {
        for (int i = 0; i < this.k1k1; ++i) {
            this.prefill();
        }
        for (long i = 0L; i < this.linelen; ++i) {
            this.next();
        }
    }
}

