/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.linalg.eigen;

import net.imglib2.algorithm.linalg.eigen.EigenValues;
import net.imglib2.type.numeric.ComplexType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.composite.Composite;

public class EigenValues2DSquare<T extends RealType<T>, U extends ComplexType<U>>
implements EigenValues<T, U> {
    @Override
    public void compute(Composite<T> tensor, Composite<U> evs) {
        double x11 = ((RealType)tensor.get(0L)).getRealDouble();
        double x12 = ((RealType)tensor.get(1L)).getRealDouble();
        double x21 = ((RealType)tensor.get(2L)).getRealDouble();
        double x22 = ((RealType)tensor.get(3L)).getRealDouble();
        double sum = x11 + x22;
        double diff = x11 - x22;
        double radicand = 4.0 * x12 * x21 + diff * diff;
        if (radicand < 0.0) {
            double halfSqrt = 0.5 * Math.sqrt(-radicand);
            double halfSum = 0.5 * sum;
            ((ComplexType)evs.get(0L)).setComplexNumber(halfSum, halfSqrt);
            ((ComplexType)evs.get(1L)).setComplexNumber(halfSum, -halfSqrt);
        } else {
            double sqrt = Math.sqrt(radicand);
            ((ComplexType)evs.get(0L)).setComplexNumber(0.5 * (sum + sqrt), 0.0);
            ((ComplexType)evs.get(1L)).setComplexNumber(0.5 * (sum - sqrt), 0.0);
        }
    }
}

