/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.math;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.KDTree;
import net.imglib2.Point;
import net.imglib2.algorithm.math.abstractions.IFunction;
import net.imglib2.algorithm.math.abstractions.OFunction;
import net.imglib2.algorithm.math.abstractions.SourceInterval;
import net.imglib2.algorithm.math.abstractions.ViewableFunction;
import net.imglib2.algorithm.math.execution.KDTreeRadiusSource;
import net.imglib2.algorithm.math.execution.LetBinding;
import net.imglib2.algorithm.math.execution.Variable;
import net.imglib2.converter.Converter;
import net.imglib2.type.numeric.IntegerType;
import net.imglib2.type.numeric.RealType;

public class KDTreeSource<I extends RealType<I>>
extends ViewableFunction
implements IFunction,
SourceInterval {
    private final KDTree<I> kdtree;
    private final double radius;
    private final I outside;
    private final Interval interval;

    public KDTreeSource(List<Point> points, I value, double radius) {
        this(new KDTree(points.stream().map(p -> value).collect(Collectors.toList()), points), radius);
    }

    public KDTreeSource(List<Point> points, I value, double radius, Object outside) {
        this(new KDTree(points.stream().map(p -> value).collect(Collectors.toList()), points), radius, outside, null);
    }

    public KDTreeSource(List<Point> points, I value, double radius, Object outside, Interval interval) {
        this(new KDTree(points.stream().map(p -> value).collect(Collectors.toList()), points), radius, outside, interval);
    }

    public KDTreeSource(List<Point> points, List<I> values, double radius) {
        this(new KDTree(values, points), radius);
    }

    public KDTreeSource(List<Point> points, List<I> values, double radius, Object outside) {
        this(new KDTree(values, points), radius, outside, null);
    }

    public KDTreeSource(List<Point> points, List<I> values, double radius, Object outside, Interval interval) {
        this(new KDTree(values, points), radius, outside, interval);
    }

    public KDTreeSource(KDTree<I> kdtree, double radius) {
        this(kdtree, radius, ((RealType)kdtree.firstElement()).createVariable(), null);
    }

    public KDTreeSource(KDTree<I> kdtree, double radius, Object outside) {
        this(kdtree, radius, outside, null);
    }

    public KDTreeSource(KDTree<I> kdtree, double radius, Object outside, Interval interval) {
        this.kdtree = kdtree;
        this.radius = radius;
        RealType first = (RealType)kdtree.firstElement();
        this.outside = KDTreeSource.asInputType(first, outside);
        if (null == interval) {
            long[] min = new long[kdtree.numDimensions()];
            long[] max = new long[kdtree.numDimensions()];
            for (int d = 0; d < kdtree.numDimensions(); ++d) {
                min[d] = (long)Math.floor(kdtree.realMin(d) - radius);
                max[d] = (long)Math.ceil(kdtree.realMax(d) + radius);
            }
            this.interval = new FinalInterval(min, max);
        } else {
            this.interval = interval;
        }
    }

    private static final <I extends RealType<I>> I asInputType(I first, Object ob) {
        if (first.getClass().isAssignableFrom(ob.getClass())) {
            return (I)((RealType)ob);
        }
        RealType v = (RealType)first.createVariable();
        if (v instanceof IntegerType && (ob instanceof Long || ob instanceof Integer || ob instanceof Short || ob instanceof Byte)) {
            ((IntegerType)v).setInteger(((Number)ob).longValue());
            return (I)v;
        }
        if (ob instanceof RealType) {
            v.setReal(((RealType)ob).getRealDouble());
            return (I)v;
        }
        if (ob instanceof Number) {
            v.setReal(((Number)ob).doubleValue());
            return (I)v;
        }
        throw new UnsupportedOperationException("KDTreeSource can't handle " + ob + " as outside value.");
    }

    @Override
    public <O extends RealType<O>> OFunction<O> reInit(O tmp, Map<String, LetBinding<O>> bindings, Converter<RealType<?>, O> converter, Map<Variable<O>, OFunction<O>> imgSources) {
        return new KDTreeRadiusSource<I, RealType>((RealType)tmp.copy(), converter, this.kdtree, this.radius, this.outside, this.interval);
    }

    public KDTree<I> getKDTree() {
        return this.kdtree;
    }

    @Override
    public Interval getInterval() {
        return this.interval;
    }
}

