/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.zarr;

import org.janelia.saalfeldlab.n5.Compression;
import org.janelia.saalfeldlab.n5.DatasetAttributes;
import org.janelia.saalfeldlab.n5.zarr.DType;

public class ZarrDatasetAttributes
extends DatasetAttributes {
    private final transient boolean isRowMajor;
    private final transient DType dType;
    private final transient byte[] fillBytes;
    private final transient String dimensionSeparator;

    public ZarrDatasetAttributes(long[] dimensions, int[] blockSize, DType dType, Compression compression, boolean isRowMajor, String fill_value, String dimensionSeparator) {
        super(dimensions, blockSize, dType.getDataType(), compression);
        this.dType = dType;
        this.isRowMajor = isRowMajor;
        this.fillBytes = dType.createFillBytes(fill_value);
        this.dimensionSeparator = dimensionSeparator;
    }

    public ZarrDatasetAttributes(long[] dimensions, int[] blockSize, DType dType, Compression compression, boolean isRowMajor, String fill_value) {
        this(dimensions, blockSize, dType, compression, isRowMajor, fill_value, ".");
    }

    public boolean isRowMajor() {
        return this.isRowMajor;
    }

    public DType getDType() {
        return this.dType;
    }

    public byte[] getFillBytes() {
        return this.fillBytes;
    }

    public String getDimensionSeparator() {
        return this.dimensionSeparator;
    }
}

