/*
 * Decompiled with CFR 0.152.
 */
package bdv.img.cache;

import java.util.function.Function;
import net.imglib2.cache.volatiles.CacheHints;
import net.imglib2.cache.volatiles.UncheckedVolatileCache;
import net.imglib2.cache.volatiles.VolatileCache;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.img.NativeImg;
import net.imglib2.img.basictypeaccess.DataAccess;
import net.imglib2.img.cell.AbstractCellImg;
import net.imglib2.img.cell.Cell;
import net.imglib2.img.cell.CellGrid;
import net.imglib2.img.list.AbstractLongListImg;
import net.imglib2.type.NativeType;
import net.imglib2.type.NativeTypeFactory;
import net.imglib2.util.Fraction;

public class VolatileCachedCellImg<T extends NativeType<T>, A extends DataAccess>
extends AbstractCellImg<T, A, Cell<A>, VolatileCachedCells<Cell<A>>> {
    private final VolatileCache<Long, Cell<A>> cache;

    public VolatileCachedCellImg(CellGrid grid, T type, CacheHints cacheHints, VolatileCache<Long, Cell<A>> cache) {
        super(grid, new VolatileCachedCells<Cell>(grid.getGridDimensions(), (arg_0, arg_1) -> ((UncheckedVolatileCache)cache.unchecked()).get(arg_0, arg_1), cacheHints), type.getEntitiesPerPixel());
        this.cache = cache;
        NativeTypeFactory typeFactory = type.getNativeTypeFactory();
        this.setLinkedType(typeFactory.createLinkedType((NativeImg)this));
    }

    public VolatileCache<Long, Cell<A>> getCache() {
        return this.cache;
    }

    public void setCacheHints(CacheHints cacheHints) {
        ((VolatileCachedCells)this.cells).cacheHints = cacheHints != null ? cacheHints : ((VolatileCachedCells)this.cells).defaultCacheHints;
    }

    public CacheHints getDefaultCacheHints() {
        return ((VolatileCachedCells)this.cells).defaultCacheHints;
    }

    public ImgFactory<T> factory() {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public Img<T> copy() {
        throw new UnsupportedOperationException("not implemented yet");
    }

    @Deprecated
    public VolatileCachedCellImg(CellGrid grid, Fraction entitiesPerPixel, Function<NativeImg<T, ? super A>, T> typeFactory, CacheHints cacheHints, Get<Cell<A>> get) {
        super(grid, new VolatileCachedCells<Cell<A>>(grid.getGridDimensions(), get, cacheHints), entitiesPerPixel);
        this.cache = null;
        this.setLinkedType((NativeType)typeFactory.apply((NativeImg<VolatileCachedCellImg, A>)this));
    }

    @Deprecated
    public VolatileCachedCellImg(CellGrid grid, T type, CacheHints cacheHints, Get<Cell<A>> get) {
        super(grid, new VolatileCachedCells<Cell<A>>(grid.getGridDimensions(), get, cacheHints), type.getEntitiesPerPixel());
        this.cache = null;
        NativeTypeFactory typeFactory = type.getNativeTypeFactory();
        this.setLinkedType(typeFactory.createLinkedType((NativeImg)this));
    }

    public static final class VolatileCachedCells<T>
    extends AbstractLongListImg<T> {
        private final Get<T> get;
        final CacheHints defaultCacheHints;
        CacheHints cacheHints;

        protected VolatileCachedCells(long[] dimensions, Get<T> get, CacheHints cacheHints) {
            super(dimensions);
            this.get = get;
            this.defaultCacheHints = cacheHints;
            this.cacheHints = cacheHints;
        }

        protected T get(long index) {
            return this.get.get(index, this.cacheHints);
        }

        protected void set(long index, T value) {
            throw new UnsupportedOperationException();
        }

        public ImgFactory<T> factory() {
            throw new UnsupportedOperationException();
        }

        public Img<T> copy() {
            throw new UnsupportedOperationException();
        }
    }

    @FunctionalInterface
    public static interface Get<T> {
        public T get(long var1, CacheHints var3);
    }
}

