/*
 * Decompiled with CFR 0.152.
 */
package bdv.img.n5;

import bdv.img.n5.N5ImageLoader;
import java.io.File;
import java.net.URI;
import mpicbg.spim.data.SpimDataInstantiationException;
import mpicbg.spim.data.XmlHelpers;
import mpicbg.spim.data.generic.sequence.AbstractSequenceDescription;
import mpicbg.spim.data.generic.sequence.ImgLoaderIo;
import mpicbg.spim.data.generic.sequence.ImgLoaders;
import mpicbg.spim.data.generic.sequence.XmlIoBasicImgLoader;
import net.imglib2.util.Cast;
import org.janelia.saalfeldlab.n5.N5FSReader;
import org.janelia.saalfeldlab.n5.N5Reader;
import org.jdom2.Content;
import org.jdom2.Element;

@ImgLoaderIo(format="bdv.n5", type=N5ImageLoader.class)
public class XmlIoN5ImageLoader
implements XmlIoBasicImgLoader<N5ImageLoader> {
    public static boolean PREFER_URI_FOR_LOCAL_FILES = true;

    public Element toXml(N5ImageLoader imgLoader, File basePath) {
        return this.toXml(imgLoader, basePath == null ? null : basePath.toURI());
    }

    public Element toXml(N5ImageLoader imgLoader, URI basePathURI) {
        Element elem = new Element("ImageLoader");
        elem.setAttribute("format", "bdv.n5");
        elem.setAttribute("version", "1.1");
        File n5File = XmlIoN5ImageLoader.getLocalFile(imgLoader.getN5URI());
        if (!PREFER_URI_FOR_LOCAL_FILES && n5File != null) {
            File basePath = basePathURI == null ? null : new File(basePathURI);
            elem.addContent((Content)XmlHelpers.pathElement((String)"n5", (File)n5File, (File)basePath));
        } else {
            elem.addContent((Content)XmlHelpers.pathElementURI((String)"n5", (URI)imgLoader.getN5URI(), (URI)basePathURI));
        }
        return elem;
    }

    private static File getLocalFile(URI uri) {
        if ("file".equalsIgnoreCase(uri.getScheme())) {
            return new File(uri);
        }
        if (uri.getScheme() == null) {
            return new File(uri.getPath());
        }
        return null;
    }

    public N5ImageLoader fromXml(Element elem, File basePath, AbstractSequenceDescription<?, ?, ?> sequenceDescription) {
        return this.fromXml(elem, basePath.toURI(), sequenceDescription);
    }

    public N5ImageLoader fromXml(Element elem, URI basePathURI, AbstractSequenceDescription<?, ?, ?> sequenceDescription) {
        URI uri = XmlHelpers.loadPathURI((Element)elem, (String)"n5", (URI)basePathURI);
        try {
            boolean hasScheme;
            String scheme = uri.getScheme();
            boolean bl = hasScheme = scheme != null;
            if (!hasScheme || "file".equalsIgnoreCase(uri.getScheme())) {
                String path = hasScheme ? new File(uri).getAbsolutePath() : uri.getPath();
                N5FSReader n5 = new N5FSReader(path);
                return new N5ImageLoader((N5Reader)n5, uri, sequenceDescription);
            }
        }
        catch (Exception scheme) {
            // empty catch block
        }
        try {
            XmlIoBasicImgLoader io = ImgLoaders.createXmlIoForFormat((String)"bdv.n5.cloud");
            return (N5ImageLoader)Cast.unchecked((Object)io.fromXml(elem, basePathURI, sequenceDescription));
        }
        catch (SpimDataInstantiationException e) {
            return null;
        }
    }
}

