/*
 * Decompiled with CFR 0.152.
 */
package bdv.tools.crop;

import bdv.AbstractSpimSource;
import bdv.export.ExportMipmapInfo;
import bdv.export.WriteSequenceToHdf5;
import bdv.img.MipmapInfo;
import bdv.img.hdf5.Hdf5ImageLoader;
import bdv.img.hdf5.Util;
import bdv.spimdata.SequenceDescriptionMinimal;
import bdv.spimdata.SpimDataMinimal;
import bdv.spimdata.XmlIoSpimDataMinimal;
import bdv.tools.crop.CropImgLoader;
import bdv.tools.transformation.TransformedSource;
import bdv.viewer.Source;
import bdv.viewer.SourceAndConverter;
import bdv.viewer.SynchronizedViewerState;
import bdv.viewer.ViewerPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import mpicbg.spim.data.SpimDataException;
import mpicbg.spim.data.generic.sequence.AbstractSequenceDescription;
import mpicbg.spim.data.generic.sequence.BasicImgLoader;
import mpicbg.spim.data.generic.sequence.BasicViewSetup;
import mpicbg.spim.data.registration.ViewRegistration;
import mpicbg.spim.data.registration.ViewRegistrations;
import mpicbg.spim.data.sequence.TimePoint;
import mpicbg.spim.data.sequence.TimePoints;
import mpicbg.spim.data.sequence.ViewId;
import net.imglib2.FinalRealInterval;
import net.imglib2.RealInterval;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.util.Intervals;

public class CropDialog
extends JDialog {
    private final ViewerPanel viewer;
    private final AbstractSequenceDescription<?, ?, ?> sequenceDescription;
    private final JTextField pathTextField;
    private final JSpinner spinnerMinTimepoint;
    private final JSpinner spinnerMaxTimepoint;
    private static final long serialVersionUID = 924395364255873920L;

    @Override
    public void setVisible(boolean b) {
        if (b) {
            int tp = this.viewer.state().getCurrentTimepoint();
            this.spinnerMinTimepoint.setValue(tp);
            this.spinnerMaxTimepoint.setValue(tp);
        }
        super.setVisible(b);
    }

    public CropDialog(Frame owner, ViewerPanel viewer, AbstractSequenceDescription<?, ?, ?> sequenceDescription) {
        super(owner, "crop and save", false);
        this.viewer = viewer;
        this.sequenceDescription = sequenceDescription;
        JPanel boxes = new JPanel();
        this.getContentPane().add((Component)boxes, "North");
        boxes.setLayout(new BoxLayout(boxes, 3));
        JPanel saveAsPanel = new JPanel();
        saveAsPanel.setLayout(new BorderLayout(0, 0));
        boxes.add(saveAsPanel);
        saveAsPanel.add((Component)new JLabel("save as"), "West");
        this.pathTextField = new JTextField("./crop.xml");
        saveAsPanel.add((Component)this.pathTextField, "Center");
        this.pathTextField.setColumns(20);
        JButton browseButton = new JButton("Browse");
        saveAsPanel.add((Component)browseButton, "East");
        JPanel timepointsPanel = new JPanel();
        boxes.add(timepointsPanel);
        timepointsPanel.add(new JLabel("timepoints from"));
        this.spinnerMinTimepoint = new JSpinner();
        int maxTimePointIndex = sequenceDescription.getTimePoints().size() - 1;
        this.spinnerMinTimepoint.setModel(new SpinnerNumberModel(0, 0, maxTimePointIndex, 1));
        timepointsPanel.add(this.spinnerMinTimepoint);
        timepointsPanel.add(new JLabel("to"));
        this.spinnerMaxTimepoint = new JSpinner();
        this.spinnerMaxTimepoint.setModel(new SpinnerNumberModel(0, 0, maxTimePointIndex, 1));
        timepointsPanel.add(this.spinnerMaxTimepoint);
        JPanel buttonsPanel = new JPanel();
        boxes.add(buttonsPanel);
        buttonsPanel.setLayout(new BorderLayout(0, 0));
        final JButton cropButton = new JButton("Crop and Save");
        buttonsPanel.add((Component)cropButton, "East");
        this.spinnerMinTimepoint.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int min = (Integer)CropDialog.this.spinnerMinTimepoint.getValue();
                int max = (Integer)CropDialog.this.spinnerMaxTimepoint.getValue();
                if (max < min) {
                    CropDialog.this.spinnerMaxTimepoint.setValue(min);
                }
            }
        });
        this.spinnerMaxTimepoint.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int max;
                int min = (Integer)CropDialog.this.spinnerMinTimepoint.getValue();
                if (min > (max = ((Integer)CropDialog.this.spinnerMaxTimepoint.getValue()).intValue())) {
                    CropDialog.this.spinnerMinTimepoint.setValue(max);
                }
            }
        });
        final JFileChooser fileChooser = new JFileChooser();
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return "xml files";
            }

            @Override
            public boolean accept(File f) {
                String s;
                int i;
                if (f.isDirectory()) {
                    return true;
                }
                if (f.isFile() && (i = (s = f.getName()).lastIndexOf(46)) > 0 && i < s.length() - 1) {
                    String ext = s.substring(i + 1).toLowerCase();
                    return ext.equals("xml");
                }
                return false;
            }
        });
        browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                fileChooser.setSelectedFile(new File(CropDialog.this.pathTextField.getText()));
                int returnVal = fileChooser.showSaveDialog(null);
                if (returnVal == 0) {
                    File file = fileChooser.getSelectedFile();
                    CropDialog.this.pathTextField.setText(file.getAbsolutePath());
                }
            }
        });
        cropButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File seqFile;
                File parent;
                String seqFilename = CropDialog.this.pathTextField.getText();
                if (!seqFilename.endsWith(".xml")) {
                    seqFilename = seqFilename + ".xml";
                }
                if ((parent = (seqFile = new File(seqFilename)).getParentFile()) == null || !parent.exists() || !parent.isDirectory()) {
                    System.err.println("Invalid export filename " + seqFilename);
                    return;
                }
                String hdf5Filename = seqFilename.substring(0, seqFilename.length() - 4) + ".h5";
                final File hdf5File = new File(hdf5Filename);
                final int minTimepointIndex = (Integer)CropDialog.this.spinnerMinTimepoint.getValue();
                final int maxTimepointIndex = (Integer)CropDialog.this.spinnerMaxTimepoint.getValue();
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            cropButton.setEnabled(false);
                            CropDialog.this.cropGlobal(minTimepointIndex, maxTimepointIndex, hdf5File, seqFile);
                            cropButton.setEnabled(true);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                }.start();
            }
        });
        ActionMap am = this.getRootPane().getActionMap();
        InputMap im = this.getRootPane().getInputMap(1);
        Object hideKey = new Object();
        AbstractAction hideAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                CropDialog.this.setVisible(false);
            }
        };
        im.put(KeyStroke.getKeyStroke(27, 0), hideKey);
        am.put(hideKey, hideAction);
        this.pack();
        this.setDefaultCloseOperation(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cropGlobal(int minTimepointIndex, int maxTimepointIndex, File hdf5File, File xmlFile) throws SpimDataException {
        SynchronizedViewerState state;
        int w = this.viewer.getDisplay().getWidth();
        int h = this.viewer.getDisplay().getHeight();
        int d = Math.min(w, h);
        boolean x = false;
        boolean y = false;
        int z = -d / 2;
        FinalRealInterval cropInterval = Intervals.createMinMaxReal((double[])new double[]{0.0, 0.0, z, 0 + w, 0 + h, z + d});
        List sequenceTimepointsOrdered = this.sequenceDescription.getTimePoints().getTimePointsOrdered();
        List sequenceSetupsOrdered = this.sequenceDescription.getViewSetupsOrdered();
        int nextSetupIndex = ((BasicViewSetup)sequenceSetupsOrdered.get(sequenceSetupsOrdered.size() - 1)).getId() + 1;
        ArrayList sources = new ArrayList();
        HashMap<Integer, BasicViewSetup> cropSetups = new HashMap<Integer, BasicViewSetup>();
        HashMap<Integer, Integer> setupIdToSourceIndex = new HashMap<Integer, Integer>();
        AffineTransform3D globalToCropTransform = new AffineTransform3D();
        SynchronizedViewerState synchronizedViewerState = state = this.viewer.state();
        synchronized (synchronizedViewerState) {
            state.getViewerTransform(globalToCropTransform);
            for (SourceAndConverter<?> s : state.getSources()) {
                BasicViewSetup setup;
                int setupId;
                Source<Object> source = s.getSpimSource();
                sources.add(source);
                while (source instanceof TransformedSource) {
                    source = ((TransformedSource)source).getWrappedSource();
                }
                if (source instanceof AbstractSpimSource) {
                    setupId = ((AbstractSpimSource)source).getSetupId();
                    setup = (BasicViewSetup)this.sequenceDescription.getViewSetups().get(setupId);
                } else {
                    setupId = nextSetupIndex++;
                    setup = new BasicViewSetup(setupId, Integer.toString(setupId), null, null);
                }
                cropSetups.put(setup.getId(), setup);
                setupIdToSourceIndex.put(setup.getId(), sources.size() - 1);
            }
        }
        HashMap<Integer, Integer> timepointIdToTimepointIndex = new HashMap<Integer, Integer>();
        ArrayList<TimePoint> timepointsToCrop = new ArrayList<TimePoint>();
        for (int tp = minTimepointIndex; tp <= maxTimepointIndex; ++tp) {
            TimePoint timepoint = (TimePoint)sequenceTimepointsOrdered.get(tp);
            timepointIdToTimepointIndex.put(timepoint.getId(), tp);
            timepointsToCrop.add(timepoint);
        }
        CropImgLoader cropper = new CropImgLoader(sources, globalToCropTransform, (RealInterval)cropInterval, timepointIdToTimepointIndex, setupIdToSourceIndex);
        SequenceDescriptionMinimal seq = new SequenceDescriptionMinimal(new TimePoints(timepointsToCrop), cropSetups, cropper, null);
        HashMap<Integer, ExportMipmapInfo> perSetupMipmapInfo = new HashMap<Integer, ExportMipmapInfo>();
        Hdf5ImageLoader loader = (Hdf5ImageLoader)this.sequenceDescription.getImgLoader();
        Iterator iterator = cropSetups.keySet().iterator();
        while (iterator.hasNext()) {
            int setupId = (Integer)iterator.next();
            MipmapInfo info = ((Hdf5ImageLoader.SetupImgLoader)loader.getSetupImgLoader(setupId)).getMipmapInfo();
            if (info == null) {
                perSetupMipmapInfo.put(setupId, new ExportMipmapInfo(new int[][]{{1, 1, 1}}, new int[][]{{64, 64, 64}}));
                continue;
            }
            perSetupMipmapInfo.put(setupId, new ExportMipmapInfo(Util.castToInts(info.getResolutions()), info.getSubdivisions()));
        }
        int numThreads = Math.max(1, Runtime.getRuntime().availableProcessors() - 2);
        WriteSequenceToHdf5.writeHdf5File(seq, perSetupMipmapInfo, true, hdf5File, null, null, numThreads, null);
        ArrayList<ViewRegistration> registrations = new ArrayList<ViewRegistration>();
        for (TimePoint timepoint : timepointsToCrop) {
            int timepointId = timepoint.getId();
            for (BasicViewSetup setup : cropSetups.values()) {
                int setupId = setup.getId();
                AffineTransform3D model = cropper.getCroppedTransform(new ViewId(timepointId, setupId));
                registrations.add(new ViewRegistration(timepointId, setupId, model));
            }
        }
        seq.setImgLoader((BasicImgLoader)new Hdf5ImageLoader(hdf5File, null, seq, false));
        File basePath = xmlFile.getParentFile();
        SpimDataMinimal spimData = new SpimDataMinimal(basePath, seq, new ViewRegistrations(registrations));
        new XmlIoSpimDataMinimal().save(spimData, xmlFile.getAbsolutePath());
    }
}

