/*
 * Decompiled with CFR 0.152.
 */
package bdv.viewer.render;

import net.imglib2.RandomAccessible;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.basictypeaccess.DataAccess;
import net.imglib2.img.basictypeaccess.array.IntArray;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.view.IntervalView;
import net.imglib2.view.MixedTransformView;

public class ProjectorUtils {
    public static int[] getARGBArrayImgData(RandomAccessible<?> img) {
        if (!(img instanceof ArrayImg)) {
            return null;
        }
        ArrayImg aimg = (ArrayImg)img;
        if (!(aimg.firstElement() instanceof ARGBType)) {
            return null;
        }
        DataAccess access = aimg.update(null);
        if (!(access instanceof IntArray)) {
            return null;
        }
        return ((IntArray)access).getCurrentStorageArray();
    }

    public static ArrayData getARGBArrayData(RandomAccessible<?> img) {
        if (img instanceof IntervalView) {
            IntervalView view = (IntervalView)img;
            RandomAccessible source = view.getSource();
            int tx = 0;
            int ty = 0;
            if (source instanceof MixedTransformView) {
                MixedTransformView tview = (MixedTransformView)source;
                tx = (int)tview.getTransformToSource().getTranslation(0);
                ty = (int)tview.getTransformToSource().getTranslation(1);
                source = tview.getSource();
            }
            if (source instanceof ArrayImg) {
                ArrayImg aimg = (ArrayImg)source;
                if (!(aimg.firstElement() instanceof ARGBType)) {
                    return null;
                }
                DataAccess access = aimg.update(null);
                if (!(access instanceof IntArray)) {
                    return null;
                }
                int[] data = ((IntArray)access).getCurrentStorageArray();
                int ox = tx + (int)view.min(0);
                int oy = ty + (int)view.min(1);
                int width = (int)view.dimension(0);
                int height = (int)view.dimension(1);
                int stride = (int)aimg.dimension(0);
                return new ArrayData(data, ox, oy, width, height, stride);
            }
        }
        return null;
    }

    public static class ArrayData {
        private final int[] data;
        private final int ox;
        private final int oy;
        private final int width;
        private final int height;
        private final int stride;

        public ArrayData(int[] data, int ox, int oy, int width, int height, int stride) {
            this.data = data;
            this.ox = ox;
            this.oy = oy;
            this.width = width;
            this.height = height;
            this.stride = stride;
        }

        public int[] data() {
            return this.data;
        }

        public int ox() {
            return this.ox;
        }

        public int oy() {
            return this.oy;
        }

        public int width() {
            return this.width;
        }

        public int height() {
            return this.height;
        }

        public int size() {
            return this.width * this.height;
        }

        public int stride() {
            return this.stride;
        }

        public String toString() {
            return "ArrayData{ox=" + this.ox + ", oy=" + this.oy + ", width=" + this.width + ", height=" + this.height + ", stride=" + this.stride + '}';
        }
    }
}

