/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.coloc.icq;

import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.util.IterablePair;
import net.imglib2.util.Pair;
import org.scijava.function.Computers;
import org.scijava.function.Functions;
import org.scijava.ops.image.coloc.ColocUtil;
import org.scijava.ops.spi.Nullable;
import org.scijava.ops.spi.OpDependency;

public class LiICQ<T extends RealType<T>, U extends RealType<U>, V extends RealType<V>>
implements Functions.Arity4<Iterable<T>, Iterable<U>, DoubleType, DoubleType, Double> {
    @OpDependency(name="stats.mean")
    private Computers.Arity1<Iterable<T>, DoubleType> meanTOp;
    @OpDependency(name="stats.mean")
    private Computers.Arity1<Iterable<U>, DoubleType> meanUOp;

    public Double apply(Iterable<T> image1, Iterable<U> image2, @Nullable DoubleType mean1, @Nullable DoubleType mean2) {
        if (!ColocUtil.sameIterationOrder(image1, image2)) {
            throw new IllegalArgumentException("Input and output must have the same dimensionality and iteration order!");
        }
        IterablePair samples = new IterablePair(image1, image2);
        double m1 = mean1 == null ? this.computeMeanTOf(image1) : mean1.get();
        double m2 = mean2 == null ? this.computeMeanUOf(image2) : mean2.get();
        long numPositiveProducts = 0L;
        long numNegativeProducts = 0L;
        for (Pair value : samples) {
            double ch2;
            double ch1 = ((RealType)value.getA()).getRealDouble();
            double productOfDifferenceOfMeans = (m1 - ch1) * (m2 - (ch2 = ((RealType)value.getB()).getRealDouble()));
            if (productOfDifferenceOfMeans < 0.0) {
                ++numNegativeProducts;
                continue;
            }
            ++numPositiveProducts;
        }
        double icqValue = (double)numPositiveProducts / (double)(numNegativeProducts + numPositiveProducts) - 0.5;
        return icqValue;
    }

    private double computeMeanTOf(Iterable<T> in) {
        DoubleType mean = new DoubleType();
        this.meanTOp.compute(in, (Object)mean);
        return mean.get();
    }

    private double computeMeanUOf(Iterable<U> in) {
        DoubleType mean = new DoubleType();
        this.meanUOp.compute(in, (Object)mean);
        return mean.get();
    }
}

