/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.coloc.pValue;

import java.util.List;
import java.util.Random;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.imglib2.Cursor;
import net.imglib2.Dimensions;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Intervals;
import net.imglib2.util.Util;
import net.imglib2.view.Views;
import org.scijava.concurrent.Parallelization;
import org.scijava.concurrent.TaskExecutor;
import org.scijava.function.Computers;
import org.scijava.ops.image.coloc.ShuffledView;
import org.scijava.ops.image.coloc.pValue.PValueResult;
import org.scijava.ops.spi.Nullable;

public class DefaultPValue<T extends RealType<T>, U extends RealType<U>>
implements Computers.Arity6<RandomAccessibleInterval<T>, RandomAccessibleInterval<U>, BiFunction<? super RandomAccessibleInterval<T>, ? super RandomAccessibleInterval<U>, Double>, Integer, Dimensions, Long, PValueResult> {
    public void compute(RandomAccessibleInterval<T> image1, RandomAccessibleInterval<U> image2, BiFunction<? super RandomAccessibleInterval<T>, ? super RandomAccessibleInterval<U>, Double> op, @Nullable Integer nrRandomizations, @Nullable Dimensions psfSize, @Nullable Long seed, PValueResult output) {
        if (nrRandomizations == null) {
            nrRandomizations = 100;
        }
        if (seed == null) {
            seed = 657924148L;
        }
        int[] blockSize = DefaultPValue.blockSize(image1, psfSize);
        RandomAccessibleInterval<T> trimmedImage1 = DefaultPValue.trim(image1, blockSize);
        RandomAccessibleInterval<U> trimmedImage2 = DefaultPValue.trim(image2, blockSize);
        RealType type1 = (RealType)Util.getTypeFromInterval(image1);
        double[] sampleDistribution = new double[nrRandomizations.intValue()];
        double value = op.apply(trimmedImage1, trimmedImage2);
        TaskExecutor executor = Parallelization.getTaskExecutor();
        int numTasks = executor.suggestNumberOfTasks();
        Random r = new Random(seed);
        long[] seeds = new long[nrRandomizations.intValue()];
        for (int s = 0; s < nrRandomizations; ++s) {
            seeds[s] = r.nextLong();
        }
        List params = IntStream.rangeClosed(0, numTasks - 1).boxed().collect(Collectors.toList());
        Integer nr = nrRandomizations;
        Consumer<Integer> task = t -> {
            int index;
            int offset = t * nr / numTasks;
            int count = (t + 1) * nr / numTasks - offset;
            ShuffledView shuffled = new ShuffledView(trimmedImage1, blockSize, seeds[offset]);
            Img buffer = Util.getSuitableImgFactory(shuffled, (Object)type1).create(shuffled);
            for (int i = 0; i < count && (index = offset + i) < nr; ++i) {
                if (i > 0) {
                    shuffled.shuffleBlocks(seeds[index]);
                }
                this.copy(shuffled, buffer);
                sampleDistribution[index] = (Double)op.apply((RandomAccessibleInterval<RandomAccessibleInterval<T>>)buffer, (RandomAccessibleInterval<RandomAccessibleInterval<U>>)trimmedImage2);
            }
        };
        try {
            executor.forEach(params, task);
        }
        catch (Exception exc) {
            Throwable cause = exc.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(exc);
        }
        output.setColocValue(value);
        output.setColocValuesArray(sampleDistribution);
        output.setPValue(this.calculatePvalue(value, sampleDistribution));
    }

    private void copy(ShuffledView<T> shuffled, Img<T> buffer) {
        Cursor cursor = buffer.localizingCursor();
        RandomAccess<T> ra = shuffled.randomAccess();
        while (cursor.hasNext()) {
            RealType v = (RealType)cursor.next();
            ra.setPosition((Localizable)cursor);
            v.set((Type)((RealType)ra.get()));
        }
    }

    private double calculatePvalue(double input, double[] distribution) {
        double count = 0.0;
        for (int i = 0; i < distribution.length; ++i) {
            if (!(distribution[i] > input)) continue;
            count += 1.0;
        }
        double pval = count / (double)distribution.length;
        return pval;
    }

    private static int[] blockSize(Dimensions image, Dimensions psfSize) {
        if (psfSize != null) {
            return Intervals.dimensionsAsIntArray((Dimensions)psfSize);
        }
        int[] blockSize = new int[image.numDimensions()];
        for (int d = 0; d < blockSize.length; ++d) {
            long size = (long)Math.floor(Math.sqrt(image.dimension(d)));
            if (size > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Image dimension #" + d + " is too large: " + image.dimension(d));
            }
            blockSize[d] = (int)size;
        }
        return blockSize;
    }

    private static <V> RandomAccessibleInterval<V> trim(RandomAccessibleInterval<V> image, int[] blockSize) {
        long[] min = Intervals.minAsLongArray(image);
        long[] max = Intervals.maxAsLongArray(image);
        int d = 0;
        while (d < blockSize.length) {
            long trimSize = image.dimension(d) % (long)blockSize[d];
            long half = trimSize / 2L;
            int n = d;
            min[n] = min[n] + half;
            int n2 = d++;
            max[n2] = max[n2] - (trimSize - half);
        }
        return Views.interval(image, (long[])min, (long[])max);
    }
}

