/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.create;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.imglib2.Cursor;
import net.imglib2.Dimensions;
import net.imglib2.FinalDimensions;
import net.imglib2.Interval;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.img.basictypeaccess.array.ArrayDataAccess;
import net.imglib2.roi.labeling.ImgLabeling;
import net.imglib2.roi.labeling.LabelingMapping;
import net.imglib2.type.BooleanType;
import net.imglib2.type.NativeType;
import net.imglib2.type.Type;
import net.imglib2.type.logic.BitType;
import net.imglib2.type.numeric.ComplexType;
import net.imglib2.type.numeric.IntegerType;
import net.imglib2.type.numeric.complex.ComplexDoubleType;
import net.imglib2.type.numeric.complex.ComplexFloatType;
import net.imglib2.type.numeric.integer.ByteType;
import net.imglib2.type.numeric.integer.IntType;
import net.imglib2.type.numeric.integer.LongType;
import net.imglib2.type.numeric.integer.ShortType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.integer.UnsignedIntType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Util;
import net.imglib2.view.Views;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.scijava.function.Functions;
import org.scijava.function.Producer;
import org.scijava.ops.image.create.DefaultCreateKernel2ndDerivBiGauss;
import org.scijava.ops.image.create.DefaultCreateKernelBiGauss;
import org.scijava.ops.image.create.DefaultCreateKernelGabor;
import org.scijava.ops.image.create.DefaultCreateKernelGauss;
import org.scijava.ops.image.create.DefaultCreateKernelGibsonLanni;
import org.scijava.ops.image.create.DefaultCreateKernelLog;
import org.scijava.ops.image.create.DefaultCreateKernelSobel;
import org.scijava.ops.image.create.Imgs;
import org.scijava.ops.spi.OpDependency;

public class Creators<N extends NativeType<N>, L, I extends IntegerType<I>, T extends Type<T>, C extends ComplexType<C>, W extends ComplexType<W> & NativeType<W>, B extends BooleanType<B>, A extends ArrayDataAccess<A>> {
    String iF = "imgFactory";
    public final Producer<ImgFactory<DoubleType>> factorySource = () -> new ArrayImgFactory((NativeType)new DoubleType());
    public final Function<Dimensions, ImgFactory<DoubleType>> factoryFromDims = dims -> Util.getSuitableImgFactory((Dimensions)dims, (Object)new DoubleType());
    public final BiFunction<Dimensions, L, ImgFactory<L>> factoryFromDimsAndType = Util::getSuitableImgFactory;
    public final Function<Img<L>, ImgFactory<L>> factoryFromImg = img -> img.factory();
    public final Functions.Arity3<Dimensions, T, ImgFactory<T>, Img<T>> imgFromDimsTypeAndFactory = (dims, type, factory) -> Imgs.create(factory, dims, type);
    public final BiFunction<Dimensions, T, Img<T>> imgFromDimsAndType = (dims, type) -> {
        ImgFactory factory = dims instanceof Img ? ((Img)dims).factory() : Util.getSuitableImgFactory((Dimensions)dims, (Object)type);
        return Imgs.create(factory, dims, type);
    };
    public final Function<int[], Img<DoubleType>> imgFromIntArray = array -> {
        FinalDimensions dims = new FinalDimensions(array);
        DoubleType type = new DoubleType();
        return Imgs.create(Util.getSuitableImgFactory((Dimensions)dims, (Object)type), (Dimensions)dims, type);
    };
    public final Function<Integer[], Img<DoubleType>> imgFromIntegerArray = array -> this.imgFromIntArray.apply(Arrays.stream(array).mapToInt(Integer::intValue).toArray());
    public final Function<long[], Img<DoubleType>> imgFromPrimitiveLongArray = array -> {
        FinalDimensions dims = new FinalDimensions(array);
        DoubleType type = new DoubleType();
        return Imgs.create(Util.getSuitableImgFactory((Dimensions)dims, (Object)type), (Dimensions)dims, type);
    };
    public final Function<Long[], Img<DoubleType>> imgFromLongArray = array -> this.imgFromPrimitiveLongArray.apply(Arrays.stream(array).mapToLong(Long::longValue).toArray());
    public final Function<IterableInterval<T>, Img<T>> imgFromII = ii -> this.imgFromDimsAndType.apply((Dimensions)ii, (Dimensions)((Type)ii.firstElement()));
    public final Function<Img<T>, Img<T>> imgFromImg = img -> Imgs.create(img.factory(), (Dimensions)img, (Type)img.firstElement());
    public final Function<ArrayImg<N, A>, ArrayImg<N, A>> arrayImgFromArrayImg = input -> input.factory().create(input.dimensionsAsLongArray());
    public final Function<T, T> typeFromSampleType = sample -> sample.createVariable();
    public final Function<Img<I>, ImgLabeling<L, I>> imgLabelingFromImg = ImgLabeling::new;
    public final Functions.Arity3<Dimensions, I, ImgFactory<I>, ImgLabeling<L, I>> imgLabelingFromDimsTypeAndFactory = (dims, type, factory) -> {
        Img<IntegerType> img = Imgs.create(factory, dims, type);
        return this.imgLabelingFromImg.apply(img);
    };
    public final BiFunction<Dimensions, I, ImgLabeling<L, I>> imgLabelingFromDimsAndType = (dims, type) -> (ImgLabeling)this.imgLabelingFromDimsTypeAndFactory.apply(dims, type, (Object)Util.getSuitableImgFactory((Dimensions)dims, (Object)type));
    public final BiFunction<double[][], C, RandomAccessibleInterval<C>> kernel2DFromValuesAndType = (arr, type) -> {
        FinalDimensions dims = new FinalDimensions(new long[]{((double[][])arr).length, arr[0].length});
        RandomAccessibleInterval rai = (RandomAccessibleInterval)this.imgFromDimsAndType.apply((Dimensions)dims, (Dimensions)type);
        Cursor cursor = Views.iterable((RandomAccessibleInterval)rai).cursor();
        for (int j = 0; j < ((double[][])arr).length; ++j) {
            for (int k = 0; k < arr[j].length; ++k) {
                cursor.fwd();
                ((ComplexType)cursor.get()).setReal(arr[j][k]);
            }
        }
        return rai;
    };
    public final Function<double[][], RandomAccessibleInterval<DoubleType>> kernel2DFromValues = arr -> this.kernel2DFromValuesAndType.apply((double[][])arr, (C)new DoubleType());
    public final BiFunction<double[], C, RandomAccessibleInterval<C>> kernelGauss = (numDims, type) -> DefaultCreateKernelGauss.createKernel(numDims, type, this.imgFromDimsAndType);
    public final Function<double[], RandomAccessibleInterval<DoubleType>> kernelGaussDoubleType = sigmas -> this.kernelGauss.apply((double[])sigmas, (C)new DoubleType());
    public final Functions.Arity3<Double, Integer, C, RandomAccessibleInterval<C>> kernelGaussSymmetric = (sigma, numDims, type) -> {
        double[] sigmas = new double[numDims.intValue()];
        Arrays.fill(sigmas, sigma);
        return this.kernelGauss.apply(sigmas, type);
    };
    public final BiFunction<Double, Integer, RandomAccessibleInterval<DoubleType>> kernelGaussSymmetricDoubleType = (sigma, numDims) -> (RandomAccessibleInterval)this.kernelGaussSymmetric.apply(sigma, numDims, (Object)new DoubleType());
    public final BiFunction<double[], C, RandomAccessibleInterval<C>> kernelLog = (sigmas, type) -> DefaultCreateKernelLog.createKernel(sigmas, type, this.imgFromDimsAndType);
    public final Function<double[], RandomAccessibleInterval<DoubleType>> kernelLogDoubleType = sigmas -> this.kernelLog.apply((double[])sigmas, (C)new DoubleType());
    public final Functions.Arity3<Double, Integer, C, RandomAccessibleInterval<C>> kernelLogSymmetric = (sigma, numDims, type) -> {
        double[] sigmas = new double[numDims.intValue()];
        Arrays.fill(sigmas, sigma);
        return this.kernelLog.apply(sigmas, type);
    };
    public final BiFunction<Double, Integer, RandomAccessibleInterval<DoubleType>> kernelLogSymmetricDoubleType = (sigma, numDims) -> (RandomAccessibleInterval)this.kernelLogSymmetric.apply(sigma, numDims, (Object)new DoubleType());
    public final Functions.Arity9<Dimensions, Double, Double, Double, Double, Double, Double, Double, W, Img<W>> kernelDiffraction = (dims, NA, lambda, ns, ni, resLateral, resAxial, pZ, type) -> DefaultCreateKernelGibsonLanni.createKernel(dims, NA, lambda, ns, ni, resLateral, resAxial, pZ, type, this.imgFromDimsAndType);
    public final Functions.Arity3<double[], Integer, C, RandomAccessibleInterval<C>> kernelBiGauss = (sigmas, numDims, outType) -> DefaultCreateKernelBiGauss.createKernel(sigmas, numDims, outType, this.imgFromDimsAndType);
    public final BiFunction<double[], Integer, RandomAccessibleInterval<DoubleType>> kernelBiGaussDoubleType = (sigmas, numDims) -> (RandomAccessibleInterval)this.kernelBiGauss.apply(sigmas, numDims, (Object)new DoubleType());
    public final Functions.Arity3<double[], Integer, C, RandomAccessibleInterval<C>> kernel2ndDerivBiGauss = (sigmas, numDims, outType) -> DefaultCreateKernel2ndDerivBiGauss.createKernel(sigmas, numDims, outType, this.imgFromDimsAndType);
    public final BiFunction<double[], Integer, RandomAccessibleInterval<DoubleType>> kernel2ndDerivBiGaussDoubleType = (sigmas, numDims) -> (RandomAccessibleInterval)this.kernel2ndDerivBiGauss.apply(sigmas, numDims, (Object)new DoubleType());
    public final Functions.Arity3<double[], double[], C, RandomAccessibleInterval<C>> kernelGabor = (sigmas, periods, outType) -> DefaultCreateKernelGabor.createKernel(sigmas, periods, outType, this.imgFromDimsAndType);
    public final BiFunction<double[], double[], RandomAccessibleInterval<DoubleType>> kernelGaborDouble = (sigmas, periods) -> (RandomAccessibleInterval)this.kernelGabor.apply(sigmas, periods, (Object)new DoubleType());
    public final BiFunction<double[], double[], RandomAccessibleInterval<FloatType>> kernelGaborFloat = (sigmas, periods) -> (RandomAccessibleInterval)this.kernelGabor.apply(sigmas, periods, (Object)new FloatType());
    public final BiFunction<double[], double[], RandomAccessibleInterval<ComplexDoubleType>> kernelGaborComplexDouble = (sigmas, periods) -> (RandomAccessibleInterval)this.kernelGabor.apply(sigmas, periods, (Object)new ComplexDoubleType());
    public final BiFunction<double[], double[], RandomAccessibleInterval<ComplexFloatType>> kernelGaborComplexFloat = (sigmas, periods) -> (RandomAccessibleInterval)this.kernelGabor.apply(sigmas, periods, (Object)new ComplexFloatType());
    public final Functions.Arity3<Double, double[], C, RandomAccessibleInterval<C>> kernelGaborSingleSigma = (sigma, periods, outType) -> {
        double[] sigmas = new double[((double[])periods).length];
        Arrays.fill(sigmas, sigma);
        return DefaultCreateKernelGabor.createKernel(sigmas, periods, outType, this.imgFromDimsAndType);
    };
    public final BiFunction<Double, double[], RandomAccessibleInterval<DoubleType>> kernelGaborDoubleSingleSigma = (sigma, periods) -> {
        double[] sigmas = new double[((double[])periods).length];
        Arrays.fill(sigmas, sigma);
        return (RandomAccessibleInterval)this.kernelGabor.apply((Object)sigmas, periods, (Object)new DoubleType());
    };
    public final BiFunction<Double, double[], RandomAccessibleInterval<FloatType>> kernelGaborFloatSingleSigma = (sigma, periods) -> {
        double[] sigmas = new double[((double[])periods).length];
        Arrays.fill(sigmas, sigma);
        return (RandomAccessibleInterval)this.kernelGabor.apply((Object)sigmas, periods, (Object)new FloatType());
    };
    public final BiFunction<Double, double[], RandomAccessibleInterval<ComplexDoubleType>> kernelGaborComplexDoubleSingleSigma = (sigma, periods) -> {
        double[] sigmas = new double[((double[])periods).length];
        Arrays.fill(sigmas, sigma);
        return (RandomAccessibleInterval)this.kernelGabor.apply((Object)sigmas, periods, (Object)new ComplexDoubleType());
    };
    public final BiFunction<Double, double[], RandomAccessibleInterval<ComplexFloatType>> kernelGaborComplexFloatSingleSigma = (sigma, periods) -> {
        double[] sigmas = new double[((double[])periods).length];
        Arrays.fill(sigmas, sigma);
        return (RandomAccessibleInterval)this.kernelGabor.apply((Object)sigmas, periods, (Object)new ComplexFloatType());
    };
    public final Function<C, RandomAccessibleInterval<C>> kernelSobel = outType -> DefaultCreateKernelSobel.createKernel(outType, this.imgFromDimsAndType);
    public final Producer<LabelingMapping<L>> labelingMappingSource = () -> new LabelingMapping((IntegerType)new LongType());
    public final Function<Long, IntegerType> integerTypeFromLong = maxValue -> {
        if (maxValue <= 0L) {
            return new IntType();
        }
        if (maxValue <= 1L) {
            return new BitType();
        }
        if (maxValue <= 127L) {
            return new ByteType();
        }
        if (maxValue <= 255L) {
            return new UnsignedByteType();
        }
        if (maxValue <= 32767L) {
            return new ShortType();
        }
        if (maxValue <= 65535L) {
            return new UnsignedShortType();
        }
        if (maxValue <= Integer.MAX_VALUE) {
            return new IntType();
        }
        if (maxValue <= 0xFFFFFFFFL) {
            return new UnsignedIntType();
        }
        return new LongType();
    };
    public final Function<Integer, LabelingMapping<L>> labelingMapping = maxNumSets -> new LabelingMapping(this.integerTypeFromLong.apply(maxNumSets.longValue()));
    public final Function<Class<L>, L> object = clazz -> {
        try {
            return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
    };
    public final Producer<Vector3d> defaultVector3d = () -> new Vector3d();
    public final Producer<Vector3f> defaultVector3f = () -> new Vector3f();

    public static <T extends Type<T>> Img<T> imgFromInterval(@OpDependency(name="engine.create") Producer<T> typeCreator, Interval interval) {
        Type type = (Type)typeCreator.create();
        return Imgs.create(Util.getSuitableImgFactory((Dimensions)interval, (Object)type), (Dimensions)interval, type);
    }
}

