/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.create;

import java.util.function.BiFunction;
import net.imglib2.Cursor;
import net.imglib2.Dimensions;
import net.imglib2.FinalInterval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.ComplexType;
import net.imglib2.view.Views;

public final class DefaultCreateKernelSobel {
    private static final float[] values = new float[]{1.0f, 2.0f, 1.0f, -1.0f, 0.0f, 1.0f};

    private DefaultCreateKernelSobel() {
    }

    public static <T extends Type<T>, C extends ComplexType<C>> RandomAccessibleInterval<C> createKernel(C type, BiFunction<Dimensions, T, Img<T>> createFunc) {
        long[] dim = new long[4];
        dim[0] = 3L;
        dim[1] = 1L;
        for (int k = 2; k < dim.length; ++k) {
            dim[k] = 1L;
        }
        dim[dim.length - 1] = 2L;
        RandomAccessibleInterval output = (RandomAccessibleInterval)createFunc.apply((Dimensions)new FinalInterval(dim), (Dimensions)type);
        Cursor cursor = Views.iterable((RandomAccessibleInterval)output).cursor();
        int i = 0;
        while (cursor.hasNext()) {
            cursor.fwd();
            ((ComplexType)cursor.get()).setReal(values[i]);
            ++i;
        }
        return output;
    }
}

