/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.features.haralick;

import java.util.function.Function;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.DoubleType;
import org.scijava.ops.image.features.haralick.AbstractHaralickFeature;
import org.scijava.ops.image.image.cooccurrenceMatrix.MatrixOrientation;
import org.scijava.ops.spi.OpDependency;

public class DefaultClusterShade<T extends RealType<T>>
extends AbstractHaralickFeature<T> {
    @OpDependency(name="features.haralick.coocMeanX")
    private Function<double[][], DoubleType> coocMeanXFunc;
    @OpDependency(name="features.haralick.coocMeanY")
    private Function<double[][], DoubleType> coocMeanYFunc;

    public DoubleType apply(RandomAccessibleInterval<T> input, Integer numGreyLevels, Integer distance, MatrixOrientation orientation) {
        double[][] matrix = this.getCooccurrenceMatrix(input, numGreyLevels, distance, orientation);
        double mux = this.coocMeanXFunc.apply(matrix).getRealDouble();
        double muy = this.coocMeanYFunc.apply(matrix).getRealDouble();
        double res = 0.0;
        for (int j = 0; j < matrix.length; ++j) {
            for (int i = 0; i < matrix.length; ++i) {
                res += Math.pow((double)(i + j) - mux - muy, 3.0) * matrix[j][i];
            }
        }
        DoubleType output = new DoubleType();
        output.setReal(res);
        return output;
    }
}

