/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.features.zernike;

import net.imglib2.Cursor;
import net.imglib2.IterableInterval;
import net.imglib2.type.numeric.RealType;
import org.scijava.function.Functions;
import org.scijava.ops.image.features.zernike.Polynom;
import org.scijava.ops.image.features.zernike.ZernikeMoment;
import org.scijava.ops.image.util.BigComplex;

public class ZernikeComputer<T extends RealType<T>>
implements Functions.Arity3<IterableInterval<T>, Integer, Integer, ZernikeMoment> {
    public ZernikeMoment apply(IterableInterval<T> ii, Integer order, Integer repetition) {
        double width2 = (double)(ii.dimension(0) - 1L) / 2.0;
        double height2 = (double)(ii.dimension(1) - 1L) / 2.0;
        double centerX = width2 + (double)ii.min(0);
        double centerY = height2 + (double)ii.min(1);
        double radius = Math.sqrt(width2 * width2 + height2 * height2);
        double[][] d = this.computePascalsTriangle(order);
        ZernikeMoment moment = this.initZernikeMoment(order, repetition, d);
        Cursor cur = ii.localizingCursor();
        while (cur.hasNext()) {
            int y;
            double ym;
            cur.fwd();
            int x = (int)((long)cur.getIntPosition(0) - ii.min(0));
            double xm = ((double)x - centerX) / radius;
            double r = Math.sqrt(xm * xm + (ym = ((double)(y = (int)((long)cur.getIntPosition(1) - ii.min(1))) - centerY) / radius) * ym);
            if (!(r <= 1.0) || ((RealType)cur.get()).getRealDouble() == 0.0) continue;
            double theta = Math.atan2(xm, ym);
            moment.getZm().add(this.multiplyExp(1.0, moment.getP().evaluate(r), theta, moment.getM()));
        }
        this.normalize(moment.getZm(), moment.getN(), this.getNumberOfPixelsInUnitDisk(radius));
        return moment;
    }

    private long getNumberOfPixelsInUnitDisk(double r) {
        long tmp = 0L;
        int i = 1;
        while ((double)i <= Math.floor(r)) {
            tmp = (long)((double)tmp + Math.floor(Math.sqrt(r * r - (double)(i * i))));
            ++i;
        }
        return (long)(1.0 + 4.0 * Math.floor(r)) + 4L * tmp;
    }

    private BigComplex multiplyExp(double pixel, double rad, double theta, int m) {
        BigComplex c = new BigComplex();
        c.setReal(pixel * rad * Math.cos((double)m * theta));
        c.setImag(-(pixel * rad * Math.sin((double)m * theta)));
        return c;
    }

    private void normalize(BigComplex complex, int n, long count) {
        complex.setReal(complex.getRealDouble() * (double)(n + 1) / (double)count);
        complex.setImag(complex.getImaginaryDouble() * (double)(n + 1) / (double)count);
    }

    private ZernikeMoment initZernikeMoment(int o, int repetition, double[][] d) {
        if (o - Math.abs(repetition) % 2 != 0) {
            // empty if block
        }
        return this.createZernikeMoment(d, o, repetition);
    }

    private ZernikeMoment createZernikeMoment(double[][] d, int n, int m) {
        ZernikeMoment p = new ZernikeMoment();
        p.setM(m);
        p.setN(n);
        p.setP(ZernikeComputer.createRadialPolynom(n, m, d));
        BigComplex complexNumber = new BigComplex();
        p.setZm(complexNumber);
        return p;
    }

    private double[][] computePascalsTriangle(int max) {
        double[][] d = new double[max + 1][max + 1];
        for (int n = 0; n <= max; ++n) {
            for (int k = 0; k <= n; ++k) {
                d[n][k] = n == 0 && k == 0 || n == k || k == 0 ? 1.0 : (double)n / (double)(n - k) * d[n - 1][k];
            }
        }
        return d;
    }

    public static int computeBinomialFactorial(int n, int m, int k, double[][] d) {
        int fac1 = (int)d[n - k][k];
        int fac2 = (int)d[n - 2 * k][(n - m) / 2 - k];
        int sign = (int)Math.pow(-1.0, k);
        return sign * fac1 * fac2;
    }

    public static Polynom createRadialPolynom(int n, int m, double[][] d) {
        Polynom result = new Polynom(n);
        for (int s = 0; s <= (n - Math.abs(m)) / 2; ++s) {
            int pos = n - 2 * s;
            result.setCoefficient(pos, ZernikeComputer.computeBinomialFactorial(n, m, s, d));
        }
        return result;
    }
}

