/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.filter.addNoise;

import java.util.Random;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.loops.LoopBuilder;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.RealType;
import org.scijava.common3.MersenneTwisterFast;
import org.scijava.ops.spi.Nullable;

public class NoiseAdders {
    private static final Long defaultSeed = -6066930261531658096L;

    public static <I extends RealType<I>, O extends RealType<O>> void addNoiseInterval(RandomAccessibleInterval<I> input, Double rangeMin, Double rangeMax, Double rangeStdDev, @Nullable Long seed, RandomAccessibleInterval<O> output) {
        if (seed == null) {
            seed = defaultSeed;
        }
        Random rng = new Random(seed);
        LoopBuilder.setImages(input, output).multiThreaded().forEachPixel((in, out) -> NoiseAdders.addNoise(in, out, rangeMin, rangeMax, rangeStdDev, rng));
    }

    public static <I extends RealType<I>, O extends RealType<O>> void addNoise(I input, O output, double rangeMin, double rangeMax, double rangeStdDev, Random rng) {
        int i = 0;
        do {
            double newVal;
            if (!(rangeMin <= (newVal = input.getRealDouble() + rng.nextGaussian() * rangeStdDev)) || !(newVal <= rangeMax)) continue;
            output.setReal(newVal);
            return;
        } while (i++ <= 100);
        throw new IllegalArgumentException("noise function failing to terminate. probably misconfigured.");
    }

    public static <I extends RealType<I>, O extends RealType<O>> void addPoissonNoiseInterval(RandomAccessibleInterval<I> input, @Nullable Long seed, RandomAccessibleInterval<O> output) {
        if (seed == null) {
            seed = defaultSeed;
        }
        Random rng = new Random(seed);
        LoopBuilder.setImages(input, output).multiThreaded().forEachPixel((in, out) -> NoiseAdders.addPoissonNoise(in, rng, out));
    }

    public static <I extends RealType<I>, O extends RealType<O>> void addPoissonNoise(I input, Random rng, O output) {
        double l = Math.exp(-input.getRealDouble());
        int k = 0;
        double p = 1.0;
        do {
            ++k;
        } while ((p *= rng.nextDouble()) >= l);
        output.setReal((float)(k - 1));
    }

    public static <I extends RealType<I>> void addUniformNoise(RandomAccessibleInterval<I> input, I rangeMin, I rangeMax, @Nullable Long seed, RandomAccessibleInterval<I> output) {
        if (seed == null) {
            seed = -6066930261531658096L;
        }
        MersenneTwisterFast rng = new MersenneTwisterFast(seed.longValue());
        RealType range = (RealType)rangeMax.createVariable();
        range.set(rangeMax);
        range.sub(rangeMin);
        LoopBuilder.setImages(input, output).forEachPixel((i, o) -> {
            o.set((Type)range);
            o.mul(rng.nextDouble(true, true));
            o.add((Object)rangeMin);
            o.add(i);
        });
    }
}

