/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.imagemoments.centralmoments;

import java.util.List;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.loops.LoopBuilder;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Intervals;
import org.scijava.function.Computers;
import org.scijava.ops.image.imagemoments.AbstractImageMomentOp;
import org.scijava.ops.spi.OpDependency;

public class DefaultCentralMoment02<I extends RealType<I>, O extends RealType<O>>
implements AbstractImageMomentOp<I, O> {
    @OpDependency(name="imageMoments.moment00")
    private Computers.Arity1<RandomAccessibleInterval<I>, O> moment00Func;
    @OpDependency(name="imageMoments.moment01")
    private Computers.Arity1<RandomAccessibleInterval<I>, O> moment01Func;
    @OpDependency(name="math.power")
    private Computers.Arity2<O, Integer, O> powerOp;

    @Override
    public void computeMoment(RandomAccessibleInterval<I> input, O output) {
        RealType moment00 = (RealType)output.createVariable();
        this.moment00Func.compute(input, (Object)moment00);
        RealType moment01 = (RealType)output.createVariable();
        this.moment01Func.compute(input, (Object)moment01);
        RealType centerY = (RealType)moment01.copy();
        centerY.div((Object)moment00);
        List sums = LoopBuilder.setImages(input, (RandomAccessibleInterval)Intervals.positions(input)).multiThreaded().forEachChunk(chunk -> {
            RealType sum = (RealType)output.createVariable();
            RealType temp = (RealType)output.createVariable();
            RealType y = (RealType)output.createVariable();
            chunk.forEachPixel((pixel, pos) -> {
                temp.setReal(pos.getDoublePosition(1));
                temp.sub((Object)centerY);
                this.powerOp.compute((Object)temp, (Object)2, (Object)y);
                temp.setReal(pixel.getRealDouble());
                temp.mul((Object)y);
                sum.add((Object)temp);
            });
            return sum;
        });
        output.setZero();
        for (RealType sum : sums) {
            output.add((Object)sum);
        }
    }
}

