/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.segment.detectRidges;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.imglib2.Cursor;
import net.imglib2.Dimensions;
import net.imglib2.FinalDimensions;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.view.Views;
import org.scijava.function.Computers;

public class RidgeDetectionMetadata {
    protected Img<DoubleType> pValues;
    protected Img<DoubleType> nValues;
    protected Img<DoubleType> gradients;
    RandomAccessibleInterval<DoubleType> x;
    RandomAccessibleInterval<DoubleType> y;
    RandomAccessibleInterval<DoubleType> xx;
    RandomAccessibleInterval<DoubleType> xy;
    RandomAccessibleInterval<DoubleType> yy;

    public <T extends RealType<T>> RidgeDetectionMetadata(RandomAccessibleInterval<T> input, double sigma, double smallMax, double bigMax, Computers.Arity1<RandomAccessibleInterval<T>, RandomAccessibleInterval<DoubleType>> convertOp, BiFunction<Dimensions, DoubleType, RandomAccessibleInterval<DoubleType>> createOp, Function<RandomAccessibleInterval<DoubleType>, RandomAccessibleInterval<DoubleType>> copyOp, Computers.Arity3<RandomAccessibleInterval<DoubleType>, double[], int[], RandomAccessibleInterval<DoubleType>> partialDerivativeOp) {
        RandomAccessibleInterval<DoubleType> converted = createOp.apply((Dimensions)input, new DoubleType());
        convertOp.compute(input, converted);
        long[] valuesArr = new long[input.numDimensions() + 1];
        for (int d = 0; d < input.numDimensions(); ++d) {
            valuesArr[d] = input.dimension(d);
        }
        valuesArr[valuesArr.length - 1] = 2L;
        this.pValues = (Img)createOp.apply((Dimensions)new FinalDimensions(valuesArr), new DoubleType());
        RandomAccess pRA = this.pValues.randomAccess();
        this.nValues = (Img)createOp.apply((Dimensions)new FinalDimensions(valuesArr), new DoubleType());
        RandomAccess nRA = this.nValues.randomAccess();
        this.gradients = (Img)createOp.apply((Dimensions)input, new DoubleType());
        RandomAccess gradientsRA = this.gradients.randomAccess();
        Cursor cursor = Views.iterable(input).localizingCursor();
        this.x = copyOp.apply(converted);
        RandomAccess xRA = this.x.randomAccess();
        this.y = copyOp.apply(converted);
        RandomAccess yRA = this.y.randomAccess();
        this.xx = copyOp.apply(converted);
        RandomAccess xxRA = this.xx.randomAccess();
        this.xy = copyOp.apply(converted);
        RandomAccess xyRA = this.xy.randomAccess();
        this.yy = copyOp.apply(converted);
        RandomAccess yyRA = this.yy.randomAccess();
        partialDerivativeOp.compute(converted, (Object)new double[]{sigma, sigma}, (Object)new int[]{1, 0}, this.x);
        partialDerivativeOp.compute(converted, (Object)new double[]{sigma, sigma}, (Object)new int[]{2, 0}, this.xx);
        partialDerivativeOp.compute(converted, (Object)new double[]{sigma, sigma}, (Object)new int[]{1, 1}, this.xy);
        partialDerivativeOp.compute(converted, (Object)new double[]{sigma, sigma}, (Object)new int[]{0, 1}, this.y);
        partialDerivativeOp.compute(converted, (Object)new double[]{sigma, sigma}, (Object)new int[]{0, 2}, this.yy);
        while (cursor.hasNext()) {
            cursor.fwd();
            xRA.setPosition((Localizable)cursor);
            yRA.setPosition((Localizable)cursor);
            xxRA.setPosition((Localizable)cursor);
            xyRA.setPosition((Localizable)cursor);
            yyRA.setPosition((Localizable)cursor);
            double rx = ((DoubleType)xRA.get()).getRealDouble();
            double ry = ((DoubleType)yRA.get()).getRealDouble();
            double rxx = ((DoubleType)xxRA.get()).getRealDouble();
            double rxy = ((DoubleType)xyRA.get()).getRealDouble();
            double ryy = ((DoubleType)yyRA.get()).getRealDouble();
            Matrix hessian = new Matrix(input.numDimensions(), input.numDimensions());
            hessian.set(0, 0, ((DoubleType)xxRA.get()).getRealDouble());
            hessian.set(0, 1, ((DoubleType)xyRA.get()).getRealDouble());
            hessian.set(1, 0, ((DoubleType)xyRA.get()).getRealDouble());
            hessian.set(1, 1, ((DoubleType)yyRA.get()).getRealDouble());
            EigenvalueDecomposition e = hessian.eig();
            Matrix eigenvalues = e.getD();
            Matrix eigenvectors = e.getV();
            int index = Math.abs(eigenvalues.get(0, 0)) > Math.abs(eigenvalues.get(1, 1)) ? 0 : 1;
            double nx = eigenvectors.get(0, index);
            double ny = eigenvectors.get(1, index);
            double t = -1.0 * (rx * nx + ry * ny) / (rxx * nx * nx + 2.0 * rxy * nx * ny + ryy * ny * ny);
            double px = t * nx;
            double py = t * ny;
            if (!(Math.abs(px) <= 0.5) || !(Math.abs(py) <= 0.5)) continue;
            valuesArr[0] = cursor.getLongPosition(0);
            valuesArr[1] = cursor.getLongPosition(1);
            valuesArr[2] = 0L;
            pRA.setPosition(valuesArr);
            ((DoubleType)pRA.get()).set(px);
            pRA.fwd(2);
            ((DoubleType)pRA.get()).set(py);
            nRA.setPosition(valuesArr);
            ((DoubleType)nRA.get()).set(nx);
            nRA.fwd(2);
            ((DoubleType)nRA.get()).set(ny);
            double gradient = eigenvalues.get(index, index) < -smallMax ? Math.abs(eigenvalues.get(index, index)) : 0.0;
            gradientsRA.setPosition((Localizable)cursor);
            ((DoubleType)gradientsRA.get()).set(gradient);
        }
    }

    protected Img<DoubleType> getPValues() {
        return this.pValues;
    }

    protected RandomAccess<DoubleType> getPValuesRandomAccess() {
        return this.pValues.randomAccess();
    }

    protected Img<DoubleType> getNValues() {
        return this.nValues;
    }

    protected RandomAccess<DoubleType> getNValuesRandomAccess() {
        return this.nValues.randomAccess();
    }

    protected Img<DoubleType> getGradients() {
        return this.gradients;
    }

    protected RandomAccess<DoubleType> getGradientsRandomAccess() {
        return this.gradients.randomAccess();
    }
}

