/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.stats;

import java.util.List;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.loops.LoopBuilder;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.AbstractRealType;
import net.imglib2.type.numeric.real.DoubleType;
import org.scijava.function.Computers;
import org.scijava.ops.spi.OpDependency;

public class DefaultMomentNAboutMean<I extends RealType<I>, O extends RealType<O>>
implements Computers.Arity2<RandomAccessibleInterval<I>, Integer, O> {
    @OpDependency(name="stats.mean")
    private Computers.Arity1<RandomAccessibleInterval<I>, DoubleType> meanComputer;
    @OpDependency(name="stats.size")
    private Computers.Arity1<RandomAccessibleInterval<I>, DoubleType> sizeComputer;
    @OpDependency(name="math.power")
    private Computers.Arity2<DoubleType, Integer, DoubleType> powOp;

    public void compute(RandomAccessibleInterval<I> input, Integer n, O output) {
        DoubleType mean = new DoubleType();
        this.meanComputer.compute(input, (Object)mean);
        DoubleType size = new DoubleType();
        this.sizeComputer.compute(input, (Object)size);
        List chunkSums = LoopBuilder.setImages(input).multiThreaded().forEachChunk(chunk -> {
            DoubleType chunkSum = new DoubleType(0.0);
            DoubleType difference = new DoubleType();
            DoubleType product = new DoubleType();
            chunk.forEachPixel(pixel -> {
                difference.set(pixel.getRealDouble());
                difference.sub((AbstractRealType)mean);
                this.powOp.compute((Object)difference, (Object)n, (Object)product);
                chunkSum.add((AbstractRealType)product);
            });
            return chunkSum;
        });
        DoubleType sum = new DoubleType(0.0);
        for (DoubleType chunkSum : chunkSums) {
            sum.add((AbstractRealType)chunkSum);
        }
        sum.div((AbstractRealType)size);
        output.setReal(sum.getRealDouble());
    }
}

