/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.stats;

import java.util.List;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.loops.LoopBuilder;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.LongType;
import net.imglib2.type.numeric.real.AbstractRealType;
import net.imglib2.type.numeric.real.DoubleType;
import org.scijava.function.Computers;
import org.scijava.ops.spi.OpDependency;

public class DefaultVariance<I extends RealType<I>, O extends RealType<O>>
implements Computers.Arity1<RandomAccessibleInterval<I>, O> {
    @OpDependency(name="stats.mean")
    private Computers.Arity1<RandomAccessibleInterval<I>, DoubleType> meanOp;
    @OpDependency(name="stats.size")
    private Computers.Arity1<RandomAccessibleInterval<I>, LongType> sizeOp;

    public void compute(RandomAccessibleInterval<I> input, O variance) {
        DoubleType mean = new DoubleType();
        this.meanOp.compute(input, (Object)mean);
        LongType size = new LongType(0L);
        this.sizeOp.compute(input, (Object)size);
        List chunkSums = LoopBuilder.setImages(input).multiThreaded().forEachChunk(chunk -> {
            DoubleType chunkSum = new DoubleType(0.0);
            DoubleType temp = new DoubleType();
            chunk.forEachPixel(pixel -> {
                double x = pixel.getRealDouble();
                temp.set((x - mean.getRealDouble()) * (x - mean.getRealDouble()));
                chunkSum.add((AbstractRealType)temp);
            });
            return chunkSum;
        });
        double sum = chunkSums.parallelStream().mapToDouble(DoubleType::get).sum();
        variance.setReal(sum / (double)(size.get() - 1L));
    }
}

