/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.threshold.localSauvola;

import java.util.Arrays;
import java.util.function.Function;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.neighborhood.RectangleNeighborhood;
import net.imglib2.algorithm.neighborhood.RectangleShape;
import net.imglib2.algorithm.neighborhood.Shape;
import net.imglib2.outofbounds.OutOfBoundsFactory;
import net.imglib2.type.logic.BitType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.view.composite.Composite;
import org.scijava.function.Computers;
import org.scijava.ops.image.threshold.ApplyLocalThresholdIntegral;
import org.scijava.ops.spi.Nullable;
import org.scijava.ops.spi.OpDependency;

public class LocalSauvolaThreshold<T extends RealType<T>>
extends ApplyLocalThresholdIntegral<T, DoubleType>
implements Computers.Arity5<RandomAccessibleInterval<T>, Shape, Double, Double, OutOfBoundsFactory<T, RandomAccessibleInterval<T>>, RandomAccessibleInterval<BitType>> {
    private static final int INTEGRAL_IMAGE_ORDER_1 = 1;
    private static final int INTEGRAL_IMAGE_ORDER_2 = 2;
    @OpDependency(name="threshold.localSauvola")
    private Computers.Arity4<Iterable<T>, T, Double, Double, BitType> computeThresholdNonIntegralOp;
    @OpDependency(name="threshold.localSauvola")
    private Computers.Arity4<RectangleNeighborhood<? extends Composite<DoubleType>>, T, Double, Double, BitType> computeThresholdIntegralOp;
    @OpDependency(name="filter.applyCenterAware")
    private Computers.Arity4<RandomAccessibleInterval<T>, Computers.Arity2<Iterable<T>, T, BitType>, Shape, OutOfBoundsFactory<T, RandomAccessibleInterval<T>>, RandomAccessibleInterval<BitType>> applyFilterOp;

    public void compute(RandomAccessibleInterval<T> input, Shape inputNeighborhoodShape, @Nullable Double k, @Nullable Double r, @Nullable OutOfBoundsFactory<T, RandomAccessibleInterval<T>> outOfBoundsFactory, RandomAccessibleInterval<BitType> output) {
        if (inputNeighborhoodShape instanceof RectangleShape && ((RectangleShape)inputNeighborhoodShape).getSpan() > 2) {
            this.computeIntegral(input, (RectangleShape)inputNeighborhoodShape, k, r, outOfBoundsFactory, this.getIntegralImageOp(1), this.getIntegralImageOp(2), this.computeThresholdIntegralOp, output);
        } else {
            Computers.Arity2 parameterizedComputeThresholdOp = (i1, i2, o) -> this.computeThresholdNonIntegralOp.compute(i1, i2, (Object)k, (Object)r, o);
            this.applyFilterOp.compute(input, (Object)parameterizedComputeThresholdOp, (Object)inputNeighborhoodShape, outOfBoundsFactory, output);
        }
    }

    public void computeIntegral(RandomAccessibleInterval<T> input, RectangleShape inputNeighborhoodShape, Double k, Double r, OutOfBoundsFactory<T, RandomAccessibleInterval<T>> outOfBoundsFactory, Function<RandomAccessibleInterval<T>, RandomAccessibleInterval<DoubleType>> integralImageOp, Function<RandomAccessibleInterval<T>, RandomAccessibleInterval<DoubleType>> squareIntegralImageOp, Computers.Arity4<RectangleNeighborhood<? extends Composite<DoubleType>>, T, Double, Double, BitType> computeThresholdOp, RandomAccessibleInterval<BitType> output) {
        Computers.Arity2 parameterizedComputeThresholdOp = (i1, i2, o) -> computeThresholdOp.compute(i1, i2, (Object)k, (Object)r, o);
        this.compute(input, inputNeighborhoodShape, outOfBoundsFactory, Arrays.asList(integralImageOp, squareIntegralImageOp), parameterizedComputeThresholdOp, output);
    }
}

