/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.threshold.moments;

import net.imglib2.histogram.Histogram1d;
import net.imglib2.type.numeric.RealType;
import org.scijava.ops.image.threshold.AbstractComputeThresholdHistogram;

public class ComputeMomentsThreshold<T extends RealType<T>>
extends AbstractComputeThresholdHistogram<T> {
    @Override
    public long computeBin(Histogram1d<T> hist) {
        long[] histogram = hist.toLongArray();
        return ComputeMomentsThreshold.computeBin(histogram);
    }

    public static long computeBin(long[] histogram) {
        int i;
        double total = 0.0;
        double m0 = 1.0;
        double m1 = 0.0;
        double m2 = 0.0;
        double m3 = 0.0;
        double sum = 0.0;
        double p0 = 0.0;
        int threshold = -1;
        double[] histo = new double[histogram.length];
        for (i = 0; i < histogram.length; ++i) {
            total += (double)histogram[i];
        }
        for (i = 0; i < histogram.length; ++i) {
            histo[i] = (double)histogram[i] / total;
        }
        for (i = 0; i < histogram.length; ++i) {
            m1 += (double)i * histo[i];
            m2 += (double)(i * i) * histo[i];
            m3 += (double)(i * i * i) * histo[i];
        }
        double cd = 1.0 * m2 - m1 * m1;
        double c0 = (-m2 * m2 + m1 * m3) / cd;
        double c1 = (1.0 * -m3 + m2 * m1) / cd;
        double z0 = 0.5 * (-c1 - Math.sqrt(c1 * c1 - 4.0 * c0));
        double z1 = 0.5 * (-c1 + Math.sqrt(c1 * c1 - 4.0 * c0));
        p0 = (z1 - m1) / (z1 - z0);
        sum = 0.0;
        for (i = 0; i < histogram.length; ++i) {
            if (!((sum += histo[i]) > p0)) continue;
            threshold = i;
            break;
        }
        return threshold;
    }
}

