/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.topology;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.imglib2.Interval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.roi.labeling.BoundingBox;
import net.imglib2.stream.LocalizableSpliterator;
import net.imglib2.type.BooleanType;
import net.imglib2.type.numeric.integer.LongType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.util.ValuePair;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;

public final class BoxCount {
    private BoxCount() {
    }

    public static <B extends BooleanType<B>> List<ValuePair<DoubleType, DoubleType>> apply(RandomAccessibleInterval<B> input, Long maxSize, Long minSize, Double scaling, Long gridMoves) {
        if (scaling <= 1.0) {
            throw new IllegalArgumentException("Scaling must be > 1.0 or algorithm won't stop.");
        }
        ArrayList<ValuePair<DoubleType, DoubleType>> points = new ArrayList<ValuePair<DoubleType, DoubleType>>();
        int dimensions = input.numDimensions();
        long[] sizes = new long[dimensions];
        input.dimensions(sizes);
        long sectionSize = maxSize;
        while (sectionSize >= minSize) {
            long numTranslations = BoxCount.limitTranslations(sectionSize, 1L + gridMoves);
            long translationAmount = sectionSize / numTranslations;
            Stream<long[]> translations = BoxCount.translationStream(numTranslations, translationAmount, dimensions - 1, new long[dimensions]);
            LongStream foregroundCounts = BoxCount.countTranslatedGrids(input, translations, sizes, sectionSize);
            long foreground = foregroundCounts.min().orElse(0L);
            double logSize = -Math.log(sectionSize);
            double logCount = Math.log(foreground);
            ValuePair point = new ValuePair((Object)new DoubleType(logSize), (Object)new DoubleType(logCount));
            points.add((ValuePair<DoubleType, DoubleType>)point);
            sectionSize = (long)((double)sectionSize / scaling);
        }
        return points;
    }

    static long limitTranslations(long size, long translations) throws IllegalArgumentException {
        if (size < 1L) {
            throw new IllegalArgumentException("Size must be positive");
        }
        if (translations < 1L) {
            return 1L;
        }
        return Math.min(size, translations);
    }

    private static <B extends BooleanType<B>> LongStream countTranslatedGrids(RandomAccessibleInterval<B> input, Stream<long[]> translations, long[] sizes, long sectionSize) {
        int lastDimension = sizes.length - 1;
        return ((Stream)translations.parallel()).mapToLong(gridOffset -> {
            LongType foreground = new LongType();
            long[] sectionPosition = new long[sizes.length];
            BoxCount.countGrid(input, lastDimension, sizes, gridOffset, sectionPosition, sectionSize, foreground);
            return foreground.get();
        });
    }

    private static <B extends BooleanType<B>> IntervalView<B> sectionView(RandomAccessibleInterval<B> interval, long[] sizes, long[] coordinates, long sectionSize) {
        int n = sizes.length;
        long[] startPosition = IntStream.range(0, n).mapToLong(i -> Math.max(0L, coordinates[i])).toArray();
        long[] endPosition = IntStream.range(0, n).mapToLong(i -> Math.min(sizes[i] - 1L, coordinates[i] + sectionSize - 1L)).toArray();
        boolean badBox = IntStream.range(0, n).anyMatch(d -> startPosition[d] >= sizes[d] || endPosition[d] < 0L || endPosition[d] < startPosition[d]);
        if (badBox) {
            return null;
        }
        BoundingBox box = new BoundingBox(n);
        box.update(startPosition);
        box.update(endPosition);
        return Views.offsetInterval(interval, (Interval)box);
    }

    private static <B extends BooleanType<B>> boolean hasForeground(IntervalView<B> view) {
        LocalizableSpliterator spliterator = view.spliterator();
        return StreamSupport.stream(spliterator, false).anyMatch(BooleanType::get);
    }

    private static <B extends BooleanType<B>> void countGrid(RandomAccessibleInterval<B> interval, int dimension, long[] sizes, long[] translation, long[] sectionPosition, long sectionSize, LongType foreground) {
        int p = 0;
        while ((long)p < sizes[dimension]) {
            sectionPosition[dimension] = translation[dimension] + (long)p;
            if (dimension == 0) {
                IntervalView<B> box = BoxCount.sectionView(interval, sizes, sectionPosition, sectionSize);
                if (box != null && BoxCount.hasForeground(box)) {
                    foreground.inc();
                }
            } else {
                BoxCount.countGrid(interval, dimension - 1, sizes, translation, sectionPosition, sectionSize, foreground);
            }
            p = (int)((long)p + sectionSize);
        }
    }

    private static Stream<long[]> translationStream(long numTranslations, long amount, int dimension, long[] translation) {
        Stream.Builder<long[]> builder = Stream.builder();
        BoxCount.generateTranslations(numTranslations, amount, dimension, translation, builder);
        return builder.build();
    }

    private static void generateTranslations(long numTranslations, long amount, int dimension, long[] translation, Stream.Builder<long[]> builder) {
        int t = 0;
        while ((long)t < numTranslations) {
            translation[dimension] = (long)(-t) * amount;
            if (dimension == 0) {
                builder.add((long[])translation.clone());
            } else {
                BoxCount.generateTranslations(numTranslations, amount, dimension - 1, translation, builder);
            }
            ++t;
        }
    }
}

