/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.transform;

import net.imglib2.EuclideanSpace;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealRandomAccessible;
import net.imglib2.interpolation.InterpolatorFactory;
import net.imglib2.interpolation.randomaccess.LanczosInterpolatorFactory;
import net.imglib2.realtransform.InvertibleRealTransform;
import net.imglib2.realtransform.RealTransformRealRandomAccessible;
import net.imglib2.realtransform.RealViews;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.ExtendedRandomAccessibleInterval;
import net.imglib2.view.RandomAccessibleOnRealRandomAccessible;
import net.imglib2.view.Views;
import org.scijava.function.Functions;
import org.scijava.ops.spi.Nullable;

public class DefaultTransformView<T extends NumericType<T> & RealType<T>>
implements Functions.Arity4<RandomAccessibleInterval<T>, InvertibleRealTransform, Interval, InterpolatorFactory<T, RandomAccessible<T>>, RandomAccessibleInterval<T>> {
    public RandomAccessibleInterval<T> apply(RandomAccessibleInterval<T> input, InvertibleRealTransform transform, @Nullable Interval outputInterval, @Nullable InterpolatorFactory<T, RandomAccessible<T>> interpolator) {
        if (outputInterval == null) {
            outputInterval = new FinalInterval(input);
        }
        if (interpolator == null) {
            interpolator = new LanczosInterpolatorFactory();
        }
        ExtendedRandomAccessibleInterval extended = Views.extendZero(input);
        RealRandomAccessible interpolated = Views.interpolate((EuclideanSpace)extended, (InterpolatorFactory)interpolator);
        RealTransformRealRandomAccessible transformed = RealViews.transformReal((RealRandomAccessible)interpolated, (InvertibleRealTransform)transform);
        RandomAccessibleOnRealRandomAccessible rasterized = Views.raster((RealRandomAccessible)transformed);
        return Views.interval((RandomAccessible)rasterized, (Interval)outputInterval);
    }
}

