/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.pixel_classification.gpu.compute_cache;

import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Intervals;
import sc.fiji.labkit.pixel_classification.gpu.api.GpuApi;
import sc.fiji.labkit.pixel_classification.gpu.api.GpuImage;
import sc.fiji.labkit.pixel_classification.gpu.api.GpuView;
import sc.fiji.labkit.pixel_classification.gpu.api.GpuViews;

public class GpuComputeCache {
    private final Map<Content, CacheEntry> map = new HashMap<Content, CacheEntry>();
    private final GpuApi gpu;
    private final RandomAccessible<FloatType> original;
    private final double[] pixelSize;

    public GpuComputeCache(GpuApi gpu, RandomAccessible<FloatType> original, double[] pixelSize) {
        this.gpu = gpu;
        this.original = original;
        this.pixelSize = pixelSize;
    }

    public void request(Content content, Interval interval) {
        CacheEntry cacheEntry = this.map.computeIfAbsent(content, key -> new CacheEntry(content));
        cacheEntry.request(interval);
    }

    public GpuApi gpuApi() {
        return this.gpu;
    }

    public RandomAccessible<FloatType> original() {
        return this.original;
    }

    public double[] pixelSize() {
        return this.pixelSize;
    }

    public GpuView get(Content content, Interval interval) {
        CacheEntry cacheEntry = this.map.get(content);
        if (cacheEntry == null) {
            throw new NoSuchElementException("Content was never requested: " + content);
        }
        return cacheEntry.get(interval);
    }

    class CacheEntry {
        private final Content content;
        private Interval requestedInterval = null;
        private GpuImage buffer = null;

        public CacheEntry(Content content) {
            this.content = content;
        }

        public void request(Interval interval) {
            if (this.buffer != null) {
                throw new IllegalStateException("Image was already used, prefetch isn't allowed anymore.");
            }
            if (this.requestedInterval == null) {
                this.requestedInterval = interval;
            } else {
                if (Intervals.contains((Interval)this.requestedInterval, (Interval)interval)) {
                    return;
                }
                this.requestedInterval = Intervals.union((Interval)this.requestedInterval, (Interval)interval);
            }
            this.content.request(this.requestedInterval);
        }

        public GpuView get(Interval interval) {
            if (this.requestedInterval == null || !Intervals.contains((Interval)this.requestedInterval, (Interval)interval)) {
                throw new AssertionError((Object)"Interval was not prefetched.");
            }
            if (this.buffer == null) {
                this.buffer = this.content.load(this.requestedInterval);
            }
            FinalInterval roi = Intervals.translateInverse((Interval)interval, (long[])Intervals.minAsLongArray((Interval)this.requestedInterval));
            return GpuViews.crop(this.buffer, (Interval)roi);
        }
    }

    public static interface Content {
        public void request(Interval var1);

        public GpuImage load(Interval var1);
    }
}

