/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d;

import java.awt.Font;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.scijava.java3d.BoundingBox;
import org.scijava.java3d.FontExtrusion;
import org.scijava.java3d.GeometryArray;
import org.scijava.java3d.GeometryArrayRetained;
import org.scijava.java3d.GeometryService;
import org.scijava.java3d.NodeComponent;
import org.scijava.java3d.TriangleArray;
import org.scijava.java3d.TriangleArrayRetained;
import org.scijava.java3d.UnorderList;
import org.scijava.vecmath.Point3d;
import org.scijava.vecmath.Point3f;
import org.scijava.vecmath.Tuple3f;
import org.scijava.vecmath.Vector3f;

public class Font3D
extends NodeComponent {
    Font font;
    double tessellationTolerance;
    FontExtrusion fontExtrusion;
    FontRenderContext frc;
    static final float EPS = 1.0E-6f;
    Hashtable<Character, GeometryArrayRetained> geomHash = new Hashtable(20);

    public Font3D(Font font, FontExtrusion extrudePath) {
        this(font, 0.01, extrudePath);
    }

    public Font3D(Font font, double tessellationTolerance, FontExtrusion extrudePath) {
        this.font = font;
        this.tessellationTolerance = tessellationTolerance;
        this.fontExtrusion = extrudePath;
        this.frc = new FontRenderContext(new AffineTransform(), true, true);
    }

    public Font getFont() {
        return this.font;
    }

    public double getTessellationTolerance() {
        return this.tessellationTolerance;
    }

    public void getFontExtrusion(FontExtrusion extrudePath) {
        extrudePath = this.fontExtrusion;
    }

    public void getBoundingBox(int glyphCode, BoundingBox bounds) {
        int[] gCodes = new int[]{glyphCode};
        GlyphVector gVec = this.font.createGlyphVector(this.frc, gCodes);
        Rectangle2D.Float bounds2d = (Rectangle2D.Float)gVec.getGlyphMetrics(0).getBounds2D();
        Point3d lower = new Point3d((double)bounds2d.x, (double)bounds2d.y, 0.0);
        Point3d upper = this.fontExtrusion != null ? new Point3d((double)(bounds2d.x + bounds2d.width), (double)(bounds2d.y + bounds2d.height), (double)this.fontExtrusion.length) : new Point3d((double)(bounds2d.x + bounds2d.width), (double)(bounds2d.y + bounds2d.height), 0.0);
        bounds.setLower(lower);
        bounds.setUpper(upper);
    }

    public GeometryArray getGlyphGeometry(char c) {
        char[] code = new char[]{c};
        GlyphVector gv = this.font.createGlyphVector(this.frc, code);
        GeometryArrayRetained glyph_gar = this.triangulateGlyphs(gv, code[0]);
        assert (glyph_gar instanceof TriangleArrayRetained) : "Font3D: GeometryArray is not an instance of TrangleArray";
        assert (glyph_gar.getVertexFormat() == 3) : "Font3D: Illegal GeometryArray format -- only coordinates and normals expected";
        TriangleArray ga = new TriangleArray(glyph_gar.getVertexCount(), glyph_gar.getVertexFormat());
        float[] tmp = new float[3];
        int vertexCount = ga.getVertexCount();
        for (int i = 0; i < vertexCount; ++i) {
            glyph_gar.getCoordinate(i, tmp);
            ga.setCoordinate(i, tmp);
            glyph_gar.getNormal(i, tmp);
            ga.setNormal(i, tmp);
        }
        return ga;
    }

    GeometryArrayRetained triangulateGlyphs(GlyphVector gv, char c) {
        GeometryArrayRetained geo;
        block84: {
            int k;
            int j;
            int i;
            Character ch = new Character(c);
            geo = this.geomHash.get(ch);
            if (geo != null) break block84;
            Rectangle2D bnd = gv.getVisualBounds();
            AffineTransform aTran = new AffineTransform();
            double tx = bnd.getX() + 0.5 * bnd.getWidth();
            double ty = bnd.getY() + 0.5 * bnd.getHeight();
            aTran.setToTranslation(-tx, -ty);
            aTran.scale(1.0, -1.0);
            aTran.translate(tx, -ty);
            Shape shape = gv.getOutline();
            PathIterator pIt = shape.getPathIterator(aTran, this.tessellationTolerance);
            int flag = -1;
            int numPoints = 0;
            int num = 0;
            UnorderList coords = new UnorderList(100, Point3f.class);
            float[] tmpCoords = new float[6];
            float lastX = 0.0f;
            float lastY = 0.0f;
            float firstPntx = Float.MAX_VALUE;
            float firstPnty = Float.MAX_VALUE;
            IntVector contours = new IntVector();
            float maxY = -3.4028235E38f;
            int maxYIndex = 0;
            int beginIdx = 0;
            int endIdx = 0;
            int start = 0;
            boolean setMaxY = false;
            while (!pIt.isDone()) {
                Point3f vertex = new Point3f();
                flag = pIt.currentSegment(tmpCoords);
                if (flag == 4) {
                    if (num > 0) {
                        if (setMaxY) {
                            beginIdx = start;
                            endIdx = numPoints - 1;
                        }
                        contours.add(num);
                        num = 0;
                    }
                } else if (flag == 0) {
                    vertex.x = tmpCoords[0];
                    vertex.y = tmpCoords[1];
                    lastX = vertex.x;
                    lastY = vertex.y;
                    if (lastX == firstPntx && lastY == firstPnty) {
                        pIt.next();
                        continue;
                    }
                    setMaxY = false;
                    coords.add(vertex);
                    firstPntx = lastX;
                    firstPnty = lastY;
                    if (num > 0) {
                        contours.add(num);
                        num = 0;
                    }
                    ++num;
                    start = ++numPoints;
                } else if (flag == 1) {
                    vertex.x = tmpCoords[0];
                    vertex.y = tmpCoords[1];
                    if (vertex.x == lastX && vertex.y == lastY) {
                        pIt.next();
                        continue;
                    }
                    if (vertex.y > maxY) {
                        maxY = vertex.y;
                        maxYIndex = numPoints;
                        setMaxY = true;
                    }
                    lastX = vertex.x;
                    lastY = vertex.y;
                    coords.add(vertex);
                    ++num;
                    ++numPoints;
                }
                pIt.next();
            }
            if (numPoints == 0) {
                return null;
            }
            Point3f p1 = new Point3f();
            Point3f p2 = new Point3f();
            Point3f p3 = new Point3f();
            boolean flip_side_orient = true;
            Point3f[] vertices = (Point3f[])coords.toArray(false);
            if (endIdx - beginIdx > 0) {
                if (maxYIndex == beginIdx) {
                    p1.set((Tuple3f)vertices[endIdx]);
                } else {
                    p1.set((Tuple3f)vertices[maxYIndex - 1]);
                }
                p2.set((Tuple3f)vertices[maxYIndex]);
                if (maxYIndex == endIdx) {
                    p3.set((Tuple3f)vertices[beginIdx]);
                } else {
                    p3.set((Tuple3f)vertices[maxYIndex + 1]);
                }
                flip_side_orient = p3.x != p2.x ? (p1.x != p2.x ? (Math.abs((p2.y - p1.y) / (p2.x - p1.x)) > Math.abs((p3.y - p2.y) / (p3.x - p2.x)) ? p3.x > p2.x : p2.x > p1.x) : p3.x > p2.x) : p2.x > p1.x;
            }
            int startIdx = 0;
            IslandsNode islandsTree = new IslandsNode(-1, -1);
            for (int cIdx = 0; cIdx < contours.size; ++cIdx) {
                endIdx = startIdx + contours.data[cIdx];
                islandsTree.insert(new IslandsNode(startIdx, endIdx), vertices);
                startIdx = endIdx;
            }
            coords = null;
            contours = null;
            UnorderList islandsList = new UnorderList(10, IslandsNode.class);
            islandsTree.collectOddLevelNode(islandsList, 0);
            IslandsNode[] nodes = (IslandsNode[])islandsList.toArray(false);
            int[][] islandCounts = new int[islandsList.arraySize()][];
            Point3f[][] outVerts = new Point3f[islandCounts.length][];
            for (i = 0; i < islandCounts.length; ++i) {
                IslandsNode node = nodes[i];
                int nchild = node.numChild();
                islandCounts[i] = new int[nchild + 1];
                islandCounts[i][0] = node.numVertices();
                int sum = 0;
                sum += islandCounts[i][0];
                for (j = 0; j < nchild; ++j) {
                    islandCounts[i][j + 1] = node.getChild(j).numVertices();
                    sum += islandCounts[i][j + 1];
                }
                outVerts[i] = new Point3f[sum];
                startIdx = 0;
                for (k = node.startIdx; k < node.endIdx; ++k) {
                    outVerts[i][startIdx++] = vertices[k];
                }
                for (j = 0; j < nchild; ++j) {
                    endIdx = node.getChild((int)j).endIdx;
                    for (k = node.getChild((int)j).startIdx; k < endIdx; ++k) {
                        outVerts[i][startIdx++] = vertices[k];
                    }
                }
            }
            islandsTree = null;
            islandsList = null;
            vertices = null;
            int[] contourCounts = new int[1];
            ArrayList<GeometryArray> triangData = new ArrayList<GeometryArray>();
            Point3f q1 = new Point3f();
            Point3f q2 = new Point3f();
            Point3f q3 = new Point3f();
            Vector3f n1 = new Vector3f();
            Vector3f n2 = new Vector3f();
            numPoints = 0;
            for (i = 0; i < islandCounts.length; ++i) {
                numPoints += outVerts[i].length;
            }
            GeometryService gs = this.newGeometryService();
            int vertOffset = gs.triangulateIslands(islandCounts, outVerts, contourCounts, triangData);
            int vertCnt = this.fontExtrusion == null ? vertOffset : (this.fontExtrusion.shape == null ? vertOffset * 2 + numPoints * 6 : vertOffset * 2 + numPoints * 6 * (this.fontExtrusion.pnts.length - 1));
            TriangleArray triAry = new TriangleArray(vertCnt, 3);
            boolean[] flip_orient = new boolean[islandCounts.length];
            Vector3f goodNormal = new Vector3f();
            int currCoordIndex = 0;
            for (j = 0; j < islandCounts.length; ++j) {
                GeometryArray ga = triangData.get(j);
                vertOffset = ga.getVertexCount();
                boolean findOrient = false;
                i = 0;
                while (i < vertOffset) {
                    block86: {
                        block85: {
                            block88: {
                                block87: {
                                    ga.getCoordinate(i, p1);
                                    ga.getNormal(i, n1);
                                    ga.getCoordinate(i + 1, p2);
                                    ga.getCoordinate(i + 2, p3);
                                    if (findOrient) break block85;
                                    if (!Font3D.getNormal(p1, p2, p3, n2)) break block86;
                                    if (!(n2.z >= 1.0E-6f)) break block87;
                                    flip_orient[j] = false;
                                    break block88;
                                }
                                if (!(n2.z <= -1.0E-6f)) break block86;
                                flip_orient[j] = true;
                            }
                            findOrient = true;
                        }
                        if (flip_orient[j]) {
                            q1.x = p2.x;
                            q1.y = p2.y;
                            q1.z = p2.z;
                            p2.x = p3.x;
                            p2.y = p3.y;
                            p2.z = p3.z;
                            p3.x = q1.x;
                            p3.y = q1.y;
                            p3.z = q1.z;
                            n1.x = -n1.x;
                            n1.y = -n1.y;
                            n1.z = -n1.z;
                        }
                        if (this.fontExtrusion != null) {
                            n2.x = -n1.x;
                            n2.y = -n1.y;
                            n2.z = -n1.z;
                            triAry.setCoordinate(currCoordIndex, p1);
                            triAry.setNormal(currCoordIndex, n2);
                            triAry.setCoordinate(currCoordIndex + 1, p3);
                            triAry.setNormal(currCoordIndex + 1, n2);
                            triAry.setCoordinate(currCoordIndex + 2, p2);
                            triAry.setNormal(currCoordIndex + 2, n2);
                            q1.x = p1.x;
                            q1.y = p1.y;
                            q1.z = p1.z + this.fontExtrusion.length;
                            q2.x = p2.x;
                            q2.y = p2.y;
                            q2.z = p2.z + this.fontExtrusion.length;
                            q3.x = p3.x;
                            q3.y = p3.y;
                            q3.z = p3.z + this.fontExtrusion.length;
                            triAry.setCoordinate(currCoordIndex + vertOffset, q1);
                            triAry.setNormal(currCoordIndex + vertOffset, n1);
                            triAry.setCoordinate(currCoordIndex + 1 + vertOffset, q2);
                            triAry.setNormal(currCoordIndex + 1 + vertOffset, n1);
                            triAry.setCoordinate(currCoordIndex + 2 + vertOffset, q3);
                            triAry.setNormal(currCoordIndex + 2 + vertOffset, n1);
                        } else {
                            triAry.setCoordinate(currCoordIndex, p1);
                            triAry.setNormal(currCoordIndex, n1);
                            triAry.setCoordinate(currCoordIndex + 1, p2);
                            triAry.setNormal(currCoordIndex + 1, n1);
                            triAry.setCoordinate(currCoordIndex + 2, p3);
                            triAry.setNormal(currCoordIndex + 2, n1);
                        }
                    }
                    i += 3;
                    currCoordIndex += 3;
                }
                if (this.fontExtrusion == null) continue;
                currCoordIndex += vertOffset;
            }
            if (this.fontExtrusion != null) {
                if (this.fontExtrusion.shape == null) {
                    float threshold = (float)Math.cos(0.767944870877505);
                    Vector3f pn1 = null;
                    Vector3f pn2 = null;
                    Vector3f n3 = new Vector3f();
                    Vector3f n4 = new Vector3f();
                    Vector3f p1Normal = new Vector3f();
                    Vector3f p2Normal = new Vector3f();
                    Vector3f p3Normal = new Vector3f();
                    Vector3f q1Normal = new Vector3f();
                    Vector3f q2Normal = new Vector3f();
                    Vector3f q3Normal = new Vector3f();
                    for (i = 0; i < islandCounts.length; ++i) {
                        k = 0;
                        num = 0;
                        for (j = 0; j < islandCounts[i].length; ++j) {
                            p1.x = outVerts[i][(num += islandCounts[i][j]) - 1].x;
                            p1.y = outVerts[i][num - 1].y;
                            p1.z = 0.0f;
                            q1.x = p1.x;
                            q1.y = p1.y;
                            q1.z = p1.z + this.fontExtrusion.length;
                            p2.z = 0.0f;
                            q2.z = p2.z + this.fontExtrusion.length;
                            for (int m = 0; m < num; ++m) {
                                p2.x = outVerts[i][m].x;
                                p2.y = outVerts[i][m].y;
                                q2.x = p2.x;
                                q2.y = p2.y;
                                if (!Font3D.getNormal(p1, q1, p2, n1)) continue;
                                if (!flip_side_orient) {
                                    n1.negate();
                                }
                                goodNormal.set((Tuple3f)n1);
                                break;
                            }
                            while (k < num) {
                                boolean smooth;
                                float cosine;
                                p2.x = outVerts[i][k].x;
                                p2.y = outVerts[i][k].y;
                                p2.z = 0.0f;
                                q2.x = p2.x;
                                q2.y = p2.y;
                                q2.z = p2.z + this.fontExtrusion.length;
                                if (!Font3D.getNormal(p1, q1, p2, n1)) {
                                    n1.set((Tuple3f)goodNormal);
                                } else {
                                    if (!flip_side_orient) {
                                        n1.negate();
                                    }
                                    goodNormal.set((Tuple3f)n1);
                                }
                                if (!Font3D.getNormal(p2, q1, q2, n2)) {
                                    n2.set((Tuple3f)goodNormal);
                                } else {
                                    if (!flip_side_orient) {
                                        n2.negate();
                                    }
                                    goodNormal.set((Tuple3f)n2);
                                }
                                if (pn1 != null) {
                                    cosine = n1.dot(pn2);
                                    boolean bl = smooth = cosine > threshold;
                                    if (smooth) {
                                        p1Normal.x = pn1.x + pn2.x + n1.x;
                                        p1Normal.y = pn1.y + pn2.y + n1.y;
                                        p1Normal.z = pn1.z + pn2.z + n1.z;
                                        Font3D.normalize(p1Normal);
                                        q1Normal.x = pn2.x + n1.x + n2.x;
                                        q1Normal.y = pn2.y + n1.y + n2.y;
                                        q1Normal.z = pn2.z + n1.z + n2.z;
                                        Font3D.normalize(q1Normal);
                                    } else {
                                        p1Normal.x = n1.x;
                                        p1Normal.y = n1.y;
                                        p1Normal.z = n1.z;
                                        q1Normal.x = n1.x + n2.x;
                                        q1Normal.y = n1.y + n2.y;
                                        q1Normal.z = n1.z + n2.z;
                                        Font3D.normalize(q1Normal);
                                    }
                                } else {
                                    pn1 = new Vector3f();
                                    pn2 = new Vector3f();
                                    p1Normal.x = n1.x;
                                    p1Normal.y = n1.y;
                                    p1Normal.z = n1.z;
                                    q1Normal.x = n1.x + n2.x;
                                    q1Normal.y = n1.y + n2.y;
                                    q1Normal.z = n1.z + n2.z;
                                    Font3D.normalize(q1Normal);
                                }
                                if (k + 1 < num) {
                                    p3.x = outVerts[i][k + 1].x;
                                    p3.y = outVerts[i][k + 1].y;
                                    p3.z = 0.0f;
                                    q3.x = p3.x;
                                    q3.y = p3.y;
                                    q3.z = p3.z + this.fontExtrusion.length;
                                    if (!Font3D.getNormal(p2, q2, p3, n3)) {
                                        n3.set((Tuple3f)goodNormal);
                                    } else {
                                        if (!flip_side_orient) {
                                            n3.negate();
                                        }
                                        goodNormal.set((Tuple3f)n3);
                                    }
                                    if (!Font3D.getNormal(p3, q2, q3, n4)) {
                                        n4.set((Tuple3f)goodNormal);
                                    } else {
                                        if (!flip_side_orient) {
                                            n4.negate();
                                        }
                                        goodNormal.set((Tuple3f)n4);
                                    }
                                    cosine = n2.dot(n3);
                                    boolean bl = smooth = cosine > threshold;
                                    if (smooth) {
                                        p2Normal.x = n1.x + n2.x + n3.x;
                                        p2Normal.y = n1.y + n2.y + n3.y;
                                        p2Normal.z = n1.z + n2.z + n3.z;
                                        Font3D.normalize(p2Normal);
                                        q2Normal.x = n2.x + n3.x + n4.x;
                                        q2Normal.y = n2.y + n3.y + n4.y;
                                        q2Normal.z = n2.z + n3.z + n4.z;
                                        Font3D.normalize(q2Normal);
                                    } else {
                                        p2Normal.x = n1.x + n2.x;
                                        p2Normal.y = n1.y + n2.y;
                                        p2Normal.z = n1.z + n2.z;
                                        Font3D.normalize(p2Normal);
                                        q2Normal.x = n2.x;
                                        q2Normal.y = n2.y;
                                        q2Normal.z = n2.z;
                                    }
                                } else {
                                    p2Normal.x = n1.x + n2.x;
                                    p2Normal.y = n1.y + n2.y;
                                    p2Normal.z = n1.z + n2.z;
                                    Font3D.normalize(p2Normal);
                                    q2Normal.x = n2.x;
                                    q2Normal.y = n2.y;
                                    q2Normal.z = n2.z;
                                }
                                if (flip_side_orient) {
                                    triAry.setCoordinate(currCoordIndex, p1);
                                    triAry.setNormal(currCoordIndex, p1Normal);
                                    triAry.setCoordinate(++currCoordIndex, q1);
                                    triAry.setNormal(currCoordIndex, q1Normal);
                                    triAry.setCoordinate(++currCoordIndex, p2);
                                    triAry.setNormal(currCoordIndex, p2Normal);
                                    triAry.setCoordinate(++currCoordIndex, p2);
                                    triAry.setNormal(currCoordIndex, p2Normal);
                                    triAry.setCoordinate(++currCoordIndex, q1);
                                    triAry.setNormal(currCoordIndex, q1Normal);
                                    ++currCoordIndex;
                                } else {
                                    triAry.setCoordinate(currCoordIndex, q1);
                                    triAry.setNormal(currCoordIndex, q1Normal);
                                    triAry.setCoordinate(++currCoordIndex, p1);
                                    triAry.setNormal(currCoordIndex, p1Normal);
                                    triAry.setCoordinate(++currCoordIndex, p2);
                                    triAry.setNormal(currCoordIndex, p2Normal);
                                    triAry.setCoordinate(++currCoordIndex, q1);
                                    triAry.setNormal(currCoordIndex, q1Normal);
                                    triAry.setCoordinate(++currCoordIndex, p2);
                                    triAry.setNormal(currCoordIndex, p2Normal);
                                    ++currCoordIndex;
                                }
                                triAry.setCoordinate(currCoordIndex, q2);
                                triAry.setNormal(currCoordIndex, q2Normal);
                                ++currCoordIndex;
                                pn1.x = n1.x;
                                pn1.y = n1.y;
                                pn1.z = n1.z;
                                pn2.x = n2.x;
                                pn2.y = n2.y;
                                pn2.z = n2.z;
                                p1.x = p2.x;
                                p1.y = p2.y;
                                p1.z = p2.z;
                                q1.x = q2.x;
                                q1.y = q2.y;
                                q1.z = q2.z;
                                ++k;
                            }
                            pn1 = null;
                            pn2 = null;
                        }
                    }
                } else {
                    int offset = 0;
                    Point3f P2 = new Point3f();
                    Point3f Q2 = new Point3f();
                    Point3f P1 = new Point3f();
                    Vector3f nn = new Vector3f();
                    Vector3f nn1 = new Vector3f();
                    Vector3f nn2 = new Vector3f();
                    Vector3f nn3 = new Vector3f();
                    Vector3f nna = new Vector3f();
                    Vector3f nnb = new Vector3f();
                    boolean validNormal = false;
                    for (i = 0; i < islandCounts.length; ++i) {
                        k = 0;
                        num = 0;
                        offset = 0;
                        for (j = 0; j < islandCounts[i].length; ++j) {
                            int m;
                            p1.x = outVerts[i][(num += islandCounts[i][j]) - 1].x;
                            p1.y = outVerts[i][num - 1].y;
                            p1.z = 0.0f;
                            q1.x = p1.x;
                            q1.y = p1.y;
                            q1.z = p1.z + this.fontExtrusion.length;
                            p3.z = 0.0f;
                            for (m = num - 2; m >= 0; --m) {
                                p3.x = outVerts[i][m].x;
                                p3.y = outVerts[i][m].y;
                                if (!Font3D.getNormal(p3, q1, p1, nn1)) continue;
                                if (!flip_side_orient) {
                                    nn1.negate();
                                }
                                goodNormal.set((Tuple3f)nn1);
                                break;
                            }
                            while (k < num) {
                                p2.x = outVerts[i][k].x;
                                p2.y = outVerts[i][k].y;
                                p2.z = 0.0f;
                                q2.x = p2.x;
                                q2.y = p2.y;
                                q2.z = p2.z + this.fontExtrusion.length;
                                Font3D.getNormal(p1, q1, p2, nn2);
                                p3.x = outVerts[i][k + 1 == num ? offset : k + 1].x;
                                p3.y = outVerts[i][k + 1 == num ? offset : k + 1].y;
                                p3.z = 0.0f;
                                if (!Font3D.getNormal(p3, p2, q2, nn3)) {
                                    nn3.set((Tuple3f)goodNormal);
                                } else {
                                    if (!flip_side_orient) {
                                        nn3.negate();
                                    }
                                    goodNormal.set((Tuple3f)nn3);
                                }
                                nna.x = nn1.x + nn2.x;
                                nna.y = nn1.y + nn2.y;
                                nna.z = nn1.z + nn2.z;
                                Font3D.normalize(nna);
                                nnb.x = nn3.x + nn2.x;
                                nnb.y = nn3.y + nn2.y;
                                nnb.z = nn3.z + nn2.z;
                                Font3D.normalize(nnb);
                                P1.x = p1.x;
                                P1.y = p1.y;
                                P1.z = p1.z;
                                P2.x = p2.x;
                                P2.y = p2.y;
                                P2.z = p2.z;
                                Q2.x = q2.x;
                                Q2.y = q2.y;
                                Q2.z = q2.z;
                                for (m = 1; m < this.fontExtrusion.pnts.length; ++m) {
                                    q1.z = q2.z = this.fontExtrusion.pnts[m].x;
                                    q1.x = P1.x + nna.x * this.fontExtrusion.pnts[m].y;
                                    q1.y = P1.y + nna.y * this.fontExtrusion.pnts[m].y;
                                    q2.x = P2.x + nnb.x * this.fontExtrusion.pnts[m].y;
                                    q2.y = P2.y + nnb.y * this.fontExtrusion.pnts[m].y;
                                    if (!Font3D.getNormal(p1, q1, p2, n1)) {
                                        n1.set((Tuple3f)goodNormal);
                                    } else {
                                        if (!flip_side_orient) {
                                            n1.negate();
                                        }
                                        goodNormal.set((Tuple3f)n1);
                                    }
                                    if (flip_side_orient) {
                                        triAry.setCoordinate(currCoordIndex, p1);
                                        triAry.setNormal(currCoordIndex, n1);
                                        triAry.setCoordinate(++currCoordIndex, q1);
                                        triAry.setNormal(currCoordIndex, n1);
                                        ++currCoordIndex;
                                    } else {
                                        triAry.setCoordinate(currCoordIndex, q1);
                                        triAry.setNormal(currCoordIndex, n1);
                                        triAry.setCoordinate(++currCoordIndex, p1);
                                        triAry.setNormal(currCoordIndex, n1);
                                        ++currCoordIndex;
                                    }
                                    triAry.setCoordinate(currCoordIndex, p2);
                                    triAry.setNormal(currCoordIndex, n1);
                                    ++currCoordIndex;
                                    if (!Font3D.getNormal(p2, q1, q2, n1)) {
                                        n1.set((Tuple3f)goodNormal);
                                    } else {
                                        if (!flip_side_orient) {
                                            n1.negate();
                                        }
                                        goodNormal.set((Tuple3f)n1);
                                    }
                                    if (flip_side_orient) {
                                        triAry.setCoordinate(currCoordIndex, p2);
                                        triAry.setNormal(currCoordIndex, n1);
                                        triAry.setCoordinate(++currCoordIndex, q1);
                                        triAry.setNormal(currCoordIndex, n1);
                                        ++currCoordIndex;
                                    } else {
                                        triAry.setCoordinate(currCoordIndex, q1);
                                        triAry.setNormal(currCoordIndex, n1);
                                        triAry.setCoordinate(++currCoordIndex, p2);
                                        triAry.setNormal(currCoordIndex, n1);
                                        ++currCoordIndex;
                                    }
                                    triAry.setCoordinate(currCoordIndex, q2);
                                    triAry.setNormal(currCoordIndex, n1);
                                    ++currCoordIndex;
                                    p1.x = q1.x;
                                    p1.y = q1.y;
                                    p1.z = q1.z;
                                    p2.x = q2.x;
                                    p2.y = q2.y;
                                    p2.z = q2.z;
                                }
                                p1.x = P2.x;
                                p1.y = P2.y;
                                p1.z = P2.z;
                                q1.x = Q2.x;
                                q1.y = Q2.y;
                                q1.z = Q2.z;
                                nn1.x = nn2.x;
                                nn1.y = nn2.y;
                                nn1.z = nn2.z;
                                ++k;
                            }
                            offset = num;
                        }
                    }
                }
            }
            geo = (GeometryArrayRetained)triAry.retained;
            this.geomHash.put(ch, geo);
        }
        return geo;
    }

    private GeometryService newGeometryService() {
        ServiceLoader<GeometryService> gsLoader = ServiceLoader.load(GeometryService.class);
        Iterator<GeometryService> iter = gsLoader.iterator();
        if (iter.hasNext()) {
            return iter.next();
        }
        throw new IllegalStateException("No GeometryService implementation found. Please add j3d-core-utils to the classpath.");
    }

    static boolean getNormal(Point3f p1, Point3f p2, Point3f p3, Vector3f normal) {
        Vector3f v1 = new Vector3f();
        Vector3f v2 = new Vector3f();
        v1.sub((Tuple3f)p2, (Tuple3f)p1);
        v2.sub((Tuple3f)p2, (Tuple3f)p3);
        normal.cross(v1, v2);
        normal.negate();
        float length = normal.length();
        if (length > 0.0f) {
            length = 1.0f / length;
            normal.x *= length;
            normal.y *= length;
            normal.z *= length;
            return true;
        }
        return false;
    }

    static int check2Contours(int begin1, int end1, int begin2, int end2, Point3f[] vertices) {
        int i;
        boolean inside2 = Font3D.pointInPolygon2D(vertices[begin1].x, vertices[begin1].y, begin2, end2, vertices);
        for (i = begin1 + 1; i < end1; ++i) {
            if (Font3D.pointInPolygon2D(vertices[i].x, vertices[i].y, begin2, end2, vertices) == inside2) continue;
            return 1;
        }
        boolean inside1 = Font3D.pointInPolygon2D(vertices[begin2].x, vertices[begin2].y, begin1, end1, vertices);
        for (i = begin2 + 1; i < end2; ++i) {
            if (Font3D.pointInPolygon2D(vertices[i].x, vertices[i].y, begin1, end1, vertices) == inside1) continue;
            return 1;
        }
        if (!inside2) {
            if (!inside1) {
                return 0;
            }
            return 3;
        }
        return 2;
    }

    static boolean pointInPolygon2D(float x, float y, int begIdx, int endIdx, Point3f[] verts) {
        float xi;
        int i;
        int num_intersections = 0;
        for (i = begIdx; i < endIdx - 1; ++i) {
            if (verts[i].y >= y && verts[i + 1].y >= y || verts[i].y < y && verts[i + 1].y < y || !(x < (xi = verts[i].x + (verts[i].x - verts[i + 1].x) * (y - verts[i].y) / (verts[i].y - verts[i + 1].y)))) continue;
            ++num_intersections;
        }
        if (!(verts[i].y >= y && verts[begIdx].y >= y || verts[i].y < y && verts[begIdx].y < y || !(x < (xi = verts[i].x + (verts[i].x - verts[begIdx].x) * (y - verts[i].y) / (verts[i].y - verts[begIdx].y))))) {
            ++num_intersections;
        }
        return num_intersections % 2 != 0;
    }

    static final boolean normalize(Vector3f v) {
        float len = v.length();
        if (len > 0.0f) {
            len = 1.0f / len;
            v.x *= len;
            v.y *= len;
            v.z *= len;
            return true;
        }
        return false;
    }

    private static class IslandsNode {
        private ArrayList<IslandsNode> islandsList = null;
        int startIdx;
        int endIdx;

        IslandsNode(int startIdx, int endIdx) {
            this.startIdx = startIdx;
            this.endIdx = endIdx;
            this.islandsList = null;
        }

        void addChild(IslandsNode node) {
            if (this.islandsList == null) {
                this.islandsList = new ArrayList(5);
            }
            this.islandsList.add(node);
        }

        void removeChild(IslandsNode node) {
            this.islandsList.remove(this.islandsList.indexOf(node));
        }

        IslandsNode getChild(int idx) {
            return this.islandsList.get(idx);
        }

        int numChild() {
            return this.islandsList == null ? 0 : this.islandsList.size();
        }

        int numVertices() {
            return this.endIdx - this.startIdx;
        }

        void insert(IslandsNode newNode, Point3f[] vertices) {
            boolean createNewLevel = false;
            if (this.islandsList != null) {
                block4: for (int i = this.numChild() - 1; i >= 0; --i) {
                    IslandsNode childNode = this.getChild(i);
                    int status = Font3D.check2Contours(newNode.startIdx, newNode.endIdx, childNode.startIdx, childNode.endIdx, vertices);
                    switch (status) {
                        case 2: {
                            childNode.insert(newNode, vertices);
                            return;
                        }
                        case 3: {
                            newNode.addChild(childNode);
                            createNewLevel = true;
                            continue block4;
                        }
                    }
                }
            }
            if (createNewLevel) {
                for (int i = newNode.numChild() - 1; i >= 0; --i) {
                    this.removeChild(newNode.getChild(i));
                }
            }
            this.addChild(newNode);
        }

        void collectOddLevelNode(UnorderList list, int level) {
            if (level % 2 == 1) {
                list.add(this);
            }
            if (this.islandsList != null) {
                ++level;
                for (int i = this.numChild() - 1; i >= 0; --i) {
                    this.getChild(i).collectOddLevelNode(list, level);
                }
            }
        }
    }

    private static class IntVector {
        int[] data = new int[10];
        int size = 0;

        IntVector() {
        }

        void add(int i) {
            if (this.size == this.data.length) {
                this.data = Arrays.copyOf(this.data, 2 * this.size);
            }
            this.data[this.size] = i;
            ++this.size;
        }
    }
}

