/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d;

import java.util.Enumeration;
import org.scijava.java3d.BoundingLeaf;
import org.scijava.java3d.Bounds;
import org.scijava.java3d.CapabilityNotSetException;
import org.scijava.java3d.Group;
import org.scijava.java3d.J3dI18N;
import org.scijava.java3d.Leaf;
import org.scijava.java3d.ModelClipRetained;
import org.scijava.java3d.Node;
import org.scijava.java3d.NodeReferenceTable;
import org.scijava.java3d.SceneGraphObject;
import org.scijava.vecmath.Vector4d;

public class ModelClip
extends Leaf {
    public static final int ALLOW_INFLUENCING_BOUNDS_READ = 12;
    public static final int ALLOW_INFLUENCING_BOUNDS_WRITE = 13;
    public static final int ALLOW_PLANE_READ = 14;
    public static final int ALLOW_PLANE_WRITE = 15;
    public static final int ALLOW_ENABLE_READ = 16;
    public static final int ALLOW_ENABLE_WRITE = 17;
    public static final int ALLOW_SCOPE_READ = 18;
    public static final int ALLOW_SCOPE_WRITE = 19;
    private static final int[] readCapabilities = new int[]{18, 16, 12, 14};

    public ModelClip() {
        this.setDefaultReadCapabilities(readCapabilities);
    }

    public ModelClip(Vector4d[] planes) {
        this.setDefaultReadCapabilities(readCapabilities);
        ((ModelClipRetained)this.retained).initPlanes(planes);
    }

    public ModelClip(Vector4d[] planes, boolean[] enables) {
        this.setDefaultReadCapabilities(readCapabilities);
        ((ModelClipRetained)this.retained).initPlanes(planes);
        ((ModelClipRetained)this.retained).initEnables(enables);
    }

    public void setInfluencingBounds(Bounds region) {
        if (this.isLiveOrCompiled() && !this.getCapability(13)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ModelClip0"));
        }
        if (this.isLive()) {
            ((ModelClipRetained)this.retained).setInfluencingBounds(region);
        } else {
            ((ModelClipRetained)this.retained).initInfluencingBounds(region);
        }
    }

    public Bounds getInfluencingBounds() {
        if (this.isLiveOrCompiled() && !this.getCapability(12)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ModelClip1"));
        }
        return ((ModelClipRetained)this.retained).getInfluencingBounds();
    }

    public void setInfluencingBoundingLeaf(BoundingLeaf region) {
        if (this.isLiveOrCompiled() && !this.getCapability(13)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ModelClip13"));
        }
        if (this.isLive()) {
            ((ModelClipRetained)this.retained).setInfluencingBoundingLeaf(region);
        } else {
            ((ModelClipRetained)this.retained).initInfluencingBoundingLeaf(region);
        }
    }

    public BoundingLeaf getInfluencingBoundingLeaf() {
        if (this.isLiveOrCompiled() && !this.getCapability(12)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ModelClip14"));
        }
        return ((ModelClipRetained)this.retained).getInfluencingBoundingLeaf();
    }

    public void setScope(Group scope, int index) {
        if (this.isLiveOrCompiled() && !this.getCapability(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ModelClip7"));
        }
        if (this.isLive()) {
            ((ModelClipRetained)this.retained).setScope(scope, index);
        } else {
            ((ModelClipRetained)this.retained).initScope(scope, index);
        }
    }

    public Group getScope(int index) {
        if (this.isLiveOrCompiled() && !this.getCapability(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ModelClip8"));
        }
        return ((ModelClipRetained)this.retained).getScope(index);
    }

    public void insertScope(Group scope, int index) {
        if (this.isLiveOrCompiled() && !this.getCapability(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ModelClip9"));
        }
        if (this.isLive()) {
            ((ModelClipRetained)this.retained).insertScope(scope, index);
        } else {
            ((ModelClipRetained)this.retained).initInsertScope(scope, index);
        }
    }

    public void removeScope(int index) {
        if (this.isLiveOrCompiled() && !this.getCapability(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ModelClip10"));
        }
        if (this.isLive()) {
            ((ModelClipRetained)this.retained).removeScope(index);
        } else {
            ((ModelClipRetained)this.retained).initRemoveScope(index);
        }
    }

    public Enumeration<Group> getAllScopes() {
        if (this.isLiveOrCompiled() && !this.getCapability(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ModelClip11"));
        }
        return ((ModelClipRetained)this.retained).getAllScopes();
    }

    public void addScope(Group scope) {
        if (this.isLiveOrCompiled() && !this.getCapability(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ModelClip12"));
        }
        if (this.isLive()) {
            ((ModelClipRetained)this.retained).addScope(scope);
        } else {
            ((ModelClipRetained)this.retained).initAddScope(scope);
        }
    }

    public int numScopes() {
        if (this.isLiveOrCompiled() && !this.getCapability(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ModelClip11"));
        }
        return ((ModelClipRetained)this.retained).numScopes();
    }

    public int indexOfScope(Group scope) {
        if (this.isLiveOrCompiled() && !this.getCapability(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ModelClip8"));
        }
        return ((ModelClipRetained)this.retained).indexOfScope(scope);
    }

    public void removeScope(Group scope) {
        if (this.isLiveOrCompiled() && !this.getCapability(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ModelClip10"));
        }
        if (this.isLive()) {
            ((ModelClipRetained)this.retained).removeScope(scope);
        } else {
            ((ModelClipRetained)this.retained).initRemoveScope(scope);
        }
    }

    public void removeAllScopes() {
        if (this.isLiveOrCompiled() && !this.getCapability(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ModelClip10"));
        }
        if (this.isLive()) {
            ((ModelClipRetained)this.retained).removeAllScopes();
        } else {
            ((ModelClipRetained)this.retained).initRemoveAllScopes();
        }
    }

    public void setPlanes(Vector4d[] planes) {
        if (this.isLiveOrCompiled() && !this.getCapability(15)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ModelClip2"));
        }
        if (this.isLive()) {
            ((ModelClipRetained)this.retained).setPlanes(planes);
        } else {
            ((ModelClipRetained)this.retained).initPlanes(planes);
        }
    }

    public void getPlanes(Vector4d[] planes) {
        if (this.isLiveOrCompiled() && !this.getCapability(14)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ModelClip3"));
        }
        ((ModelClipRetained)this.retained).getPlanes(planes);
    }

    public void setPlane(int planeNum, Vector4d plane) {
        if (this.isLiveOrCompiled() && !this.getCapability(15)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ModelClip2"));
        }
        if (this.isLive()) {
            ((ModelClipRetained)this.retained).setPlane(planeNum, plane);
        } else {
            ((ModelClipRetained)this.retained).initPlane(planeNum, plane);
        }
    }

    public void getPlane(int planeNum, Vector4d plane) {
        if (this.isLiveOrCompiled() && !this.getCapability(14)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ModelClip3"));
        }
        ((ModelClipRetained)this.retained).getPlane(planeNum, plane);
    }

    public void setEnables(boolean[] enables) {
        if (this.isLiveOrCompiled() && !this.getCapability(17)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ModelClip4"));
        }
        if (this.isLive()) {
            ((ModelClipRetained)this.retained).setEnables(enables);
        } else {
            ((ModelClipRetained)this.retained).initEnables(enables);
        }
    }

    public void getEnables(boolean[] enables) {
        if (this.isLiveOrCompiled() && !this.getCapability(16)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ModelClip5"));
        }
        ((ModelClipRetained)this.retained).getEnables(enables);
    }

    public void setEnable(int planeNum, boolean enable) {
        if (this.isLiveOrCompiled() && !this.getCapability(17)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ModelClip4"));
        }
        if (this.isLive()) {
            ((ModelClipRetained)this.retained).setEnable(planeNum, enable);
        } else {
            ((ModelClipRetained)this.retained).initEnable(planeNum, enable);
        }
    }

    public boolean getEnable(int planeNum) {
        if (this.isLiveOrCompiled() && !this.getCapability(16)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ModelClip5"));
        }
        return ((ModelClipRetained)this.retained).getEnable(planeNum);
    }

    @Override
    void createRetained() {
        this.retained = new ModelClipRetained();
        this.retained.setSource(this);
    }

    @Override
    public Node cloneNode(boolean forceDuplicate) {
        ModelClip c = new ModelClip();
        c.duplicateNode(this, forceDuplicate);
        return c;
    }

    @Override
    public void updateNodeReferences(NodeReferenceTable referenceTable) {
        ModelClipRetained rt = (ModelClipRetained)this.retained;
        BoundingLeaf bl = rt.getInfluencingBoundingLeaf();
        if (bl != null) {
            SceneGraphObject o = referenceTable.getNewObjectReference(bl);
            rt.initInfluencingBoundingLeaf((BoundingLeaf)o);
        }
        int num = rt.numScopes();
        for (int i = 0; i < num; ++i) {
            rt.initScope((Group)referenceTable.getNewObjectReference(rt.getScope(i)), i);
        }
    }

    @Override
    void duplicateAttributes(Node originalNode, boolean forceDuplicate) {
        super.duplicateAttributes(originalNode, forceDuplicate);
        ModelClipRetained attr = (ModelClipRetained)originalNode.retained;
        ModelClipRetained rt = (ModelClipRetained)this.retained;
        Vector4d plane = new Vector4d();
        for (int i = 5; i >= 0; --i) {
            attr.getPlane(i, plane);
            rt.initPlane(i, plane);
            rt.initEnable(i, attr.getEnable(i));
        }
        rt.initInfluencingBounds(attr.getInfluencingBounds());
        Enumeration<Group> elm = attr.getAllScopes();
        while (elm.hasMoreElements()) {
            rt.initAddScope(elm.nextElement());
        }
        rt.initInfluencingBoundingLeaf(attr.getInfluencingBoundingLeaf());
    }
}

