/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.app;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.List;
import javax.swing.JToolBar;
import org.jhotdraw.app.Application;
import org.jhotdraw.app.ApplicationModel;
import org.jhotdraw.app.View;
import org.jhotdraw.beans.AbstractBean;
import org.jhotdraw.gui.JFileURIChooser;
import org.jhotdraw.gui.URIChooser;

public abstract class AbstractApplicationModel
extends AbstractBean
implements ApplicationModel {
    protected String name;
    protected String version;
    protected String copyright;
    protected Class viewClass;
    protected String viewClassName;
    public static final String NAME_PROPERTY = "name";
    public static final String VERSION_PROPERTY = "version";
    public static final String COPYRIGHT_PROPERTY = "copyright";
    public static final String VIEW_CLASS_NAME_PROPERTY = "viewClassName";
    public static final String VIEW_CLASS_PROPERTY = "viewClass";

    public void setName(String newValue) {
        String oldValue = this.name;
        this.name = newValue;
        this.firePropertyChange(NAME_PROPERTY, oldValue, newValue);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setVersion(String newValue) {
        String oldValue = this.version;
        this.version = newValue;
        this.firePropertyChange(VERSION_PROPERTY, oldValue, newValue);
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public void setCopyright(String newValue) {
        String oldValue = this.copyright;
        this.copyright = newValue;
        this.firePropertyChange(COPYRIGHT_PROPERTY, oldValue, newValue);
    }

    @Override
    public String getCopyright() {
        return this.copyright;
    }

    public void setViewClassName(String newValue) {
        String oldValue = this.viewClassName;
        this.viewClassName = newValue;
        this.firePropertyChange(VIEW_CLASS_NAME_PROPERTY, oldValue, newValue);
    }

    public void setViewClass(Class newValue) {
        Class oldValue = this.viewClass;
        this.viewClass = newValue;
        this.firePropertyChange(VIEW_CLASS_PROPERTY, oldValue, newValue);
    }

    public Class getViewClass() {
        if (this.viewClass == null && this.viewClassName != null) {
            try {
                this.viewClass = Class.forName(this.viewClassName);
            }
            catch (Exception e) {
                InternalError error = new InternalError("unable to get view class");
                error.initCause(e);
                throw error;
            }
        }
        return this.viewClass;
    }

    @Override
    public View createView() {
        try {
            return (View)this.getViewClass().newInstance();
        }
        catch (Exception e) {
            InternalError error = new InternalError("unable to create view");
            error.initCause(e);
            throw error;
        }
    }

    @Override
    public abstract List<JToolBar> createToolBars(Application var1, @Nullable View var2);

    @Override
    public void initView(Application a, View p) {
    }

    @Override
    public void destroyView(Application a, View p) {
    }

    @Override
    public void initApplication(Application a) {
    }

    @Override
    public void destroyApplication(Application a) {
    }

    @Override
    public URIChooser createOpenChooser(Application a, @Nullable View v) {
        JFileURIChooser c = new JFileURIChooser();
        return c;
    }

    @Override
    public URIChooser createOpenDirectoryChooser(Application a, @Nullable View v) {
        JFileURIChooser c = new JFileURIChooser();
        c.setFileSelectionMode(1);
        return c;
    }

    @Override
    public URIChooser createSaveChooser(Application a, @Nullable View v) {
        JFileURIChooser c = new JFileURIChooser();
        return c;
    }

    @Override
    public URIChooser createImportChooser(Application a, @Nullable View v) {
        return this.createOpenChooser(a, v);
    }

    @Override
    public URIChooser createExportChooser(Application a, @Nullable View v) {
        return this.createSaveChooser(a, v);
    }
}

