/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import com.github.fommil.netlib.LAPACK;
import no.uib.cipr.matrix.AbstractPackMatrix;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.LowerSPDPackMatrix;
import no.uib.cipr.matrix.LowerTriangPackMatrix;
import no.uib.cipr.matrix.Matrices;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixNotSPDException;
import no.uib.cipr.matrix.UpLo;
import no.uib.cipr.matrix.UpperSPDPackMatrix;
import no.uib.cipr.matrix.UpperTriangPackMatrix;
import org.netlib.util.doubleW;
import org.netlib.util.intW;

public class PackCholesky {
    private final int n;
    private LowerTriangPackMatrix Cl;
    private UpperTriangPackMatrix Cu;
    private boolean notspd;
    private final boolean upper;

    public PackCholesky(int n, boolean upper) {
        this.n = n;
        this.upper = upper;
        if (upper) {
            this.Cu = new UpperTriangPackMatrix(n);
        } else {
            this.Cl = new LowerTriangPackMatrix(n);
        }
    }

    public static PackCholesky factorize(Matrix A) {
        return new PackCholesky(A.numRows(), true).factor(new UpperSPDPackMatrix(A));
    }

    public PackCholesky factor(LowerSPDPackMatrix A) {
        if (this.upper) {
            throw new IllegalArgumentException("Cholesky decomposition constructed for upper matrices");
        }
        return this.decompose(A);
    }

    public PackCholesky factor(UpperSPDPackMatrix A) {
        if (!this.upper) {
            throw new IllegalArgumentException("Cholesky decomposition constructed for lower matrices");
        }
        return this.decompose(A);
    }

    private PackCholesky decompose(AbstractPackMatrix A) {
        if (this.n != A.numRows()) {
            throw new IllegalArgumentException("n != A.numRows()");
        }
        this.notspd = false;
        intW info = new intW(0);
        if (this.upper) {
            LAPACK.getInstance().dpptrf(UpLo.Upper.netlib(), A.numRows(), A.getData(), info);
        } else {
            LAPACK.getInstance().dpptrf(UpLo.Lower.netlib(), A.numRows(), A.getData(), info);
        }
        if (info.val > 0) {
            this.notspd = true;
        } else if (info.val < 0) {
            throw new IllegalArgumentException();
        }
        if (this.upper) {
            this.Cu.set(A);
        } else {
            this.Cl.set(A);
        }
        return this;
    }

    public boolean isSPD() {
        return !this.notspd;
    }

    public LowerTriangPackMatrix getL() {
        if (!this.upper) {
            return this.Cl;
        }
        throw new UnsupportedOperationException();
    }

    public UpperTriangPackMatrix getU() {
        if (this.upper) {
            return this.Cu;
        }
        throw new UnsupportedOperationException();
    }

    public DenseMatrix solve(DenseMatrix B) throws MatrixNotSPDException {
        if (this.notspd) {
            throw new MatrixNotSPDException();
        }
        if (B.numRows() != this.n) {
            throw new IllegalArgumentException("B.numRows() != n");
        }
        intW info = new intW(0);
        if (this.upper) {
            LAPACK.getInstance().dpptrs(UpLo.Upper.netlib(), this.Cu.numRows(), B.numColumns(), this.Cu.getData(), B.getData(), Matrices.ld(this.Cu.numRows()), info);
        } else {
            LAPACK.getInstance().dpptrs(UpLo.Lower.netlib(), this.Cl.numRows(), B.numColumns(), this.Cl.getData(), B.getData(), Matrices.ld(this.Cl.numRows()), info);
        }
        if (info.val < 0) {
            throw new IllegalArgumentException();
        }
        return B;
    }

    public double rcond(Matrix A) {
        if (A.numRows() != this.n) {
            throw new IllegalArgumentException("A.numRows() != n");
        }
        if (!A.isSquare()) {
            throw new IllegalArgumentException("!A.isSquare()");
        }
        double anorm = A.norm(Matrix.Norm.One);
        double[] work = new double[3 * this.n];
        int[] iwork = new int[this.n];
        intW info = new intW(0);
        doubleW rcond = new doubleW(0.0);
        if (this.upper) {
            LAPACK.getInstance().dppcon(UpLo.Upper.netlib(), this.n, this.Cu.getData(), anorm, rcond, work, iwork, info);
        } else {
            LAPACK.getInstance().dppcon(UpLo.Lower.netlib(), this.n, this.Cl.getData(), anorm, rcond, work, iwork, info);
        }
        if (info.val < 0) {
            throw new IllegalArgumentException();
        }
        return rcond.val;
    }
}

