/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.spim;

import fiji.plugin.timelapsedisplay.RegistrationStatistics;
import ij.ImageJ;
import java.util.ArrayList;
import java.util.Date;
import mpicbg.models.CoordinateTransform;
import mpicbg.models.Point;
import mpicbg.spim.io.ConfigurationParserException;
import mpicbg.spim.io.ConfigurationParserGeneral;
import mpicbg.spim.io.ConfigurationParserSPIM;
import mpicbg.spim.io.IOFunctions;
import mpicbg.spim.io.ProgramConfiguration;
import mpicbg.spim.io.SPIMConfiguration;
import mpicbg.spim.registration.ViewDataBeads;
import mpicbg.spim.registration.ViewStructure;
import mpicbg.spim.registration.bead.Bead;
import mpicbg.spim.registration.bead.BeadIdentification;
import mpicbg.spim.registration.bead.BeadRegistration;

public class Reconstruction {
    protected final SPIMConfiguration conf;
    ArrayList<RegistrationStatistics> stats;
    ViewStructure currentViewStructure = null;

    public SPIMConfiguration getSPIMConfiguration() {
        return this.conf;
    }

    public ArrayList<RegistrationStatistics> getRegistrationStatistics() {
        return this.stats;
    }

    public ViewStructure getCurrentViewStructure() {
        return this.currentViewStructure;
    }

    public Reconstruction(SPIMConfiguration conf) {
        IOFunctions.println("Version 0.55");
        this.conf = conf;
        if (conf.collectRegistrationStatistics) {
            this.stats = new ArrayList();
        }
        if (conf.timeLapseRegistration) {
            this.processTimeLapse(conf);
        } else {
            this.processIndividualViewStructure(conf);
        }
    }

    protected void findAllRansacCorrespondencesRecurively(Bead bead, ArrayList<Bead> correspondingBeadList) {
        if (bead.isUsed()) {
            return;
        }
        correspondingBeadList.add(bead);
        bead.setUsed(true);
        ArrayList ransacList = bead.getRANSACCorrespondence();
        for (BeadIdentification correspondence : ransacList) {
            Bead correspondingBead = correspondence.getBead();
            if (correspondingBead.isUsed()) continue;
            this.findAllRansacCorrespondencesRecurively(correspondingBead, correspondingBeadList);
        }
    }

    protected ArrayList<Bead> getAveragedBeadList(ArrayList<ViewDataBeads> views, ViewDataBeads newView) {
        ArrayList<Bead> averagedBeadList = new ArrayList<Bead>();
        BeadRegistration.concatenateAxialScaling(views, 2);
        for (ViewDataBeads view : views) {
            ArrayList<Bead> beadList = view.getBeadStructure().getBeadList();
            for (Bead bead : beadList) {
                ArrayList<Bead> correspondingBeadList = new ArrayList<Bead>();
                this.findAllRansacCorrespondencesRecurively(bead, correspondingBeadList);
                if (correspondingBeadList.size() <= 1) continue;
                Point location = new Point(new double[]{0.0, 0.0, 0.0});
                for (Bead correspondingBead : correspondingBeadList) {
                    correspondingBead.apply((CoordinateTransform)correspondingBead.getView().getTile().getModel());
                    double[] dArray = location.getW();
                    dArray[0] = dArray[0] + correspondingBead.getW()[0];
                    double[] dArray2 = location.getW();
                    dArray2[1] = dArray2[1] + correspondingBead.getW()[1];
                    double[] dArray3 = location.getW();
                    dArray3[2] = dArray3[2] + correspondingBead.getW()[2];
                }
                double[] dArray = location.getW();
                dArray[0] = dArray[0] / (double)correspondingBeadList.size();
                double[] dArray4 = location.getW();
                dArray4[1] = dArray4[1] / (double)correspondingBeadList.size();
                double[] dArray5 = location.getW();
                dArray5[2] = dArray5[2] / (double)correspondingBeadList.size();
                averagedBeadList.add(new Bead(averagedBeadList.size(), (double[])location.getW().clone(), newView));
            }
        }
        for (ViewDataBeads view : views) {
            for (Bead bead : view.getBeadStructure().getBeadList()) {
                bead.setUsed(false);
            }
        }
        return averagedBeadList;
    }

    protected void processTimeLapse(SPIMConfiguration conf) {
        for (int timePointIndex = 0; timePointIndex < conf.file.length; ++timePointIndex) {
            ViewStructure reference = ViewStructure.initViewStructure(conf, conf.getTimePointIndex(conf.referenceTimePoint), conf.getModel(), "Reference ViewStructure Timepoint " + conf.referenceTimePoint, conf.debugLevelInt);
            this.currentViewStructure = ViewStructure.initViewStructure(conf, timePointIndex, conf.getModel(), "Template ViewStructure Timepoint " + conf.timepoints[timePointIndex], conf.debugLevelInt);
            if (reference.getDebugLevel() <= 1) {
                IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Loading reference timepoint information " + reference);
            }
            reference.loadDimensions();
            reference.loadSegmentations();
            reference.loadRegistrations();
            if (reference.getDebugLevel() <= 1) {
                IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Loading timepoint " + this.currentViewStructure + " information");
            }
            this.currentViewStructure.loadDimensions();
            this.currentViewStructure.loadSegmentations();
            int id = reference.getViews().get(0).getID();
            for (ViewDataBeads view : reference.getViews()) {
                if (view.getID() < id) continue;
                id = view.getID() + 1;
            }
            for (ViewDataBeads view : this.currentViewStructure.getViews()) {
                view.setID(id++);
                if (reference.getDebugLevel() > 0) continue;
                IOFunctions.println(view + ", updated id");
            }
            boolean readReg = conf.readRegistration;
            if (readReg) {
                for (ViewDataBeads view : this.currentViewStructure.getViews()) {
                    if (!(readReg &= view.loadRegistrationTimePoint(reference.getTimePoint()))) break;
                }
            }
            if (!readReg) {
                reference.getBeadRegistration().registerViewStructure(this.currentViewStructure);
            }
            BeadRegistration.concatenateAxialScaling(reference.getViews(), reference.getDebugLevel());
            BeadRegistration.concatenateAxialScaling(this.currentViewStructure.getViews(), this.currentViewStructure.getDebugLevel());
            this.addExternalTransformation(this.currentViewStructure);
            this.addExternalTransformation(reference);
            if (conf.getTimePointIndex(conf.referenceTimePoint) == timePointIndex && !conf.fuseReferenceTimepoint) continue;
            if (!conf.registerOnly) {
                IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Starting Fusion for timepoint " + conf.timepoints[timePointIndex]);
                this.currentViewStructure.getFusionControl().fuse(this.currentViewStructure, reference, this.currentViewStructure.getTimePoint());
                IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Finished Fusion for timepoint " + conf.timepoints[timePointIndex]);
            }
            if (!conf.isDeconvolution) {
                for (ViewDataBeads view : this.currentViewStructure.getViews()) {
                    view.closeImage();
                }
                continue;
            }
            conf.instance.deconvolve(this.currentViewStructure, conf, this.currentViewStructure.getTimePoint());
        }
    }

    protected void processIndividualViewStructure(SPIMConfiguration conf) {
        for (int timePointIndex = 0; timePointIndex < conf.file.length; ++timePointIndex) {
            this.currentViewStructure = ViewStructure.initViewStructure(conf, timePointIndex, conf.getModel(), "ViewStructure Timepoint " + timePointIndex, conf.debugLevelInt);
            if (this.currentViewStructure == null) continue;
            if (this.currentViewStructure.getDebugLevel() <= 1) {
                IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Starting Bead Extraction");
            }
            boolean dimSuccess = false;
            boolean segSuccess = false;
            if (this.currentViewStructure.getSPIMConfiguration().readSegmentation) {
                dimSuccess = this.currentViewStructure.loadDimensions();
                if (!dimSuccess) {
                    if (this.currentViewStructure.getDebugLevel() <= 2) {
                        IOFunctions.println("Cannot find files for " + this.currentViewStructure);
                    }
                    return;
                }
                segSuccess = this.currentViewStructure.loadSegmentations();
            }
            if (!segSuccess) {
                this.currentViewStructure.getBeadSegmentation().segment();
            }
            if (this.currentViewStructure.getDebugLevel() <= 1) {
                IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Finished Bead Extraction");
            }
            if (this.currentViewStructure.getDebugLevel() <= 1) {
                IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Starting Registration");
            }
            boolean regSuccess = false;
            if (this.currentViewStructure.getSPIMConfiguration().readRegistration) {
                regSuccess = this.currentViewStructure.loadRegistrations();
            }
            if (!regSuccess) {
                this.currentViewStructure.getBeadRegistration().registerViews();
            }
            if (conf.doFit == 2) {
                do {
                    this.currentViewStructure.getBeadSegmentation().reLocalizeTrueCorrespondences(true);
                    this.currentViewStructure.getGlobalErrorStatistics().reset();
                    for (ViewDataBeads view : this.currentViewStructure.getViews()) {
                        view.initErrorStatistics();
                        view.getBeadStructure().clearAllRANSACCorrespondences();
                    }
                    this.currentViewStructure.getBeadRegistration().registerViews();
                } while (this.currentViewStructure.getBeadSegmentation().reLocalizeTrueCorrespondences(false) > 0);
                for (ViewDataBeads view : this.currentViewStructure.getViews()) {
                    view.closeImage();
                }
            }
            BeadRegistration.concatenateAxialScaling(this.currentViewStructure.getViews(), this.currentViewStructure.getDebugLevel());
            if (this.currentViewStructure.getDebugLevel() <= 1) {
                IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Finished Registration");
            }
            this.addExternalTransformation(this.currentViewStructure);
            if (!conf.registerOnly) {
                IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Starting Fusion");
                this.currentViewStructure.getFusionControl().fuse(this.currentViewStructure, conf.timepoints[timePointIndex]);
                if (!conf.isDeconvolution) {
                    IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Finished Fusion");
                }
            }
            if (!conf.isDeconvolution) {
                for (ViewDataBeads view : this.currentViewStructure.getViews()) {
                    view.closeImage();
                }
            } else {
                conf.instance.deconvolve(this.currentViewStructure, conf, conf.timepoints[timePointIndex]);
            }
            if (conf.collectRegistrationStatistics) {
                this.stats.add(new RegistrationStatistics(this.currentViewStructure));
            }
            if (conf.isDeconvolution) continue;
            IOFunctions.println("Finished processing.");
        }
    }

    protected void addExternalTransformation(ViewStructure viewStructure) {
    }

    public static void main(String[] args) {
        SPIMConfiguration config = null;
        try {
            String temp = args == null || args.length == 0 || args[0].trim().length() < 1 ? "spimconfig/configuration.txt" : args[0].trim();
            config = ConfigurationParserSPIM.parseFile(temp);
            if (config.debugLevelInt <= 0) {
                config.printProperties();
            }
        }
        catch (ConfigurationParserException e) {
            IOFunctions.println("Cannot open SPIM configuration file: \n" + e);
            e.printStackTrace();
            return;
        }
        if (config.showImageJWindow) {
            ProgramConfiguration conf = null;
            try {
                conf = ConfigurationParserGeneral.parseFile("config/configuration.txt");
            }
            catch (Exception e) {
                IOFunctions.println("Cannot open configuration file: \n" + e);
            }
            if (conf != null) {
                System.getProperties().setProperty("plugins.dir", conf.pluginsDir);
                String[] params = new String[]{"-ijpath " + conf.pluginsDir};
                ImageJ.main((String[])params);
            } else {
                String[] params = new String[]{"-ijpath ."};
                ImageJ.main((String[])params);
            }
        }
        new Reconstruction(config);
    }
}

