/*
 * Decompiled with CFR 0.152.
 */
package spim.fiji.plugin.thinout;

import ij.ImageJ;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.imglib2.util.ValuePair;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYBarPainter;
import org.jfree.chart.renderer.xy.XYBarPainter;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.ui.ApplicationFrame;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import spim.fiji.plugin.thinout.MouseListenerValue;

public class Histogram
extends ApplicationFrame {
    private static final long serialVersionUID = 1L;
    protected double min;
    protected double max;

    public Histogram(List<Double> values, int numBins, String title, String units) {
        super(title);
        IntervalXYDataset dataset = this.createDataset(values, numBins, title);
        JFreeChart chart = this.createChart(dataset, title, units);
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.addChartMouseListener((ChartMouseListener)new MouseListenerValue(chartPanel, this.getMin() + (this.getMax() - this.getMin()) / 2.0));
        chartPanel.setPreferredSize(new Dimension(600, 270));
        this.setContentPane((Container)chartPanel);
    }

    public void showHistogram() {
        this.pack();
        Histogram.centerFrameOnScreen((Window)((Object)this));
        this.setVisible(true);
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public static ValuePair<Double, Double> getMinMax(List<Double> data) {
        double min = data.get(0);
        double max = data.get(0);
        for (double v : data) {
            min = Math.min(min, v);
            max = Math.max(max, v);
        }
        return new ValuePair((Object)min, (Object)max);
    }

    public static List<ValuePair<Double, Integer>> binData(List<Double> data, double min, double max, int numBins) {
        double size = max - min + 1.0E-6;
        int[] bins = new int[numBins];
        for (double v : data) {
            int n = (int)Math.floor((v - min) / size * (double)numBins);
            bins[n] = bins[n] + 1;
        }
        ArrayList<ValuePair<Double, Integer>> hist = new ArrayList<ValuePair<Double, Integer>>();
        double binSize = size / (double)numBins;
        for (int bin = 0; bin < numBins; ++bin) {
            hist.add((ValuePair<Double, Integer>)new ValuePair((Object)(min + binSize / 2.0 + binSize * (double)bin), (Object)bins[bin]));
        }
        return hist;
    }

    protected IntervalXYDataset createDataset(List<Double> values, int numBins, String title) {
        XYSeries series = new XYSeries((Comparable)((Object)title));
        ValuePair<Double, Double> minmax = Histogram.getMinMax(values);
        this.min = (Double)minmax.getA();
        this.max = (Double)minmax.getB();
        List<ValuePair<Double, Integer>> hist = Histogram.binData(values, this.min, this.max, numBins);
        for (ValuePair<Double, Integer> pair : hist) {
            series.add((Number)pair.getA(), (Number)pair.getB());
        }
        XYSeriesCollection dataset = new XYSeriesCollection(series);
        dataset.setAutoWidth(true);
        return dataset;
    }

    protected JFreeChart createChart(IntervalXYDataset dataset, String title, String units) {
        JFreeChart chart = ChartFactory.createXYBarChart((String)title, (String)("Distance [" + units + "]"), (boolean)false, (String)"Count", (IntervalXYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
        NumberAxis range = (NumberAxis)chart.getXYPlot().getDomainAxis();
        range.setRange(this.getMin(), this.getMax());
        XYPlot plot = chart.getXYPlot();
        XYBarRenderer renderer = (XYBarRenderer)plot.getRenderer();
        renderer.setSeriesPaint(0, (Paint)Color.red);
        renderer.setDrawBarOutline(true);
        renderer.setSeriesOutlinePaint(0, (Paint)Color.black);
        renderer.setBarPainter((XYBarPainter)new StandardXYBarPainter());
        return chart;
    }

    public void windowClosing(WindowEvent evt) {
        if (evt.getWindow() == this) {
            this.dispose();
        }
    }

    public static void main(String[] args) {
        new ImageJ();
        ArrayList<Double> values = new ArrayList<Double>();
        Random rnd = new Random();
        for (int i = 0; i < 10000; ++i) {
            values.add(rnd.nextGaussian());
        }
        Histogram demo = new Histogram(values, 100, "Histogram for ...", "pixels");
        demo.pack();
        Histogram.centerFrameOnScreen((Window)((Object)demo));
        demo.setVisible(true);
    }

    private static void centerFrameOnScreen(Window frame) {
        Histogram.positionFrameOnScreen(frame, 0.5, 0.5);
    }

    private static void positionFrameOnScreen(Window frame, double horizontalPercent, double verticalPercent) {
        Rectangle s = frame.getGraphicsConfiguration().getBounds();
        Dimension f = frame.getSize();
        int w = Math.max(s.width - f.width, 0);
        int h = Math.max(s.height - f.height, 0);
        int x = (int)(horizontalPercent * (double)w) + s.x;
        int y = (int)(verticalPercent * (double)h) + s.y;
        frame.setBounds(x, y, f.width, f.height);
    }
}

