/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.detection;

import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.Settings;
import fiji.plugin.trackmate.detection.DetectionUtils;
import fiji.plugin.trackmate.detection.LabelImageDetector;
import fiji.plugin.trackmate.detection.SpotDetector;
import fiji.plugin.trackmate.detection.SpotDetectorFactory;
import fiji.plugin.trackmate.detection.ThresholdDetectorFactory;
import fiji.plugin.trackmate.gui.components.ConfigurationPanel;
import fiji.plugin.trackmate.gui.components.detector.LabelImageDetectorConfigurationPanel;
import fiji.plugin.trackmate.util.TMUtils;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import net.imagej.ImgPlus;
import net.imglib2.Interval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import org.scijava.plugin.Plugin;

@Plugin(type=SpotDetectorFactory.class)
public class LabelImageDetectorFactory<T extends RealType<T> & NativeType<T>>
implements SpotDetectorFactory<T> {
    public static final String DETECTOR_KEY = "LABEL_IMAGE_DETECTOR";
    public static final String NAME = "Label image detector";
    public static final String INFO_TEXT = "<html>This detector creates spots by importing regions from a label image.<p>A label image is an image where the pixel values are integers. Each object in a label image is represented by a single common pixel value (the label) that is unique to the object.<p>This detector reads such an image and create spots from each object. In 2D the contour of a label is imported. In 3D, spherical spots of the same volume that the label are created.<p>The spot quality stores the object area or volume in pixels.</html>";
    public static final String URL_DOC = "https://imagej.net/plugins/trackmate/detectors/trackmate-label-image-detector";

    @Override
    public SpotDetector<T> getDetector(ImgPlus<T> img, Map<String, Object> settings, Interval interval, int frame) {
        boolean simplifyContours = (Boolean)settings.get("SIMPLIFY_CONTOURS");
        double[] calibration = TMUtils.getSpatialCalibration(img);
        int channel = (Integer)settings.get("TARGET_CHANNEL") - 1;
        RandomAccessibleInterval<T> imFrame = DetectionUtils.prepareFrameImg(img, channel, frame);
        LabelImageDetector<T> detector = new LabelImageDetector<T>(imFrame, interval, calibration, simplifyContours);
        return detector;
    }

    @Override
    public Map<String, Object> getDefaultSettings() {
        HashMap<String, Object> lSettings = new HashMap<String, Object>();
        lSettings.put("TARGET_CHANNEL", 1);
        lSettings.put("SIMPLIFY_CONTOURS", true);
        return lSettings;
    }

    @Override
    public ConfigurationPanel getDetectorConfigurationPanel(Settings lSettings, Model model) {
        return new LabelImageDetectorConfigurationPanel(lSettings, model);
    }

    @Override
    public boolean has2Dsegmentation() {
        return true;
    }

    @Override
    public String getKey() {
        return DETECTOR_KEY;
    }

    @Override
    public String getInfoText() {
        return INFO_TEXT;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getUrl() {
        return URL_DOC;
    }

    @Override
    public ImageIcon getIcon() {
        return ThresholdDetectorFactory.ICON;
    }
}

