/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.features.spot;

import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.features.spot.AbstractSpotFeatureAnalyzer;
import fiji.plugin.trackmate.features.spot.SpotIntensityMultiCAnalyzerFactory;
import fiji.plugin.trackmate.util.SpotUtil;
import fiji.plugin.trackmate.util.TMUtils;
import net.imagej.ImgPlus;
import net.imglib2.IterableInterval;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Util;
import org.scijava.util.DoubleArray;

public class SpotIntensityMultiCAnalyzer<T extends RealType<T>>
extends AbstractSpotFeatureAnalyzer<T> {
    private final int channel;
    private final ImgPlus<T> imgCT;

    public SpotIntensityMultiCAnalyzer(ImgPlus<T> imgCT, int channel) {
        this.imgCT = imgCT;
        this.channel = channel;
    }

    @Override
    public void process(Spot spot) {
        double std;
        double sum;
        double min;
        double max;
        double median;
        double mean;
        IterableInterval<T> neighborhood = SpotUtil.iterable(spot, this.imgCT);
        DoubleArray intensities = new DoubleArray();
        for (RealType pixel : neighborhood) {
            double val = pixel.getRealDouble();
            if (Double.isNaN(val)) continue;
            intensities.addValue(val);
        }
        if (intensities.isEmpty()) {
            mean = Double.NaN;
            median = Double.NaN;
            max = Double.NaN;
            min = Double.NaN;
            sum = Double.NaN;
            std = Double.NaN;
        } else {
            Util.quicksort((double[])intensities.getArray(), (int)0, (int)(intensities.size() - 1));
            mean = TMUtils.average(intensities);
            median = intensities.getArray()[intensities.size() / 2];
            min = intensities.getArray()[0];
            max = intensities.getArray()[intensities.size() - 1];
            sum = TMUtils.sum(intensities);
            std = TMUtils.standardDeviation(intensities);
        }
        spot.putFeature(SpotIntensityMultiCAnalyzerFactory.makeFeatureKey("MEAN_INTENSITY_CH", this.channel), mean);
        spot.putFeature(SpotIntensityMultiCAnalyzerFactory.makeFeatureKey("MEDIAN_INTENSITY_CH", this.channel), median);
        spot.putFeature(SpotIntensityMultiCAnalyzerFactory.makeFeatureKey("MIN_INTENSITY_CH", this.channel), min);
        spot.putFeature(SpotIntensityMultiCAnalyzerFactory.makeFeatureKey("MAX_INTENSITY_CH", this.channel), max);
        spot.putFeature(SpotIntensityMultiCAnalyzerFactory.makeFeatureKey("TOTAL_INTENSITY_CH", this.channel), sum);
        spot.putFeature(SpotIntensityMultiCAnalyzerFactory.makeFeatureKey("STD_INTENSITY_CH", this.channel), std);
    }
}

