/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.gui.editor.labkit.component;

import bdv.ui.keymap.Keymap;
import bdv.ui.keymap.KeymapManager;
import fiji.plugin.trackmate.gui.editor.labkit.component.TMLabKitFrame;
import fiji.plugin.trackmate.util.TMUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import org.scijava.Context;
import org.scijava.ui.behaviour.io.InputTriggerConfig;
import org.scijava.ui.behaviour.io.gui.CommandDescriptionProvider;
import org.scijava.ui.behaviour.io.gui.CommandDescriptionsBuilder;
import org.scijava.ui.behaviour.io.yaml.YamlConfigIO;

public class TMKeymapManager
extends KeymapManager {
    private static final String DEFAULT_KEYMAP_PATH = "/keymaps/Default-BDV.yaml";

    public TMKeymapManager() {
        super(TMLabKitFrame.KEYMAP_HOME);
    }

    static Keymap loadBDVKeymap() {
        Keymap keymap;
        InputStream inputStream = TMKeymapManager.class.getResourceAsStream(DEFAULT_KEYMAP_PATH);
        if (inputStream == null) {
            System.out.println("Critical error: Required keymap file not found: /keymaps/Default-BDV.yaml\nThis indicates a corrupted installation or missing resource file.\nExpected location in JAR: /keymaps/Default-BDV.yaml");
            return null;
        }
        InputStreamReader reader = new InputStreamReader(inputStream);
        try {
            keymap = new Keymap("Default", new InputTriggerConfig((Collection)YamlConfigIO.read((Reader)reader)));
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                System.err.println("Failed to load the default keymap in /keymaps/Default-BDV.yaml");
                System.err.println("Using builtin keymap. Error was:");
                e.printStackTrace();
                return null;
            }
        }
        reader.close();
        return keymap;
    }

    public synchronized void discoverCommandDescriptions() {
        CommandDescriptionsBuilder builder = new CommandDescriptionsBuilder();
        Context context = TMUtils.getContext();
        context.inject((Object)builder);
        builder.discoverProviders(new CommandDescriptionProvider.Scope[]{TMLabKitFrame.KEY_CONFIG_SCOPE});
        this.setCommandDescriptions(builder.build());
    }
}

