/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.util.cli;

import fiji.plugin.trackmate.gui.Fonts;
import fiji.plugin.trackmate.gui.GuiUtils;
import fiji.plugin.trackmate.gui.components.ConfigurationPanel;
import fiji.plugin.trackmate.util.cli.ConfigGuiBuilder;
import fiji.plugin.trackmate.util.cli.Configurator;
import fiji.plugin.trackmate.util.cli.TrackMateSettingsBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class GenericConfigurationPanel
extends ConfigurationPanel {
    private static final long serialVersionUID = 1L;
    protected final ConfigGuiBuilder.ConfigPanel mainPanel;
    protected final Configurator config;

    public GenericConfigurationPanel(Configurator config, String title, Icon icon, String docURL) {
        this.config = config;
        BorderLayout borderLayout = new BorderLayout();
        this.setLayout(borderLayout);
        JPanel header = new JPanel();
        header.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        header.setLayout(new BoxLayout(header, 1));
        JLabel lblDetector = new JLabel(title, icon, 4);
        lblDetector.setFont(Fonts.BIG_FONT);
        lblDetector.setHorizontalAlignment(0);
        lblDetector.setAlignmentX(0.5f);
        header.add(lblDetector);
        if (docURL != null) {
            JEditorPane infoDisplay = GuiUtils.infoDisplay("<html>Documentation for this module <a href=\"" + docURL + "\">on the ImageJ Wiki</a>.</html>", false);
            infoDisplay.setMaximumSize(new Dimension(100000, 40));
            header.add(Box.createVerticalStrut(5));
            header.add(infoDisplay);
        }
        this.add((Component)header, "North");
        this.mainPanel = ConfigGuiBuilder.build(config);
        JScrollPane scrollPane = new JScrollPane(this.mainPanel, 20, 31);
        scrollPane.setBorder(null);
        scrollPane.getVerticalScrollBar().setUnitIncrement(16);
        this.add((Component)scrollPane, "Center");
    }

    @Override
    public void setSettings(Map<String, Object> settings) {
        try {
            TrackMateSettingsBuilder.fromTrackMateSettings(settings, this.config);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.mainPanel.refresh();
        }
    }

    @Override
    public Map<String, Object> getSettings() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        TrackMateSettingsBuilder.toTrackMateSettings(map, this.config);
        return map;
    }

    @Override
    public void clean() {
    }
}

