/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.util.cli.condapath;

import fiji.plugin.trackmate.gui.Fonts;
import fiji.plugin.trackmate.gui.GuiUtils;
import fiji.plugin.trackmate.gui.Icons;
import fiji.plugin.trackmate.util.TMUtils;
import fiji.plugin.trackmate.util.cli.CLIUtils;
import fiji.plugin.trackmate.util.cli.condapath.CondaDetector;
import ij.IJ;
import ij.ImageJ;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.scijava.command.Command;
import org.scijava.command.CommandService;
import org.scijava.plugin.Plugin;
import org.scijava.prefs.PrefService;

@Plugin(type=Command.class, label="Configure the path to the Conda executable used in TrackMate...", iconPath="/icons/commands/information.png", menuPath="Edit > Options > Configure TrackMate Conda path...")
public class CondaPathConfigCommand
implements Command {
    public void run() {
        SwingUtilities.invokeLater(() -> this.createAndShowDialog());
    }

    private void createAndShowDialog() {
        String findPath;
        PrefService prefs = (PrefService)TMUtils.getContext().getService(PrefService.class);
        try {
            findPath = CLIUtils.findDefaultCondaPath();
        }
        catch (IllegalArgumentException e2) {
            findPath = "/usr/local/opt/micromamba/bin/micromamba";
        }
        String condaPath = prefs.get(CLIUtils.class, "trackmate.conda.path", findPath);
        Path path = Paths.get(condaPath, new String[0]);
        Path parent = path.getParent();
        Path parentOfParent = parent != null ? parent.getParent() : null;
        String defaultValue = "/usr/local/opt/micromamba/";
        String condaRootPrefix = parentOfParent != null ? parentOfParent.toString() : "/usr/local/opt/micromamba/";
        condaRootPrefix = prefs.get(CLIUtils.class, "trackmate.conda.root.prefix", condaRootPrefix);
        JDialog dialog = new JDialog((Frame)IJ.getInstance(), "TrackMate Conda Configuration", false);
        dialog.setIconImage(Icons.TRACKMATE_ICON.getImage());
        dialog.setDefaultCloseOperation(2);
        JPanel mainPanel = new JPanel(new BorderLayout(10, 10));
        mainPanel.setBorder(new EmptyBorder(15, 15, 15, 15));
        mainPanel.setBackground(Color.WHITE);
        JPanel headerPanel = this.createHeaderPanel();
        mainPanel.add((Component)headerPanel, "North");
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout(new BoxLayout(centerPanel, 1));
        centerPanel.setBackground(Color.WHITE);
        JTextArea statusArea = new JTextArea(2, 50);
        statusArea.setEditable(false);
        statusArea.setLineWrap(true);
        statusArea.setWrapStyleWord(true);
        statusArea.setFont(new Font("SansSerif", 0, 11));
        statusArea.setForeground(new Color(60, 120, 180));
        statusArea.setBackground(new Color(240, 248, 255));
        statusArea.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(180, 200, 220)), new EmptyBorder(5, 8, 5, 8)));
        statusArea.setText("Configure conda paths or use auto-detection");
        JScrollPane statusScrollPane = new JScrollPane(statusArea);
        statusScrollPane.setBorder(BorderFactory.createEmptyBorder());
        statusScrollPane.setMaximumSize(new Dimension(Integer.MAX_VALUE, 60));
        centerPanel.add(statusScrollPane);
        centerPanel.add(Box.createVerticalStrut(15));
        JPanel execPanel = this.createPathPanel("Conda Executable Path", "Path to the conda, mamba, or micromamba executable", condaPath);
        JTextField execField = (JTextField)execPanel.getClientProperty("textfield");
        JButton execBrowseButton = (JButton)execPanel.getClientProperty("browse");
        centerPanel.add(execPanel);
        centerPanel.add(Box.createVerticalStrut(10));
        JPanel rootPanel = this.createPathPanel("Conda Root Prefix", "Root directory of conda installation (CONDA_ROOT_PREFIX)", condaRootPrefix);
        JTextField rootField = (JTextField)rootPanel.getClientProperty("textfield");
        JButton rootBrowseButton = (JButton)rootPanel.getClientProperty("browse");
        centerPanel.add(rootPanel);
        centerPanel.add(Box.createVerticalStrut(15));
        execBrowseButton.addActionListener(e -> this.browseForFile(execField, dialog));
        rootBrowseButton.addActionListener(e -> this.browseForDirectory(rootField, dialog));
        mainPanel.add((Component)centerPanel, "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout(2, 10, 0));
        buttonPanel.setBackground(Color.WHITE);
        JButton autoDetectButton = new JButton("Auto-detect");
        autoDetectButton.setIcon(Icons.PREVIEW_ICON);
        autoDetectButton.addActionListener(e -> this.autoDetect(execField, rootField, statusArea));
        JButton diagnoseButton = new JButton("Diagnose");
        diagnoseButton.setIcon(Icons.COG_ICON);
        diagnoseButton.addActionListener(e -> this.diagnose());
        JButton testButton = new JButton("Test");
        testButton.setIcon(Icons.EXECUTE_ICON);
        testButton.addActionListener(e -> this.test(execField.getText(), rootField.getText(), statusArea));
        JButton okButton = new JButton("OK");
        okButton.addActionListener(e -> this.saveAndClose(execField.getText(), rootField.getText(), prefs, dialog));
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(e -> dialog.dispose());
        buttonPanel.add(autoDetectButton);
        buttonPanel.add(diagnoseButton);
        buttonPanel.add(testButton);
        buttonPanel.add(Box.createHorizontalStrut(20));
        buttonPanel.add(okButton);
        buttonPanel.add(cancelButton);
        mainPanel.add((Component)buttonPanel, "South");
        dialog.add(mainPanel);
        dialog.pack();
        dialog.setLocationRelativeTo((Component)IJ.getInstance());
        dialog.setVisible(true);
    }

    private JPanel createHeaderPanel() {
        JPanel headerPanel = new JPanel(new BorderLayout(10, 5));
        headerPanel.setBackground(Color.WHITE);
        JLabel iconLabel = new JLabel(GuiUtils.scaleImage(Icons.TRACKMATE_ICON, 48, 48));
        headerPanel.add((Component)iconLabel, "West");
        JPanel textPanel = new JPanel();
        textPanel.setLayout(new BoxLayout(textPanel, 1));
        textPanel.setBackground(Color.WHITE);
        JLabel titleLabel = new JLabel("Conda Configuration");
        titleLabel.setFont(Fonts.BIG_FONT);
        titleLabel.setAlignmentX(0.0f);
        JLabel subtitleLabel = new JLabel("Configure conda executable for TrackMate modules");
        subtitleLabel.setFont(Fonts.SMALL_FONT);
        subtitleLabel.setForeground(Color.GRAY);
        subtitleLabel.setAlignmentX(0.0f);
        textPanel.add(titleLabel);
        textPanel.add(Box.createVerticalStrut(3));
        textPanel.add(subtitleLabel);
        headerPanel.add((Component)textPanel, "Center");
        headerPanel.add(Box.createVerticalStrut(10), "South");
        return headerPanel;
    }

    private JPanel createPathPanel(String title, String description, String defaultPath) {
        JPanel panel = new JPanel(new BorderLayout(5, 5));
        panel.setBackground(Color.WHITE);
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(title), new EmptyBorder(5, 5, 5, 5)));
        JLabel descLabel = new JLabel(description);
        descLabel.setFont(Fonts.SMALL_FONT);
        descLabel.setForeground(Color.GRAY);
        panel.add((Component)descLabel, "North");
        JPanel inputPanel = new JPanel(new BorderLayout(5, 0));
        inputPanel.setBackground(Color.WHITE);
        JTextField textField = new JTextField(defaultPath, 40);
        textField.setFont(new Font("Monospaced", 0, 12));
        JButton browseButton = new JButton("Browse...");
        browseButton.setFocusable(false);
        inputPanel.add((Component)textField, "Center");
        inputPanel.add((Component)browseButton, "East");
        panel.add((Component)inputPanel, "Center");
        panel.putClientProperty("textfield", textField);
        panel.putClientProperty("browse", browseButton);
        return panel;
    }

    private void browseForFile(JTextField textField, JDialog parent) {
        File currentFile;
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle("Select Conda Executable");
        chooser.setFileSelectionMode(0);
        String currentPath = textField.getText();
        if (!currentPath.isEmpty() && (currentFile = new File(currentPath)).getParentFile() != null && currentFile.getParentFile().exists()) {
            chooser.setCurrentDirectory(currentFile.getParentFile());
        }
        if (chooser.showOpenDialog(parent) == 0) {
            File selected = chooser.getSelectedFile();
            textField.setText(selected.getAbsolutePath());
        }
    }

    private void browseForDirectory(JTextField textField, JDialog parent) {
        File currentDir;
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle("Select Conda Root Directory");
        chooser.setFileSelectionMode(1);
        String currentPath = textField.getText();
        if (!currentPath.isEmpty() && (currentDir = new File(currentPath)).exists()) {
            chooser.setCurrentDirectory(currentDir);
        }
        if (chooser.showOpenDialog(parent) == 0) {
            File selected = chooser.getSelectedFile();
            textField.setText(selected.getAbsolutePath());
        }
    }

    private void autoDetect(JTextField execField, JTextField rootField, JTextArea statusArea) {
        statusArea.setForeground(new Color(60, 120, 180));
        statusArea.setText("Auto-detecting conda installation...");
        new Thread(() -> {
            try {
                CondaDetector.CondaInfo condaInfo = CondaDetector.detect();
                SwingUtilities.invokeLater(() -> {
                    execField.setText(condaInfo.getCondaExecutable());
                    rootField.setText(condaInfo.getRootPrefix());
                    statusArea.setForeground(new Color(0, 128, 0));
                    statusArea.setText(String.format("\u2713 Auto-detection successful!\nFound conda %s at: %s", condaInfo.getVersion(), condaInfo.getCondaExecutable()));
                });
            }
            catch (CondaDetector.CondaNotFoundException e) {
                SwingUtilities.invokeLater(() -> {
                    statusArea.setForeground(new Color(180, 0, 0));
                    statusArea.setText("\u2717 Auto-detection failed:\n" + e.getMessage());
                });
            }
        }, "Conda-AutoDetect").start();
    }

    private void diagnose() {
        new Thread(() -> {
            IJ.log((String)"\n========== Conda Diagnostics ==========\n");
            CondaDetector.diagnose();
        }, "Conda-Diagnose").start();
    }

    private void test(String execPath, String rootPath, JTextArea statusArea) {
        statusArea.setForeground(new Color(60, 120, 180));
        statusArea.setText("Testing conda configuration...");
        new Thread(() -> {
            try {
                PrefService prefs = (PrefService)TMUtils.getContext().getService(PrefService.class);
                String oldExec = prefs.get(CLIUtils.class, "trackmate.conda.path", "");
                String oldRoot = prefs.get(CLIUtils.class, "trackmate.conda.root.prefix", "");
                prefs.put(CLIUtils.class, "trackmate.conda.path", execPath);
                prefs.put(CLIUtils.class, "trackmate.conda.root.prefix", rootPath);
                CLIUtils.clearEnvMap();
                Map<String, String> map = CLIUtils.getEnvMap();
                StringBuilder str = new StringBuilder();
                str.append("\u2713 Test successful! Found " + map.size() + " environment(s):\n");
                map.forEach((k, v) -> str.append(String.format("  \u2022 %s\n", k)));
                SwingUtilities.invokeLater(() -> {
                    statusArea.setForeground(new Color(0, 128, 0));
                    statusArea.setText(str.toString());
                });
                IJ.log((String)("\n========== Conda Test Results ==========\n" + str.toString()));
                prefs.put(CLIUtils.class, "trackmate.conda.path", oldExec);
                prefs.put(CLIUtils.class, "trackmate.conda.root.prefix", oldRoot);
                CLIUtils.clearEnvMap();
            }
            catch (IOException e) {
                SwingUtilities.invokeLater(() -> {
                    statusArea.setForeground(new Color(180, 0, 0));
                    statusArea.setText("\u2717 Test failed:\nConda executable path seems incorrect.\n" + e.getMessage());
                });
                IJ.error((String)"Conda Test Failed", (String)("Conda executable path seems to be incorrect.\nError: " + e.getMessage()));
            }
            catch (Exception e) {
                SwingUtilities.invokeLater(() -> {
                    statusArea.setForeground(new Color(180, 0, 0));
                    statusArea.setText("\u2717 Test failed:\n" + e.getMessage());
                });
                e.printStackTrace();
                IJ.error((String)"Conda Test Failed", (String)("Error when running conda.\nError: " + e.getMessage()));
            }
        }, "Conda-Test").start();
    }

    private void saveAndClose(String execPath, String rootPath, PrefService prefs, JDialog dialog) {
        prefs.put(CLIUtils.class, "trackmate.conda.path", execPath);
        prefs.put(CLIUtils.class, "trackmate.conda.root.prefix", rootPath);
        CLIUtils.clearEnvMap();
        IJ.log((String)"Conda configuration saved:");
        IJ.log((String)("  Executable: " + execPath));
        IJ.log((String)("  Root Prefix: " + rootPath));
        dialog.dispose();
    }

    public static void main(String[] args) {
        ImageJ.main((String[])args);
        ((CommandService)TMUtils.getContext().getService(CommandService.class)).run(CondaPathConfigCommand.class, false, new Object[0]);
    }
}

