/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.visualization.trackscheme;

import fiji.plugin.trackmate.Settings;
import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.util.TMUtils;
import fiji.plugin.trackmate.visualization.trackscheme.SpotIconGrabber;
import net.imagej.ImgPlus;

public class SpotImageUpdater {
    private int previousFrame;
    private int previousChannel;
    private SpotIconGrabber<?> grabber;
    private final Settings settings;

    public SpotImageUpdater(Settings settings) {
        this.settings = settings;
        this.previousFrame = -1;
        this.previousChannel = -1;
    }

    public String getImageString(Spot spot, double radiusFactor) {
        int frame = spot.getFeature("FRAME").intValue();
        int targetChannel = this.settings.imp.getC() - 1;
        if (frame != this.previousFrame || targetChannel != this.previousChannel) {
            ImgPlus img = TMUtils.rawWraps(this.settings.imp);
            ImgPlus imgCT = TMUtils.hyperSlice(img, targetChannel, frame);
            this.grabber = new SpotIconGrabber(imgCT);
            this.previousFrame = frame;
            this.previousChannel = targetChannel;
        }
        return this.grabber.getImageString(spot, radiusFactor);
    }
}

