/*
 * Decompiled with CFR 0.152.
 */
package fiji.util;

public class Levenshtein {
    protected int w;
    protected int s;
    protected int a;
    protected int d;
    protected int b;
    protected int e;

    public Levenshtein(int swap, int substitute, int add, int delete, int begin, int end) {
        this.w = swap;
        this.s = substitute;
        this.a = add;
        this.d = delete;
        this.b = begin;
        this.e = end;
    }

    protected static boolean equals(String s1, int index1, String s2, int index2) {
        return s1.charAt(index1) == s2.charAt(index2);
    }

    protected static int different(String s1, int index1, String s2, int index2) {
        return s1.charAt(index1) == s2.charAt(index2) ? 0 : 1;
    }

    public int cost(String s1, String s2) {
        int len1 = s1.length();
        int len2 = s2.length();
        int[] row0 = new int[len2 + 1];
        int[] row1 = new int[len2 + 1];
        int[] row2 = new int[len2 + 1];
        for (int j = 0; j <= len2; ++j) {
            row1[j] = Math.min(j * Math.min(this.a, this.b), (len2 - j) * this.e);
        }
        for (int i = 0; i < len1; ++i) {
            row2[0] = (i + 1) * this.d;
            for (int j = 0; j < len2; ++j) {
                row2[j + 1] = row1[j] + this.s * Levenshtein.different(s1, i, s2, j);
                if (i > 0 && j > 0 && Levenshtein.equals(s1, i - 1, s2, j) && Levenshtein.equals(s1, i, s2, j - 1) && row2[j + 1] > row0[j - 1] + this.w) {
                    row2[j + 1] = row0[j - 1] + this.w;
                }
                if (row2[j + 1] > row1[j + 1] + this.d) {
                    row2[j + 1] = row1[j + 1] + this.d;
                }
                if (row2[j + 1] <= row2[j] + this.a) continue;
                row2[j + 1] = row2[j] + this.a;
            }
            int[] dummy = row0;
            row0 = row1;
            row1 = row2;
            row2 = dummy;
        }
        return row1[len2];
    }

    public static void main(String[] args) {
        Levenshtein levenshtein = new Levenshtein(args.length > 2 ? Integer.parseInt(args[0]) : 0, args.length > 3 ? Integer.parseInt(args[0]) : 10, args.length > 4 ? Integer.parseInt(args[0]) : 1, args.length > 5 ? Integer.parseInt(args[0]) : 5, args.length > 6 ? Integer.parseInt(args[0]) : 0, args.length > 7 ? Integer.parseInt(args[0]) : 0);
        System.out.println("distance between " + args[0] + " and " + args[1] + " is " + levenshtein.cost(args[0], args[1]));
    }
}

