/*
 * Decompiled with CFR 0.152.
 */
package fiji.util.gui;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.gui.Overlay;
import ij.gui.Roi;
import ij.gui.TextRoi;
import ij.gui.Toolbar;
import ij.util.Java2;
import ij.util.Tools;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.event.KeyListener;
import javax.swing.JComponent;

public class JImagePanel
extends JComponent
implements Cloneable {
    protected static Cursor defaultCursor = new Cursor(0);
    protected static Cursor handCursor = new Cursor(12);
    protected static Cursor moveCursor = new Cursor(13);
    protected static Cursor crosshairCursor = new Cursor(1);
    public static boolean usePointer = Prefs.usePointerCursor;
    protected ImagePlus imp;
    protected boolean imageUpdated;
    protected Rectangle srcRect;
    protected int imageWidth;
    protected int imageHeight;
    private BasicStroke listStroke;
    private static Color showAllColor = new Color(128, 255, 255);
    private static Color labelColor;
    protected ImageJ ij;
    protected double magnification;
    protected int dstWidth;
    protected int dstHeight;
    protected int xMouseStart;
    protected int yMouseStart;
    protected int xSrcStart;
    protected int ySrcStart;
    protected int flags;
    private Image offScreenImage;
    private int offScreenWidth = 0;
    private int offScreenHeight = 0;

    public JImagePanel() {
        this(new ImagePlus());
    }

    public JImagePanel(ImagePlus imp) {
        this.updateImage(imp);
        this.ij = IJ.getInstance();
        this.addKeyListener((KeyListener)this.ij);
        this.setFocusTraversalKeysEnabled(false);
    }

    public void updateImage(ImagePlus imp) {
        this.imp = imp;
        this.imageWidth = imp.getWidth();
        this.imageHeight = imp.getHeight();
        this.srcRect = new Rectangle(0, 0, this.imageWidth, this.imageHeight);
        this.setDrawingSize(this.imageWidth, this.imageHeight);
        this.magnification = 1.0;
        this.setImageUpdated();
    }

    public void update(JImagePanel ic) {
        if (ic == null || ic == this || ic.imp == null) {
            return;
        }
        if (ic.imp.getWidth() != this.imageWidth || ic.imp.getHeight() != this.imageHeight) {
            return;
        }
        this.srcRect = new Rectangle(ic.srcRect.x, ic.srcRect.y, ic.srcRect.width, ic.srcRect.height);
        this.setMagnification(ic.magnification);
        this.setDrawingSize(ic.dstWidth, ic.dstHeight);
    }

    public void setDrawingSize(int width, int height) {
        this.dstWidth = width;
        this.dstHeight = height;
        this.setSize(this.dstWidth, this.dstHeight);
    }

    public void setImageUpdated() {
        this.imageUpdated = true;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        try {
            if (this.imageUpdated) {
                this.imageUpdated = false;
                this.imp.updateImage();
            }
            Java2.setBilinearInterpolation((Graphics)g, (boolean)Prefs.interpolateScaledImages);
            Image img = this.imp.getProcessor().createImage();
            if (img != null) {
                this.waitForImage(img);
                int displayWidth = (int)((double)this.srcRect.width * this.magnification);
                int displayHeight = (int)((double)this.srcRect.height * this.magnification);
                Dimension size = this.getSize();
                int offsetX = (size.width - displayWidth) / 2;
                int offsetY = (size.height - displayHeight) / 2;
                g.translate(offsetX, offsetY);
                g.drawImage(img, 0, 0, displayWidth, displayHeight, this.srcRect.x, this.srcRect.y, this.srcRect.x + this.srcRect.width, this.srcRect.y + this.srcRect.height, null);
            }
            this.drawOverlay(g);
        }
        catch (OutOfMemoryError e) {
            IJ.outOfMemory((String)"Paint");
        }
    }

    public int getSliceNumber(String label) {
        if (label == null) {
            return -1;
        }
        int slice = -1;
        if (label.length() > 4 && label.charAt(4) == '-' && label.length() >= 14) {
            slice = (int)Tools.parseDouble((String)label.substring(0, 4), (double)-1.0);
        }
        return slice;
    }

    public void initGraphics(Graphics g, Color c) {
        if (labelColor == null) {
            int blue;
            int green;
            int red = showAllColor.getRed();
            labelColor = (red + (green = showAllColor.getGreen()) + (blue = showAllColor.getBlue())) / 3 < 128 ? Color.white : Color.black;
        }
        if (c != null) {
            g.setColor(c);
            if (this.listStroke != null) {
                ((Graphics2D)g).setStroke(this.listStroke);
            }
        } else {
            g.setColor(showAllColor);
        }
    }

    public void paintDoubleBuffered(Graphics g) {
        int srcRectWidthMag = (int)((double)this.srcRect.width * this.magnification);
        int srcRectHeightMag = (int)((double)this.srcRect.height * this.magnification);
        if (this.offScreenImage == null || this.offScreenWidth != srcRectWidthMag || this.offScreenHeight != srcRectHeightMag) {
            this.offScreenImage = this.createImage(srcRectWidthMag, srcRectHeightMag);
            this.offScreenWidth = srcRectWidthMag;
            this.offScreenHeight = srcRectHeightMag;
        }
        try {
            if (this.imageUpdated) {
                this.imageUpdated = false;
                this.imp.updateImage();
            }
            Graphics offScreenGraphics = this.offScreenImage.getGraphics();
            Java2.setBilinearInterpolation((Graphics)offScreenGraphics, (boolean)Prefs.interpolateScaledImages);
            Image img = this.imp.getProcessor().createImage();
            this.waitForImage(img);
            if (img != null) {
                offScreenGraphics.drawImage(img, 0, 0, srcRectWidthMag, srcRectHeightMag, this.srcRect.x, this.srcRect.y, this.srcRect.x + this.srcRect.width, this.srcRect.y + this.srcRect.height, null);
            }
            this.drawOverlay(offScreenGraphics);
            g.drawImage(this.offScreenImage, 0, 0, null);
        }
        catch (OutOfMemoryError e) {
            IJ.outOfMemory((String)"Paint");
        }
    }

    protected void drawOverlay(Graphics g) {
        if (this.imp != null && this.imp.getHideOverlay()) {
            return;
        }
        Overlay overlay = this.imp.getOverlay();
        if (overlay == null) {
            return;
        }
        int n = overlay.size();
        for (int i = 0; i < n; ++i) {
            Roi roi = overlay.get(i);
            this.drawRoi(g, roi);
        }
    }

    void drawRoi(Graphics g, Roi roi) {
        int type = roi.getType();
        ImagePlus imp2 = roi.getImage();
        roi.setImage(this.imp);
        Color saveColor = roi.getStrokeColor();
        if (saveColor == null) {
            roi.setStrokeColor(Toolbar.getForegroundColor());
        }
        if (roi instanceof TextRoi) {
            ((TextRoi)roi).drawOverlay(g);
        } else {
            roi.drawOverlay(g);
        }
        roi.setStrokeColor(saveColor);
        if (imp2 != null) {
            roi.setImage(imp2);
        } else {
            roi.setImage(null);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.dstWidth, this.dstHeight);
    }

    public int getModifiers() {
        return this.flags;
    }

    public int offScreenX(int sx) {
        return this.srcRect.x + (int)((double)sx / this.magnification);
    }

    public int offScreenY(int sy) {
        return this.srcRect.y + (int)((double)sy / this.magnification);
    }

    public double offScreenXD(int sx) {
        return (double)this.srcRect.x + (double)sx / this.magnification;
    }

    public double offScreenYD(int sy) {
        return (double)this.srcRect.y + (double)sy / this.magnification;
    }

    public int screenX(int ox) {
        return (int)((double)(ox - this.srcRect.x) * this.magnification);
    }

    public int screenY(int oy) {
        return (int)((double)(oy - this.srcRect.y) * this.magnification);
    }

    public int screenXD(double ox) {
        return (int)((ox - (double)this.srcRect.x) * this.magnification);
    }

    public int screenYD(double oy) {
        return (int)((oy - (double)this.srcRect.y) * this.magnification);
    }

    public double getMagnification() {
        return this.magnification;
    }

    public void setMagnification(double magnification) {
        this.setMagnification2(magnification);
    }

    protected void setMagnification2(double magnification) {
        if (magnification > 32.0) {
            magnification = 32.0;
        }
        if (magnification < 0.03125) {
            magnification = 0.03125;
        }
        this.magnification = magnification;
        this.imp.setTitle(this.imp.getTitle());
    }

    public Rectangle getSrcRect() {
        return this.srcRect;
    }

    protected void setSrcRect(Rectangle srcRect) {
        this.srcRect = srcRect;
    }

    protected void adjustSourceRect(double newMag, int x, int y) {
        int h;
        int w = (int)Math.round((double)this.dstWidth / newMag);
        if ((double)w * newMag < (double)this.dstWidth) {
            ++w;
        }
        if ((double)(h = (int)Math.round((double)this.dstHeight / newMag)) * newMag < (double)this.dstHeight) {
            ++h;
        }
        x = this.offScreenX(x);
        y = this.offScreenY(y);
        Rectangle r = new Rectangle(x - w / 2, y - h / 2, w, h);
        if (r.x < 0) {
            r.x = 0;
        }
        if (r.y < 0) {
            r.y = 0;
        }
        if (r.x + w > this.imageWidth) {
            r.x = this.imageWidth - w;
        }
        if (r.y + h > this.imageHeight) {
            r.y = this.imageHeight - h;
        }
        this.srcRect = r;
        this.setMagnification(newMag);
    }

    protected boolean waitForImage(Image image) {
        MediaTracker tracker = new MediaTracker(this);
        tracker.addImage(image, 0);
        try {
            tracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return !tracker.isErrorAny();
    }
}

